/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.printers;

import java.io.PrintWriter;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class TroffPrinter {
    private static final String REQUEST_TABLE_END = ".TE";
    private static final String REQUEST_TABLE_START = ".TS";
    private static final String REQUEST_FONT_ROMAN = "\\fR";
    private static final String REQUEST_FONT_BOLD = "\\fB";
    private static final String REQUEST_FONT_ITALIC = "\\fI";
    private static final String REQUEST_FONT_BOLD_ITALIC = "\\fBI";
    private static final String REQUEST_PARAGRAPH_TITLED = ".TP";
    private static final String REQUEST_PARAGRAPH_CURRENT_INDENTATION = ".IP";
    private static final String REQUEST_PARAGRAPH_NO_INDENTATION = ".IP \"\" 0";
    private static final String REQUEST_RESET_LEFT_MARGIN = ".RE";
    private static final String REQUEST_MOVE_LEFT_MARGIN = ".RS";
    private static final String REQUEST_BREAK = ".br";
    private static final String BULLET_STYLE_BULLET = "\"\\(bu\"";
    private static final String BULLET_STYLE_DASH = "\"-\"";
    private static final String BULLET_STYLE_EM_DASH = "\"\\(em\"";
    private static final int DEFAULT_INDENTATION = 4;
    private final PrintWriter writer;
    private int level = 0;
    private boolean newline = true;
    private boolean inSection = false;
    private final int indentation = 4;
    private Stack<ListType> lists = new Stack();
    private final String listGlyph;

    public TroffPrinter(PrintWriter writer) {
        this(writer, 4, BulletStyle.DASH);
    }

    public TroffPrinter(PrintWriter writer, int indentation, BulletStyle style) {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        this.writer = writer;
        this.listGlyph = style.glyph;
    }

    public void start(String title, int manSection) {
        this.start(title, manSection, null, null, null);
    }

    public void start(String title, int manSection, String header, String footer, String footerExtra) {
        if (!this.newline) {
            this.writer.println();
            this.newline = true;
        }
        this.writer.println(String.format(".TH %s %s %s %s %s", this.asArg(title), this.asArg(Integer.toString(manSection)), this.asArg(footer), this.asArg(footerExtra), this.asArg(header)));
        this.newline = true;
        this.inSection = false;
    }

    public void nextSection(String sectionTitle) {
        if (!this.newline) {
            this.writer.println();
            this.newline = true;
        }
        this.writer.println(String.format(".SH %s", sectionTitle));
        this.newline = true;
        this.inSection = true;
    }

    public void print(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        String[] lines = StringUtils.split((String)value, (char)'\n');
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            if (this.newline) {
                this.prepareLine();
            }
            this.writer.print(this.escape(value));
        } else {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.appendLine(line);
                ++n2;
            }
        }
    }

    public void println(String value) {
        this.print(value);
        if (!this.newline) {
            this.writer.println();
            this.newline = true;
        }
    }

    public void println() {
        if (this.newline) {
            return;
        }
        this.writer.println();
        this.newline = true;
    }

    public void lineBreak() {
        if (!this.newline) {
            this.writer.println();
        }
        this.writer.println(REQUEST_BREAK);
        this.newline = false;
    }

    public void printBold(String value) {
        this.print(String.format("%s%s%s", REQUEST_FONT_BOLD, value, REQUEST_FONT_ROMAN));
    }

    public void printItalic(String value) {
        this.print(String.format("%s%s%s", REQUEST_FONT_ITALIC, value, REQUEST_FONT_ROMAN));
    }

    public void printBoldItalic(String value) {
        this.print(String.format("%s%s%s", REQUEST_FONT_BOLD_ITALIC, value, REQUEST_FONT_ROMAN));
    }

    private void appendLine(String line) {
        if (StringUtils.isEmpty((CharSequence)line)) {
            this.writer.println();
            this.newline = true;
        }
        if (this.newline) {
            this.prepareLine();
        }
        this.writer.println(this.escape(line));
        this.newline = true;
    }

    public void startBulletedList() {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 0 || this.inSection) {
            this.writer.println(REQUEST_MOVE_LEFT_MARGIN);
        }
        this.lists.push(ListType.BULLET);
        this.printBullet();
        ++this.level;
        this.newline = false;
    }

    public void startPlainList() {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 0 || this.inSection) {
            this.writer.println(REQUEST_MOVE_LEFT_MARGIN);
        }
        this.lists.push(ListType.PLAIN);
        this.printPlainBullet();
        ++this.level;
        this.newline = false;
    }

    public void startNumberedList() {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 0 || this.inSection) {
            this.writer.println(REQUEST_MOVE_LEFT_MARGIN);
        }
        this.lists.push(ListType.NUMBERED);
        ++this.level;
        this.printNumberedBullet(true);
        this.newline = false;
    }

    public void startTitledList() {
        this.startTitledList(null);
    }

    public void startTitledList(String title) {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 0 || this.inSection) {
            this.writer.println(REQUEST_MOVE_LEFT_MARGIN);
        }
        this.lists.push(ListType.TITLED);
        this.printTitledBullet();
        this.newline = false;
        ++this.level;
        if (title != null) {
            this.writer.println(this.escape(title));
            this.writer.println(REQUEST_BREAK);
        }
    }

    public void nextBulletedListItem() {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 0) {
            if (this.lists.peek() != ListType.BULLET) {
                throw new IllegalStateException("Cannot move to next bulleted list item when currently in another list type");
            }
            this.printBullet();
            this.newline = false;
        } else {
            this.notInList();
        }
    }

    public void nextPlainListItem() {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 0) {
            if (this.lists.peek() != ListType.PLAIN) {
                throw new IllegalStateException("Cannot move to next plain list item when currently in another list type");
            }
            this.printPlainBullet();
            this.newline = false;
        } else {
            this.notInList();
        }
    }

    protected void notInList() {
        throw new IllegalStateException("Cannot start a new list item when not currently in a list");
    }

    public void nextNumberedListItem() {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 0) {
            if (this.lists.peek() != ListType.NUMBERED) {
                throw new IllegalStateException("Cannot move to next numbered list item when currently in another list type");
            }
            this.printNumberedBullet(false);
            this.newline = false;
        } else {
            this.notInList();
        }
    }

    public void nextTitledListItem() {
        this.nextTitledListItem(null);
    }

    public void nextTitledListItem(String title) {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 0) {
            if (this.lists.peek() != ListType.TITLED) {
                throw new IllegalStateException("Cannot move to next titled list item when currently in another list type");
            }
        } else {
            throw new IllegalStateException("Cannot start a new titled list item when not currently in a list");
        }
        this.printTitledBullet();
        this.newline = false;
        if (!StringUtils.isEmpty((CharSequence)title)) {
            this.writer.println(this.escape(title));
            this.writer.println(REQUEST_BREAK);
        }
    }

    public void endList() {
        if (!this.newline) {
            this.writer.println();
        }
        if (this.level > 1) {
            this.writer.println(REQUEST_RESET_LEFT_MARGIN);
        } else if (this.level == 1) {
            this.writer.println(REQUEST_PARAGRAPH_NO_INDENTATION);
        } else {
            throw new IllegalStateException("Cannot end a list when not currently in a list");
        }
        ListType type = this.lists.pop();
        if (type == ListType.NUMBERED) {
            this.writer.println(String.format(".rr list%d", this.level));
        }
        --this.level;
        this.newline = true;
    }

    public void printTable(List<List<String>> rows, boolean hasHeader) {
        if (!this.newline) {
            this.writer.println();
        }
        this.writer.println(REQUEST_TABLE_START);
        this.writer.println("box;");
        int maxColumns = 0;
        for (List<String> row : rows) {
            maxColumns = Math.max(maxColumns, row.size());
        }
        if (hasHeader) {
            int i = 0;
            while (i < maxColumns) {
                this.writer.print("cb");
                if (i < maxColumns - 1) {
                    this.writer.print(" | ");
                }
                ++i;
            }
            if (rows.size() == 1) {
                this.writer.print(" .");
            }
            this.writer.println();
        }
        if (rows.size() > 1) {
            int i = 0;
            while (i < maxColumns) {
                this.writer.print("l");
                if (i < maxColumns - 1) {
                    this.writer.print(" | ");
                }
                ++i;
            }
            this.writer.println(" .");
        }
        int r = 0;
        while (r < rows.size()) {
            int c;
            List<String> row = rows.get(r);
            if (r == 1 && hasHeader) {
                c = 0;
                while (c < maxColumns) {
                    this.writer.print("_");
                    if (c < maxColumns - 1) {
                        this.writer.print("\t|\t");
                    }
                    ++c;
                }
                this.writer.println();
            }
            c = 0;
            while (c < maxColumns) {
                if (c >= row.size()) break;
                this.writer.print(this.escape(row.get(c)));
                if (c < row.size() - 1) {
                    this.writer.print('\t');
                }
                ++c;
            }
            this.writer.println();
            ++r;
        }
        this.writer.println(REQUEST_TABLE_END);
    }

    private void prepareLine() {
        if (this.level > 0) {
            this.writer.println(REQUEST_PARAGRAPH_CURRENT_INDENTATION);
        } else if (this.inSection) {
            this.writer.println(REQUEST_PARAGRAPH_NO_INDENTATION);
        } else {
            this.writer.println(".");
        }
        this.newline = false;
    }

    protected void printBullet() {
        this.writer.println(String.format(".IP %s %d", this.listGlyph, 4));
    }

    protected void printTitledBullet() {
        this.writer.println(String.format(REQUEST_PARAGRAPH_TITLED, new Object[0]));
    }

    protected void printPlainBullet() {
        this.writer.println(String.format(".IP \"\" %d", 4));
    }

    protected void printNumberedBullet(boolean first) {
        if (first) {
            this.writer.println(String.format(".nr list%d 1 1", this.level));
            this.writer.println(String.format(".IP \\n[list%d]. %d", this.level, 4));
        } else {
            this.writer.println(String.format(".IP \\n+[list%d]. %d", this.level, 4));
        }
    }

    private String asArg(String arg) {
        return String.format("\"%s\"", this.escapeArg(arg));
    }

    private String escapeArg(String arg) {
        if (arg == null) {
            return "";
        }
        arg = arg.replace("-", "\\-");
        return arg.replace('\"', ' ');
    }

    private String escape(String line) {
        if (StringUtils.isEmpty((CharSequence)line)) {
            return "";
        }
        if (line.startsWith(".")) {
            line = "\\" + line;
        }
        line = line.replace("-", "\\-");
        line = line.replace("\t", "\\t");
        return line;
    }

    public void flush() {
        this.writer.flush();
    }

    public void finish() {
        while (this.level > 0) {
            this.endList();
        }
        this.writer.flush();
    }

    public static enum BulletStyle {
        BULLET("\"\\(bu\""),
        DASH("\"-\""),
        EM_DASH("\"\\(em\"");

        private final String glyph;

        private BulletStyle(String glyph) {
            this.glyph = glyph;
        }
    }

    private static enum ListType {
        BULLET,
        TITLED,
        PLAIN,
        NUMBERED;

    }
}

