/*
 * Decompiled with CFR 0.152.
 */
package com.kryptoprefs.preferences.key;

import android.annotation.TargetApi;
import android.content.Context;
import com.kryptoprefs.preferences.KryptoBuilder;
import com.kryptoprefs.preferences.KryptoPrefs;
import com.kryptoprefs.preferences.key.Key;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/kryptoprefs/preferences/key/HybridKey;", "Lcom/kryptoprefs/preferences/key/Key;", "context", "Landroid/content/Context;", "name", "", "(Landroid/content/Context;Ljava/lang/String;)V", "finalKey", "Ljavax/crypto/SecretKey;", "passKey", "prefs", "Lcom/kryptoprefs/preferences/KryptoPrefs;", "saltKey", "get", "Ljava/security/Key;", "tag", "Companion", "kryptoprefs_release"})
@TargetApi(value=23)
public final class HybridKey
implements Key {
    private final String passKey;
    private final String saltKey;
    private final KryptoPrefs prefs;
    private SecretKey finalKey;
    private static final String ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String TAG = "HybridKey";
    private static final int ITERATIONS = 1000;
    private static final int KEY_SIZE = 256;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public java.security.Key get() {
        java.security.Key key;
        if (this.finalKey != null) {
            SecretKey secretKey = this.finalKey;
            if (secretKey == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finalKey");
            }
            key = secretKey;
        } else if (this.prefs.contains(this.passKey) && this.prefs.contains(this.saltKey)) {
            String string = this.prefs.getString(this.passKey, null);
            if (string == null) {
                throw (Throwable)new IllegalStateException("Wrong pass.");
            }
            String p = string;
            String string2 = this.prefs.getString(this.saltKey, null);
            if (string2 == null) {
                throw (Throwable)new IllegalStateException("Wrong salt.");
            }
            String s = string2;
            String string3 = p;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string4.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray2 = cArray;
            string3 = s;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String string5 = string3;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string5.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            int n = 256;
            int n2 = 1000;
            byte[] byArray3 = byArray2;
            char[] cArray3 = cArray2;
            PBEKeySpec keySpec = new PBEKeySpec(cArray3, byArray3, n2, n);
            SecretKey secretKey = SecretKeyFactory.getInstance(ALGORITHM).generateSecret(keySpec);
            Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"SecretKeyFactory.getInst\u2026).generateSecret(keySpec)");
            SecretKey secretKey2 = this.finalKey = secretKey;
            if (secretKey2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finalKey");
            }
            key = secretKey2;
        } else {
            SecureRandom random = new SecureRandom();
            byte[] pass = new byte[256];
            byte[] salt = new byte[256];
            random.nextBytes(pass);
            random.nextBytes(salt);
            byte[] byArray = pass;
            Charset charset = Charsets.UTF_8;
            String string = this.passKey;
            KryptoPrefs kryptoPrefs = this.prefs;
            boolean bl = false;
            boolean bl3 = false;
            String string6 = new String(byArray, charset);
            kryptoPrefs.putString(string, string6);
            byArray = salt;
            charset = Charsets.UTF_8;
            string = this.saltKey;
            kryptoPrefs = this.prefs;
            bl = false;
            bl3 = false;
            string6 = new String(byArray, charset);
            kryptoPrefs.putString(string, string6);
            key = this.get();
        }
        return key;
    }

    @Override
    @NotNull
    public String tag() {
        return TAG;
    }

    public HybridKey(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.passKey = "HybridKey-" + name + "-pass";
        this.saltKey = "HybridKey-" + name + "-salt";
        this.prefs = KryptoBuilder.keystore(context, name + "-hybrid");
    }

    public static final /* synthetic */ SecretKey access$getFinalKey$p(HybridKey $this) {
        SecretKey secretKey = $this.finalKey;
        if (secretKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalKey");
        }
        return secretKey;
    }

    public static final /* synthetic */ void access$setFinalKey$p(HybridKey $this, SecretKey secretKey) {
        $this.finalKey = secretKey;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/kryptoprefs/preferences/key/HybridKey$Companion;", "", "()V", "ALGORITHM", "", "ITERATIONS", "", "KEY_SIZE", "TAG", "kryptoprefs_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

