/*
 * Decompiled with CFR 0.152.
 */
package com.kryptoprefs.preferences;

import android.annotation.TargetApi;
import android.content.Context;
import com.kryptoprefs.preferences.KryptoPrefs;
import com.kryptoprefs.preferences.KryptoPrefsImpl;
import com.kryptoprefs.preferences.encryption.AesCbcEncryption;
import com.kryptoprefs.preferences.encryption.AesGcmEncryption;
import com.kryptoprefs.preferences.hash.Sha512Hash;
import com.kryptoprefs.preferences.key.HybridKey;
import com.kryptoprefs.preferences.key.KeyStoreKey;
import com.kryptoprefs.preferences.key.PbeKey;
import com.kryptoprefs.preferences.key.Pbkdf2Key;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J0\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/kryptoprefs/preferences/KryptoBuilder;", "", "()V", "hybrid", "Lcom/kryptoprefs/preferences/KryptoPrefs;", "context", "Landroid/content/Context;", "name", "", "keystore", "pref", "pass", "salt", "api", "", "kryptoprefs_release"})
public final class KryptoBuilder {
    public static final KryptoBuilder INSTANCE;

    @JvmStatic
    @NotNull
    public static final KryptoPrefs pref(@NotNull Context context, @NotNull String name, @NotNull String pass, @NotNull String salt, int api) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
        Intrinsics.checkParameterIsNotNull((Object)salt, (String)"salt");
        return api < 10 ? (KryptoPrefs)new KryptoPrefsImpl(context, name, new AesCbcEncryption(), new Sha512Hash(), new PbeKey(pass, salt)) : (api < 19 ? (KryptoPrefs)new KryptoPrefsImpl(context, name, new AesCbcEncryption(), new Sha512Hash(), new Pbkdf2Key(pass, salt)) : (KryptoPrefs)new KryptoPrefsImpl(context, name, new AesGcmEncryption(), new Sha512Hash(), new Pbkdf2Key(pass, salt)));
    }

    @JvmStatic
    @TargetApi(value=23)
    @NotNull
    public static final KryptoPrefs keystore(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        KeyStoreKey key = new KeyStoreKey(name, "GCM", "NoPadding", false, 0, 24, null);
        return new KryptoPrefsImpl(context, name, new AesGcmEncryption(), new Sha512Hash(), key);
    }

    @JvmStatic
    @TargetApi(value=23)
    @NotNull
    public static final KryptoPrefs hybrid(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        HybridKey key = new HybridKey(context, name);
        return new KryptoPrefsImpl(context, name, new AesGcmEncryption(), new Sha512Hash(), key);
    }

    private KryptoBuilder() {
    }

    static {
        KryptoBuilder kryptoBuilder;
        INSTANCE = kryptoBuilder = new KryptoBuilder();
    }
}

