/*
 * Decompiled with CFR 0.152.
 */
package com.kryptoprefs.preferences;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.kryptoprefs.preferences.KryptoPrefs;
import com.kryptoprefs.preferences.encryption.Encryption;
import com.kryptoprefs.preferences.hash.Hash;
import com.kryptoprefs.preferences.key.Key;
import java.security.KeyException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\u0018\u0000 '2\u00020\u0001:\u0001'B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\u001f\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0017J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0005H\u0017J\b\u0010%\u001a\u00020\u000eH\u0016J\b\u0010&\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/kryptoprefs/preferences/KryptoPrefsImpl;", "Lcom/kryptoprefs/preferences/KryptoPrefs;", "context", "Landroid/content/Context;", "prefsName", "", "encryption", "Lcom/kryptoprefs/preferences/encryption/Encryption;", "hash", "Lcom/kryptoprefs/preferences/hash/Hash;", "encryptionKey", "Lcom/kryptoprefs/preferences/key/Key;", "(Landroid/content/Context;Ljava/lang/String;Lcom/kryptoprefs/preferences/encryption/Encryption;Lcom/kryptoprefs/preferences/hash/Hash;Lcom/kryptoprefs/preferences/key/Key;)V", "preferences", "Landroid/content/SharedPreferences;", "clear", "", "contains", "", "key", "getBoolean", "defaultValue", "getInt", "", "getLong", "", "getString", "name", "putBoolean", "value", "(Ljava/lang/String;Ljava/lang/Boolean;)Lcom/kryptoprefs/preferences/KryptoPrefs;", "putInt", "(Ljava/lang/String;Ljava/lang/Integer;)Lcom/kryptoprefs/preferences/KryptoPrefs;", "putLong", "(Ljava/lang/String;Ljava/lang/Long;)Lcom/kryptoprefs/preferences/KryptoPrefs;", "putString", "remove", "sharedPreferences", "tag", "Companion", "kryptoprefs_release"})
public final class KryptoPrefsImpl
implements KryptoPrefs {
    private final SharedPreferences preferences;
    private final String prefsName;
    private final Encryption encryption;
    private final Hash hash;
    private final Key encryptionKey;
    @NotNull
    public static final String KEY_ENCRYPTION_TAG = "KEY_ENCRYPTION_TAG";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public KryptoPrefs putBoolean(@NotNull String key, @Nullable Boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Boolean bl = value;
        return this.putString(key, bl != null ? String.valueOf(bl) : null);
    }

    @Override
    @NotNull
    public KryptoPrefs putInt(@NotNull String key, @Nullable Integer value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Integer n = value;
        return this.putString(key, n != null ? String.valueOf(n) : null);
    }

    @Override
    @NotNull
    public KryptoPrefs putLong(@NotNull String key, @Nullable Long value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Long l = value;
        return this.putString(key, l != null ? String.valueOf(l) : null);
    }

    @Override
    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = this.getString(key, String.valueOf(defaultValue));
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            bl = Boolean.parseBoolean(string2);
        } else {
            bl = defaultValue;
        }
        return bl;
    }

    @Override
    public int getInt(@NotNull String key, int defaultValue) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = this.getString(key, String.valueOf(defaultValue));
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = defaultValue;
        }
        return n;
    }

    @Override
    public long getLong(@NotNull String key, long defaultValue) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = this.getString(key, String.valueOf(defaultValue));
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            l = Long.parseLong(string2);
        } else {
            l = defaultValue;
        }
        return l;
    }

    @Override
    public boolean contains(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.preferences.contains(this.hash.hash(key));
    }

    @Override
    @NotNull
    public String name() {
        return this.prefsName;
    }

    @Override
    @NotNull
    public SharedPreferences sharedPreferences() {
        return this.preferences;
    }

    @Override
    @SuppressLint(value={"CommitPrefEdits"})
    @NotNull
    public KryptoPrefs putString(@NotNull String key, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = value;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.preferences.edit().putString(this.hash.hash(key), this.encryption.encrypt(this.encryptionKey, value)).apply();
        } else {
            this.remove(key);
        }
        return this;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String defaultValue) {
        String string;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    if (!this.contains(key)) break block2;
                    string = this.preferences.getString(this.hash.hash(key), defaultValue);
                    if (string == null) break block3;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    String string3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                    string = this.encryption.decrypt(this.encryptionKey, string3);
                    if (string != null) break block4;
                }
                string = defaultValue;
                break block4;
            }
            string = defaultValue;
        }
        return string;
    }

    @Override
    @SuppressLint(value={"CommitPrefEdits"})
    @NotNull
    public KryptoPrefs remove(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.preferences.edit().remove(this.hash.hash(key)).apply();
        return this;
    }

    @Override
    @SuppressLint(value={"CommitPrefEdits"})
    public void clear() {
        this.preferences.edit().clear().apply();
        this.tag();
    }

    private final void tag() {
        String tag = this.encryption.tag() + ':' + this.hash.tag() + ':' + this.encryptionKey.tag();
        if (this.preferences.getAll().isEmpty()) {
            this.putString(KEY_ENCRYPTION_TAG, tag);
        } else if (Intrinsics.areEqual((Object)this.getString(KEY_ENCRYPTION_TAG, null), (Object)tag) ^ true) {
            throw (Throwable)new KeyException("File is using different encryption method or key.");
        }
    }

    public KryptoPrefsImpl(@NotNull Context context, @NotNull String prefsName, @NotNull Encryption encryption, @NotNull Hash hash, @NotNull Key encryptionKey) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)prefsName, (String)"prefsName");
        Intrinsics.checkParameterIsNotNull((Object)encryption, (String)"encryption");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        Intrinsics.checkParameterIsNotNull((Object)encryptionKey, (String)"encryptionKey");
        this.prefsName = prefsName;
        this.encryption = encryption;
        this.hash = hash;
        this.encryptionKey = encryptionKey;
        SharedPreferences sharedPreferences = context.getSharedPreferences(this.prefsName, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026(prefsName, MODE_PRIVATE)");
        this.preferences = sharedPreferences;
        this.tag();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/kryptoprefs/preferences/KryptoPrefsImpl$Companion;", "", "()V", "KEY_ENCRYPTION_TAG", "", "kryptoprefs_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

