/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import android.view.View;
import com.github.rubensousa.gravitysnaphelper.R;

public class GravitySnapHelper
extends SnapHelper {
    private static final float INVALID_DISTANCE = 1.0f;
    private OrientationHelper mVerticalHelper;
    private OrientationHelper mHorizontalHelper;
    private int mGravity;
    private boolean mIsRtlHorizontal;
    private boolean mSnapLastItemEnabled;

    public GravitySnapHelper(int gravity) {
        this(gravity, false);
    }

    public GravitySnapHelper(int gravity, boolean enableSnapLastItem) {
        if (gravity != 0x800003 && gravity != 0x800005 && gravity != 80 && gravity != 48) {
            throw new IllegalArgumentException("Invalid gravity value. Use START | END | BOTTOM | TOP constants");
        }
        this.mGravity = gravity;
        this.mSnapLastItemEnabled = enableSnapLastItem;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (recyclerView != null && (this.mGravity == 0x800003 || this.mGravity == 0x800005)) {
            this.mIsRtlHorizontal = recyclerView.getContext().getResources().getBoolean(R.bool.is_rtl);
        }
        super.attachToRecyclerView(recyclerView);
    }

    public int findTargetSnapPosition(RecyclerView.LayoutManager layoutManager, int velocityX, int velocityY) {
        int deltaJump;
        int vDeltaJump;
        int hDeltaJump;
        if (!(layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider)) {
            return -1;
        }
        int itemCount = layoutManager.getItemCount();
        if (itemCount == 0) {
            return -1;
        }
        View currentView = this.findSnapView(layoutManager);
        if (currentView == null) {
            return -1;
        }
        int currentPosition = layoutManager.getPosition(currentView);
        if (currentPosition == -1) {
            return -1;
        }
        RecyclerView.SmoothScroller.ScrollVectorProvider vectorProvider = (RecyclerView.SmoothScroller.ScrollVectorProvider)layoutManager;
        PointF vectorForEnd = vectorProvider.computeScrollVectorForPosition(itemCount - 1);
        if (vectorForEnd == null) {
            return -1;
        }
        if (layoutManager.canScrollHorizontally()) {
            hDeltaJump = this.estimateNextPositionDiffForFling(layoutManager, this.getHorizontalHelper(layoutManager), velocityX, 0);
            if (vectorForEnd.x < 0.0f) {
                hDeltaJump = -hDeltaJump;
            }
        } else {
            hDeltaJump = 0;
        }
        if (layoutManager.canScrollVertically()) {
            vDeltaJump = this.estimateNextPositionDiffForFling(layoutManager, this.getVerticalHelper(layoutManager), 0, velocityY);
            if (vectorForEnd.y < 0.0f) {
                vDeltaJump = -vDeltaJump;
            }
        } else {
            vDeltaJump = 0;
        }
        int n = deltaJump = layoutManager.canScrollVertically() ? vDeltaJump : hDeltaJump;
        if (deltaJump == 0) {
            return -1;
        }
        int targetPos = currentPosition + deltaJump;
        if (targetPos < 0) {
            targetPos = 0;
        }
        if (targetPos >= itemCount) {
            targetPos = itemCount - 1;
        }
        return targetPos;
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[2];
        out[0] = layoutManager.canScrollHorizontally() ? (this.mGravity == 0x800003 ? this.distanceToStart(targetView, this.getHorizontalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getHorizontalHelper(layoutManager), false)) : 0;
        out[1] = layoutManager.canScrollVertically() ? (this.mGravity == 48 ? this.distanceToStart(targetView, this.getVerticalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getVerticalHelper(layoutManager), false)) : 0;
        return out;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof LinearLayoutManager) {
            switch (this.mGravity) {
                case 0x800003: {
                    return this.findStartView(layoutManager, this.getHorizontalHelper(layoutManager));
                }
                case 0x800005: {
                    return this.findEndView(layoutManager, this.getHorizontalHelper(layoutManager));
                }
                case 48: {
                    return this.findStartView(layoutManager, this.getVerticalHelper(layoutManager));
                }
                case 80: {
                    return this.findEndView(layoutManager, this.getVerticalHelper(layoutManager));
                }
            }
        }
        return null;
    }

    public void enableLastItemSnap(boolean snap) {
        this.mSnapLastItemEnabled = snap;
    }

    private int distanceToStart(View targetView, OrientationHelper helper, boolean fromEnd) {
        if (this.mIsRtlHorizontal && !fromEnd) {
            return this.distanceToEnd(targetView, helper, true);
        }
        return helper.getDecoratedStart(targetView) - helper.getStartAfterPadding();
    }

    private int distanceToEnd(View targetView, OrientationHelper helper, boolean fromStart) {
        if (this.mIsRtlHorizontal && !fromStart) {
            return this.distanceToStart(targetView, helper, true);
        }
        return helper.getDecoratedEnd(targetView) - helper.getEndAfterPadding();
    }

    private View findStartView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean endOfList;
            int firstChild = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            if (firstChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(firstChild);
            float visibleWidth = this.mIsRtlHorizontal ? (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child) : (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child);
            if (visibleWidth > 0.5f) {
                return child;
            }
            boolean bl = endOfList = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1;
            if (this.mSnapLastItemEnabled && endOfList) {
                return child;
            }
            if (endOfList) {
                return null;
            }
            return layoutManager.findViewByPosition(firstChild + 1);
        }
        return null;
    }

    private View findEndView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean startOfList;
            int lastChild = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            if (lastChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(lastChild);
            float visibleWidth = this.mIsRtlHorizontal ? (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child) : (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child);
            if (visibleWidth > 0.5f) {
                return child;
            }
            boolean bl = startOfList = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() == 0;
            if (this.mSnapLastItemEnabled && startOfList) {
                return child;
            }
            if (startOfList) {
                return null;
            }
            return layoutManager.findViewByPosition(lastChild - 1);
        }
        return null;
    }

    private int estimateNextPositionDiffForFling(RecyclerView.LayoutManager layoutManager, OrientationHelper helper, int velocityX, int velocityY) {
        int distance;
        int[] distances = this.calculateScrollDistance(velocityX, velocityY);
        float distancePerChild = this.computeDistancePerChild(layoutManager, helper);
        if (distancePerChild <= 0.0f) {
            return 0;
        }
        int n = distance = Math.abs(distances[0]) > Math.abs(distances[1]) ? distances[0] : distances[1];
        if ((float)Math.abs(distance) < distancePerChild / 2.0f) {
            return 0;
        }
        return (int)Math.floor((float)distance / distancePerChild);
    }

    private float computeDistancePerChild(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        View minPosView = null;
        View maxPosView = null;
        int minPos = Integer.MAX_VALUE;
        int maxPos = Integer.MIN_VALUE;
        int childCount = layoutManager.getChildCount();
        if (childCount == 0) {
            return 1.0f;
        }
        for (int i = 0; i < childCount; ++i) {
            View child = layoutManager.getChildAt(i);
            int pos = layoutManager.getPosition(child);
            if (pos == -1) continue;
            if (pos < minPos) {
                minPos = pos;
                minPosView = child;
            }
            if (pos <= maxPos) continue;
            maxPos = pos;
            maxPosView = child;
        }
        if (minPosView == null || maxPosView == null) {
            return 1.0f;
        }
        int start = Math.min(helper.getDecoratedStart(minPosView), helper.getDecoratedStart(maxPosView));
        int end = Math.max(helper.getDecoratedEnd(minPosView), helper.getDecoratedEnd(maxPosView));
        int distance = end - start;
        if (distance == 0) {
            return 1.0f;
        }
        return 1.0f * (float)distance / (float)(maxPos - minPos + 1);
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }
}

