/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSnapHelper;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.github.rubensousa.gravitysnaphelper.R;

public class GravitySnapHelper
extends LinearSnapHelper {
    private OrientationHelper mVerticalHelper;
    private OrientationHelper mHorizontalHelper;
    private int mGravity;
    private boolean mIsRtlHorizontal;
    private boolean mSnapLastItemEnabled;

    public GravitySnapHelper(int gravity) {
        this(gravity, false);
    }

    public GravitySnapHelper(int gravity, boolean enableSnapLastItem) {
        if (gravity != 0x800003 && gravity != 0x800005 && gravity != 80 && gravity != 48) {
            throw new IllegalArgumentException("Invalid gravity value. Use START | END | BOTTOM | TOP constants");
        }
        this.mGravity = gravity;
        this.mSnapLastItemEnabled = enableSnapLastItem;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (recyclerView != null && (this.mGravity == 0x800003 || this.mGravity == 0x800005)) {
            this.mIsRtlHorizontal = recyclerView.getContext().getResources().getBoolean(R.bool.is_rtl);
        }
        super.attachToRecyclerView(recyclerView);
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[2];
        out[0] = layoutManager.canScrollHorizontally() ? (this.mGravity == 0x800003 ? this.distanceToStart(targetView, this.getHorizontalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getHorizontalHelper(layoutManager), false)) : 0;
        out[1] = layoutManager.canScrollVertically() ? (this.mGravity == 48 ? this.distanceToStart(targetView, this.getVerticalHelper(layoutManager), false) : this.distanceToEnd(targetView, this.getVerticalHelper(layoutManager), false)) : 0;
        return out;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof LinearLayoutManager) {
            switch (this.mGravity) {
                case 0x800003: {
                    return this.findStartView(layoutManager, this.getHorizontalHelper(layoutManager));
                }
                case 0x800005: {
                    return this.findEndView(layoutManager, this.getHorizontalHelper(layoutManager));
                }
                case 48: {
                    return this.findStartView(layoutManager, this.getVerticalHelper(layoutManager));
                }
                case 80: {
                    return this.findEndView(layoutManager, this.getVerticalHelper(layoutManager));
                }
            }
        }
        return super.findSnapView(layoutManager);
    }

    public void enableLastItemSnap(boolean snap) {
        this.mSnapLastItemEnabled = snap;
    }

    private int distanceToStart(View targetView, OrientationHelper helper, boolean fromEnd) {
        if (this.mIsRtlHorizontal && !fromEnd) {
            return this.distanceToEnd(targetView, helper, true);
        }
        int distance = helper.getDecoratedStart(targetView) - helper.getStartAfterPadding();
        if ((float)Math.abs(distance) > (float)helper.getDecoratedMeasurement(targetView) / 2.0f && (float)Math.abs(distance) < (float)helper.getDecoratedMeasurement(targetView) * 1.5f) {
            distance = 1;
        }
        return distance;
    }

    private int distanceToEnd(View targetView, OrientationHelper helper, boolean fromStart) {
        if (this.mIsRtlHorizontal && !fromStart) {
            return this.distanceToStart(targetView, helper, true);
        }
        int distance = helper.getDecoratedEnd(targetView) - helper.getEndAfterPadding();
        if ((float)Math.abs(distance) > (float)helper.getDecoratedMeasurement(targetView) / 2.0f && (float)Math.abs(distance) < (float)helper.getDecoratedMeasurement(targetView) * 1.5f) {
            distance = 1;
        }
        return distance;
    }

    private View findStartView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean endOfList;
            int firstChild = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            if (firstChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(firstChild);
            float visibleWidth = this.mIsRtlHorizontal ? (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child) : (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child);
            if (visibleWidth > 0.5f) {
                return child;
            }
            boolean bl = endOfList = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1;
            if (this.mSnapLastItemEnabled && endOfList) {
                return child;
            }
            if (endOfList) {
                return null;
            }
            return layoutManager.findViewByPosition(firstChild + 1);
        }
        return super.findSnapView(layoutManager);
    }

    private View findEndView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean startOfList;
            int lastChild = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            if (lastChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(lastChild);
            float visibleWidth = this.mIsRtlHorizontal ? (float)helper.getDecoratedEnd(child) / (float)helper.getDecoratedMeasurement(child) : (float)(helper.getTotalSpace() - helper.getDecoratedStart(child)) / (float)helper.getDecoratedMeasurement(child);
            if (visibleWidth > 0.5f) {
                return child;
            }
            boolean bl = startOfList = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() == 0;
            if (this.mSnapLastItemEnabled && startOfList) {
                return child;
            }
            if (startOfList) {
                return null;
            }
            return layoutManager.findViewByPosition(lastChild - 1);
        }
        return super.findSnapView(layoutManager);
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }
}

