/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.text.TextUtilsCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.github.rubensousa.gravitysnaphelper.GravitySnapHelper;
import java.util.Locale;

class GravityDelegate {
    private OrientationHelper verticalHelper;
    private OrientationHelper horizontalHelper;
    private int gravity;
    private boolean isRtl;
    private boolean snapLastItem;
    private GravitySnapHelper.SnapListener listener;
    private boolean snapping;
    private int lastSnappedPosition;
    private RecyclerView recyclerView;
    private RecyclerView.OnScrollListener scrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (newState == 0 && GravityDelegate.this.snapping && GravityDelegate.this.listener != null) {
                if (GravityDelegate.this.lastSnappedPosition != -1) {
                    GravityDelegate.this.listener.onSnap(GravityDelegate.this.lastSnappedPosition);
                }
                GravityDelegate.this.snapping = false;
            }
        }
    };

    public GravityDelegate(int gravity, boolean enableSnapLast, @Nullable GravitySnapHelper.SnapListener listener) {
        if (gravity != 0x800003 && gravity != 0x800005 && gravity != 80 && gravity != 48) {
            throw new IllegalArgumentException("Invalid gravity value. Use START | END | BOTTOM | TOP constants");
        }
        this.snapLastItem = enableSnapLast;
        this.gravity = gravity;
        this.listener = listener;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        if (recyclerView != null) {
            recyclerView.setOnFlingListener(null);
            if (this.gravity == 0x800003 || this.gravity == 0x800005) {
                boolean bl = this.isRtl = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
            }
            if (this.listener != null) {
                recyclerView.addOnScrollListener(this.scrollListener);
            }
            this.recyclerView = recyclerView;
        }
    }

    public void smoothScrollToPosition(int position) {
        this.scrollTo(position, true);
    }

    public void scrollToPosition(int position) {
        this.scrollTo(position, false);
    }

    private void scrollTo(int position, boolean smooth) {
        if (this.recyclerView.getLayoutManager() != null) {
            RecyclerView.ViewHolder viewHolder = this.recyclerView.findViewHolderForAdapterPosition(position);
            if (viewHolder != null) {
                int[] distances = this.calculateDistanceToFinalSnap(this.recyclerView.getLayoutManager(), viewHolder.itemView);
                if (smooth) {
                    this.recyclerView.smoothScrollBy(distances[0], distances[1]);
                } else {
                    this.recyclerView.scrollBy(distances[0], distances[1]);
                }
            } else if (smooth) {
                this.recyclerView.smoothScrollToPosition(position);
            } else {
                this.recyclerView.scrollToPosition(position);
            }
        }
    }

    @NonNull
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[2];
        if (!(layoutManager instanceof LinearLayoutManager)) {
            return out;
        }
        LinearLayoutManager lm = (LinearLayoutManager)layoutManager;
        out[0] = lm.canScrollHorizontally() ? (this.isRtl && this.gravity == 0x800005 || !this.isRtl && this.gravity == 0x800003 ? this.distanceToStart(targetView, lm, this.getHorizontalHelper((RecyclerView.LayoutManager)lm)) : this.distanceToEnd(targetView, lm, this.getHorizontalHelper((RecyclerView.LayoutManager)lm))) : 0;
        out[1] = lm.canScrollVertically() ? (this.gravity == 48 ? this.distanceToStart(targetView, lm, this.getVerticalHelper((RecyclerView.LayoutManager)lm)) : this.distanceToEnd(targetView, lm, this.getVerticalHelper((RecyclerView.LayoutManager)lm))) : 0;
        return out;
    }

    @Nullable
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        if (!(layoutManager instanceof LinearLayoutManager)) {
            return null;
        }
        View snapView = null;
        LinearLayoutManager lm = (LinearLayoutManager)layoutManager;
        switch (this.gravity) {
            case 0x800003: {
                snapView = this.findEdgeView(lm, this.getHorizontalHelper((RecyclerView.LayoutManager)lm), true);
                break;
            }
            case 0x800005: {
                snapView = this.findEdgeView(lm, this.getHorizontalHelper((RecyclerView.LayoutManager)lm), false);
                break;
            }
            case 48: {
                snapView = this.findEdgeView(lm, this.getVerticalHelper((RecyclerView.LayoutManager)lm), true);
                break;
            }
            case 80: {
                snapView = this.findEdgeView(lm, this.getVerticalHelper((RecyclerView.LayoutManager)lm), false);
            }
        }
        boolean bl = this.snapping = snapView != null;
        if (snapView != null) {
            this.lastSnappedPosition = this.recyclerView.getChildAdapterPosition(snapView);
        }
        return snapView;
    }

    public void enableLastItemSnap(boolean snap) {
        this.snapLastItem = snap;
    }

    private int distanceToStart(View targetView, LinearLayoutManager lm, @NonNull OrientationHelper helper) {
        int childStart;
        int pos = this.recyclerView.getChildLayoutPosition(targetView);
        int distance = (pos == 0 && (!this.isRtl || lm.getReverseLayout()) || pos == lm.getItemCount() - 1 && (this.isRtl || lm.getReverseLayout())) && !this.recyclerView.getClipToPadding() ? ((childStart = helper.getDecoratedStart(targetView)) >= helper.getStartAfterPadding() / 2 ? childStart - helper.getStartAfterPadding() : childStart) : helper.getDecoratedStart(targetView);
        return distance;
    }

    private int distanceToEnd(View targetView, LinearLayoutManager lm, @NonNull OrientationHelper helper) {
        int childEnd;
        int pos = this.recyclerView.getChildLayoutPosition(targetView);
        int distance = (pos == 0 && (this.isRtl || lm.getReverseLayout()) || pos == lm.getItemCount() - 1 && (!this.isRtl || lm.getReverseLayout())) && !this.recyclerView.getClipToPadding() ? ((childEnd = helper.getDecoratedEnd(targetView)) >= helper.getEnd() - (helper.getEnd() - helper.getEndAfterPadding()) / 2 ? helper.getDecoratedEnd(targetView) - helper.getEnd() : childEnd - helper.getEndAfterPadding()) : helper.getDecoratedEnd(targetView) - helper.getEnd();
        return distance;
    }

    @Nullable
    private View findEdgeView(LinearLayoutManager lm, OrientationHelper helper, boolean start) {
        if (lm.getChildCount() == 0) {
            return null;
        }
        if (this.isAtEndOfList(lm) && !this.snapLastItem) {
            return null;
        }
        View edgeView = null;
        int distanceToEdge = Integer.MAX_VALUE;
        for (int i = 0; i < lm.getChildCount(); ++i) {
            View currentView = lm.getChildAt(i);
            int currentViewDistance = start && !this.isRtl || !start && this.isRtl ? Math.abs(helper.getDecoratedStart(currentView)) : Math.abs(helper.getDecoratedEnd(currentView) - helper.getEnd());
            if (currentViewDistance >= distanceToEdge) continue;
            distanceToEdge = currentViewDistance;
            edgeView = currentView;
        }
        return edgeView;
    }

    private boolean isAtEndOfList(LinearLayoutManager lm) {
        if (!lm.getReverseLayout() && this.gravity == 0x800003 || lm.getReverseLayout() && this.gravity == 0x800005) {
            return lm.findLastCompletelyVisibleItemPosition() == lm.getItemCount() - 1;
        }
        return lm.findFirstCompletelyVisibleItemPosition() == 0;
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.verticalHelper == null) {
            this.verticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.verticalHelper;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.horizontalHelper == null) {
            this.horizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.horizontalHelper;
    }
}

