/*
 * Decompiled with CFR 0.152.
 */
package com.itsronald.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.itsronald.widget.IndicatorDotPathView;
import com.itsronald.widget.IndicatorDotView;
import com.itsronald.widget.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@ViewPager.DecorView
public class ViewPagerIndicator
extends ViewGroup {
    @NonNull
    private static final String TAG = "ViewPagerIndicator";
    private static final long DOT_SLIDE_ANIM_DURATION = 150L;
    @NonNull
    private final PageListener pageListener = new PageListener();
    @Nullable
    private ViewPager viewPager;
    @Nullable
    private WeakReference<PagerAdapter> pagerAdapterRef;
    @Dimension
    static final int DEFAULT_DOT_PADDING_DIP = 9;
    @NonNull
    private final List<IndicatorDotView> indicatorDots = new ArrayList<IndicatorDotView>();
    @NonNull
    private final List<IndicatorDotPathView> dotPaths = new ArrayList<IndicatorDotPathView>();
    private IndicatorDotView selectedDot;
    @Px
    private int dotPadding;
    @Px
    private int dotRadius;
    @ColorInt
    private int unselectedDotColor;
    @ColorInt
    private int selectedDotColor;
    private int gravity = 16;
    private int lastKnownCurrentPage = -1;
    private float lastKnownPositionOffset = -1.0f;
    private boolean isUpdatingPositions = false;
    private boolean isUpdatingIndicator = false;
    private boolean selectedDotNeedsLayout = true;

    public ViewPagerIndicator(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public ViewPagerIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public ViewPagerIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public ViewPagerIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.ViewPagerIndicator, defStyleAttr, defStyleRes);
        this.gravity = attributes.getInt(R.styleable.ViewPagerIndicator_android_gravity, this.gravity);
        float scale = this.getResources().getDisplayMetrics().density;
        int defaultDotPadding = (int)((double)(9.0f * scale) + 0.5);
        this.dotPadding = attributes.getDimensionPixelSize(R.styleable.ViewPagerIndicator_dotPadding, defaultDotPadding);
        int defaultDotRadius = (int)((double)(3.0f * scale) + 0.5);
        this.dotRadius = attributes.getDimensionPixelSize(R.styleable.ViewPagerIndicator_dotRadius, defaultDotRadius);
        this.unselectedDotColor = attributes.getColor(R.styleable.ViewPagerIndicator_unselectedDotColor, -3355444);
        this.selectedDotColor = attributes.getColor(R.styleable.ViewPagerIndicator_selectedDotColor, -1);
        attributes.recycle();
        this.selectedDot = new IndicatorDotView(context);
        this.selectedDot.setColor(this.selectedDotColor);
        this.selectedDot.setRadius(this.dotRadius);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
        int childHeightSpec = ViewPagerIndicator.getChildMeasureSpec((int)heightMeasureSpec, (int)heightPadding, (int)-2);
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int childWidthSpec = ViewPagerIndicator.getChildMeasureSpec((int)widthMeasureSpec, (int)widthPadding, (int)-2);
        this.selectedDot.measure(childWidthSpec, childHeightSpec);
        for (IndicatorDotView indicatorDot : this.indicatorDots) {
            indicatorDot.measure(childWidthSpec, childHeightSpec);
        }
        for (IndicatorDotPathView dotPath : this.dotPaths) {
            dotPath.measure(childWidthSpec, childHeightSpec);
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode == 0x40000000) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        } else {
            int dotCount = this.indicatorDots.size();
            int totalDotWidth = this.selectedDot.getMeasuredWidth() * dotCount;
            int totalDotPadding = this.dotPadding * (dotCount - 1);
            int minWidth = ViewCompat.getMinimumWidth((View)this);
            width = Math.max(minWidth, totalDotWidth + totalDotPadding + widthPadding);
        }
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else {
            int indicatorHeight = this.selectedDot.getMeasuredHeight();
            int minHeight = ViewCompat.getMinimumHeight((View)this);
            height = Math.max(minHeight, indicatorHeight + heightPadding);
        }
        int childState = ViewCompat.getMeasuredHeightAndState((View)this.selectedDot);
        int measuredHeight = ViewCompat.resolveSizeAndState((int)height, (int)heightMeasureSpec, (int)childState);
        this.setMeasuredDimension(width, measuredHeight);
    }

    public void requestLayout() {
        if (!this.isUpdatingIndicator) {
            super.requestLayout();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.refresh();
    }

    private void refresh() {
        if (this.viewPager != null) {
            this.updateIndicators(this.viewPager.getCurrentItem(), this.viewPager.getAdapter());
            float offset = this.lastKnownPositionOffset >= 0.0f ? this.lastKnownPositionOffset : 0.0f;
            this.updateIndicatorPositions(this.lastKnownCurrentPage, offset, true);
        }
    }

    protected void onAttachedToWindow() {
        ViewPager pager;
        super.onAttachedToWindow();
        ViewParent parent = this.getParent();
        if (!(parent instanceof ViewPager)) {
            throw new IllegalStateException("ViewPagerIndicator must be a direct child of a ViewPager.");
        }
        this.viewPager = pager = (ViewPager)parent;
        PagerAdapter adapter = pager.getAdapter();
        pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageListener);
        pager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.pageListener);
        PagerAdapter lastAdapter = this.pagerAdapterRef != null ? (PagerAdapter)this.pagerAdapterRef.get() : null;
        this.updateAdapter(lastAdapter, adapter);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.viewPager != null) {
            this.updateAdapter(this.viewPager.getAdapter(), null);
            this.viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageListener);
            this.viewPager.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.pageListener);
            this.viewPager = null;
        }
    }

    private void updateAdapter(@Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
        if (oldAdapter != null) {
            oldAdapter.unregisterDataSetObserver((DataSetObserver)this.pageListener);
            this.pagerAdapterRef = null;
        }
        if (newAdapter != null) {
            newAdapter.registerDataSetObserver((DataSetObserver)this.pageListener);
            this.pagerAdapterRef = new WeakReference<PagerAdapter>(newAdapter);
        }
        if (this.viewPager != null) {
            this.lastKnownCurrentPage = -1;
            this.lastKnownPositionOffset = -1.0f;
            this.updateIndicators(this.viewPager.getCurrentItem(), newAdapter);
            this.requestLayout();
        }
    }

    private void updateIndicators(int currentPage, @Nullable PagerAdapter pagerAdapter) {
        this.isUpdatingIndicator = true;
        int pageCount = pagerAdapter == null ? 0 : pagerAdapter.getCount();
        this.updateDotCount(pageCount);
        this.lastKnownCurrentPage = currentPage;
        if (!this.isUpdatingPositions) {
            this.updateIndicatorPositions(currentPage, this.lastKnownPositionOffset, false);
        }
        this.isUpdatingIndicator = false;
    }

    private void updateDotCount(int newDotCount) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        int dotCount = this.indicatorDots.size();
        if (dotCount < newDotCount) {
            while (dotCount++ != newDotCount) {
                IndicatorDotView newDot = new IndicatorDotView(this.getContext());
                newDot.setRadius(this.dotRadius);
                newDot.setColor(this.unselectedDotColor);
                this.indicatorDots.add(newDot);
                this.addViewInLayout((View)newDot, -1, layoutParams, true);
            }
        } else if (dotCount > newDotCount) {
            ArrayList<IndicatorDotView> removedDots = new ArrayList<IndicatorDotView>(this.indicatorDots.subList(newDotCount, dotCount));
            for (IndicatorDotView removedDot : removedDots) {
                this.removeViewInLayout((View)removedDot);
            }
            this.indicatorDots.removeAll(removedDots);
        }
        this.updatePathCount(newDotCount - 1);
        if (newDotCount > 0) {
            this.addViewInLayout((View)this.selectedDot, -1, layoutParams, true);
        } else {
            this.removeViewInLayout((View)this.selectedDot);
        }
    }

    private void updatePathCount(int newPathCount) {
        int pathCount = this.dotPaths.size();
        if (pathCount < newPathCount) {
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
            while (pathCount++ != newPathCount) {
                IndicatorDotPathView newPath = new IndicatorDotPathView(this.getContext(), this.getUnselectedDotColor(), this.getDotPadding(), this.getDotRadius());
                newPath.setVisibility(4);
                this.dotPaths.add(newPath);
                this.addViewInLayout((View)newPath, -1, layoutParams, true);
            }
        } else if (pathCount > newPathCount && newPathCount >= 0) {
            ArrayList<IndicatorDotPathView> pathsToRemove = new ArrayList<IndicatorDotPathView>(this.dotPaths.subList(newPathCount, pathCount));
            for (IndicatorDotPathView dotPath : pathsToRemove) {
                this.removeViewInLayout((View)dotPath);
            }
            this.dotPaths.removeAll(pathsToRemove);
        }
    }

    private void updateIndicatorPositions(int currentPage, float positionOffset, boolean forceUpdate) {
        if (currentPage != this.lastKnownCurrentPage && this.viewPager != null) {
            this.updateIndicators(currentPage, this.viewPager.getAdapter());
        } else if (!forceUpdate && positionOffset == this.lastKnownPositionOffset) {
            return;
        }
        this.isUpdatingPositions = true;
        int dotWidth = 2 * this.dotRadius;
        int top = this.calculateIndicatorDotTop();
        int bottom = top + dotWidth;
        int left = this.calculateIndicatorDotStart();
        int right = left + dotWidth;
        int dotCount = this.indicatorDots.size();
        int pathCount = this.dotPaths.size();
        for (int i = 0; i < dotCount; ++i) {
            IndicatorDotView dotView = this.indicatorDots.get(i);
            dotView.layout(left, top, right, bottom);
            if (i < pathCount) {
                IndicatorDotPathView dotPath = this.dotPaths.get(i);
                dotPath.layout(left, top, left + dotPath.getMeasuredWidth(), bottom);
            }
            if (i == currentPage && this.selectedDotNeedsLayout) {
                this.selectedDot.layout(left, top, right, bottom);
                this.selectedDotNeedsLayout = false;
            }
            left = right + this.dotPadding;
            right = left + dotWidth;
        }
        this.selectedDot.bringToFront();
        this.lastKnownPositionOffset = positionOffset;
        this.isUpdatingPositions = false;
    }

    @Px
    private int calculateIndicatorDotTop() {
        int top;
        int verticalGravity = this.gravity & 0x70;
        switch (verticalGravity) {
            default: {
                top = (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2 - this.getDotRadius();
                break;
            }
            case 48: {
                top = this.getPaddingTop();
                break;
            }
            case 80: {
                top = this.getHeight() - this.getPaddingBottom() - 2 * this.getDotRadius();
            }
        }
        return top;
    }

    @Px
    private int calculateIndicatorDotStart() {
        int dotCount = this.indicatorDots.size();
        float halfDotCount = (float)dotCount / 2.0f;
        int dotWidth = 2 * this.dotRadius;
        float totalDotWidth = (float)dotWidth * halfDotCount;
        float halfDotPaddingCount = Math.max(halfDotCount - 0.5f, 0.0f);
        float totalDotPaddingWidth = (float)this.dotPadding * halfDotPaddingCount;
        int startPosition = this.getWidth() / 2;
        startPosition = (int)((float)startPosition - (totalDotWidth + totalDotPaddingWidth));
        return startPosition;
    }

    @Nullable
    private Animator pageChangeAnimator(int lastPageIndex, int newPageIndex) {
        final IndicatorDotPathView dotPath = this.getDotPathForPageChange(lastPageIndex, newPageIndex);
        final IndicatorDotView lastDot = this.getDotForPage(lastPageIndex);
        if (dotPath == null || lastDot == null) {
            String warning = dotPath == null ? "dotPath is null!" : "lastDot is null!";
            Log.w((String)TAG, (String)warning);
            return null;
        }
        Animator connectPathAnimator = dotPath.connectPathAnimator();
        connectPathAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                dotPath.setVisibility(0);
                lastDot.setVisibility(4);
            }
        });
        long dotSlideDuration = 150L;
        Animator selectedDotSlideAnimator = this.selectedDotSlideAnimator(newPageIndex, 150L, 0L);
        int pathDirection = this.getPathDirectionForPageChange(lastPageIndex, newPageIndex);
        Animator retreatPathAnimator = dotPath.retreatConnectedPathAnimator(pathDirection);
        Animator dotRevealAnimator = lastDot.revealAnimator();
        dotRevealAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                dotPath.setVisibility(4);
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play(connectPathAnimator).before(selectedDotSlideAnimator);
        animatorSet.play(retreatPathAnimator).after(selectedDotSlideAnimator);
        animatorSet.play(dotRevealAnimator).with(retreatPathAnimator);
        return animatorSet;
    }

    @NonNull
    private Animator selectedDotSlideAnimator(int newPageIndex, long animationDuration, long startDelay) {
        Rect newPageDotRect = new Rect();
        IndicatorDotView newPageDot = this.getDotForPage(newPageIndex);
        if (newPageDot != null) {
            newPageDot.getDrawingRect(newPageDotRect);
            this.offsetDescendantRectToMyCoords((View)newPageDot, newPageDotRect);
            this.offsetRectIntoDescendantCoords((View)this.selectedDot, newPageDotRect);
        }
        float toX = newPageDotRect.left;
        float toY = newPageDotRect.top;
        Animator animator = this.selectedDot.slideAnimator(toX, toY, animationDuration);
        animator.setStartDelay(startDelay);
        return animator;
    }

    @Nullable
    private IndicatorDotView getDotForPage(int pageIndex) {
        if (pageIndex > this.indicatorDots.size() - 1 || pageIndex < 0) {
            return null;
        }
        return this.indicatorDots.get(pageIndex);
    }

    @Nullable
    private IndicatorDotPathView getDotPathForPageChange(int oldPageIndex, int newPageIndex) {
        if (oldPageIndex < 0 || newPageIndex < 0 || oldPageIndex == newPageIndex) {
            return null;
        }
        int dotPathIndex = oldPageIndex < newPageIndex ? oldPageIndex : newPageIndex;
        return dotPathIndex >= this.dotPaths.size() ? null : this.dotPaths.get(dotPathIndex);
    }

    private int getPathDirectionForPageChange(int oldPageIndex, int newPageIndex) {
        return oldPageIndex < newPageIndex ? 1 : 0;
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int newGravity) {
        this.gravity = newGravity;
        this.requestLayout();
    }

    @Px
    public int getDotPadding() {
        return this.dotPadding;
    }

    public void setDotPadding(@Px int newDotPadding) {
        if (this.dotPadding == newDotPadding) {
            return;
        }
        if (newDotPadding < 0) {
            newDotPadding = 0;
        }
        this.dotPadding = newDotPadding;
        this.invalidate();
        this.requestLayout();
    }

    @Px
    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(@Px int newRadius) {
        if (this.dotRadius == newRadius) {
            return;
        }
        if (newRadius < 0) {
            newRadius = 0;
        }
        this.dotRadius = newRadius;
        for (IndicatorDotView indicatorDot : this.indicatorDots) {
            indicatorDot.setRadius(this.dotRadius);
        }
        this.invalidate();
        this.requestLayout();
    }

    @ColorInt
    public int getUnselectedDotColor() {
        return this.unselectedDotColor;
    }

    public void setUnselectedDotColor(@ColorInt int color) {
        this.unselectedDotColor = color;
        for (IndicatorDotView indicatordot : this.indicatorDots) {
            indicatordot.setColor(color);
            indicatordot.invalidate();
        }
    }

    @ColorInt
    public int getSelectedDotColor() {
        return this.selectedDotColor;
    }

    public void setSelectedDotColor(@ColorInt int color) {
        this.selectedDotColor = color;
        if (this.selectedDot != null) {
            this.selectedDot.setColor(color);
            this.selectedDot.invalidate();
        }
    }

    private class PageListener
    extends DataSetObserver
    implements ViewPager.OnPageChangeListener,
    ViewPager.OnAdapterChangeListener {
        private int scrollState;

        private PageListener() {
        }

        public void onChanged() {
            super.onChanged();
            ViewPagerIndicator.this.refresh();
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            Animator pageChangeAnimator = ViewPagerIndicator.this.pageChangeAnimator(ViewPagerIndicator.this.lastKnownCurrentPage, position);
            if (this.scrollState == 0 && ViewPagerIndicator.this.viewPager != null) {
                ViewPagerIndicator.this.refresh();
            }
            if (pageChangeAnimator != null) {
                pageChangeAnimator.start();
            }
            ViewPagerIndicator.this.lastKnownCurrentPage = position;
        }

        public void onPageScrollStateChanged(int state) {
            this.scrollState = state;
        }

        public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            ViewPagerIndicator.this.updateAdapter(oldAdapter, newAdapter);
        }
    }
}

