/*
 * Decompiled with CFR 0.152.
 */
package com.github.rocketchat.livechat;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.UiThread;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatSpinner;
import android.support.v7.widget.AppCompatTextView;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import com.github.rocketchat.R;
import com.github.rocketchat.livechat.Application.LiveChatApplication;
import com.github.rocketchat.model.Department;
import com.github.rocketchat.utils.AppUtils;
import io.rocketchat.common.data.model.ErrorObject;
import io.rocketchat.livechat.LiveChatAPI;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.ConnectListener;
import io.rocketchat.livechat.callback.InitialDataListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.model.GuestObject;
import io.rocketchat.livechat.model.LiveChatConfigObject;
import java.util.ArrayList;

public class SignupActivity
extends AppCompatActivity
implements ConnectListener,
AuthListener.RegisterListener,
AuthListener.LoginListener,
InitialDataListener,
MessageListener.OfflineMessageListener {
    AppCompatEditText username;
    AppCompatEditText email;
    AppCompatButton register;
    AppCompatTextView default_message;
    AppCompatTextView success_message;
    AppCompatEditText message;
    LiveChatAPI api;
    ProgressDialog dialog;
    private SharedPreferences.Editor editor;
    AppCompatSpinner departments;
    Boolean isconnected = false;
    Boolean isOfflineForm = false;
    LiveChatConfigObject chatConfigObject;
    private String selectedDeptId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_signup);
        this.getSupportActionBar().setTitle((CharSequence)"LiveChat Registration");
        this.api = ((LiveChatApplication)this.getApplicationContext()).getLiveChatAPI();
        this.api.setReconnectionStrategy(null);
        this.api.connect((ConnectListener)this);
        this.username = (AppCompatEditText)this.findViewById(R.id.userid);
        this.email = (AppCompatEditText)this.findViewById(R.id.email);
        this.default_message = (AppCompatTextView)this.findViewById(R.id.offline_message);
        this.message = (AppCompatEditText)this.findViewById(R.id.message);
        this.success_message = (AppCompatTextView)this.findViewById(R.id.success_message);
        this.departments = (AppCompatSpinner)this.findViewById(R.id.departments);
        this.register = (AppCompatButton)this.findViewById(R.id.register);
        this.dialog = new ProgressDialog((Context)this);
        this.dialog.setIndeterminate(true);
        this.dialog.setMessage((CharSequence)"Registering ...");
        SharedPreferences sharedPref = this.getPreferences(0);
        this.editor = sharedPref.edit();
        String Username = sharedPref.getString("username", null);
        String Email = sharedPref.getString("email", null);
        if (Username != null) {
            this.username.setText((CharSequence)Username);
            this.email.setText((CharSequence)Email);
        }
        this.register.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String username = SignupActivity.this.username.getText().toString();
                String email = SignupActivity.this.email.getText().toString();
                if (username.isEmpty() || email.isEmpty()) {
                    AppUtils.showToast((Context)SignupActivity.this, "username and email shouldn't be null", true);
                } else if (SignupActivity.this.isconnected.booleanValue()) {
                    if (SignupActivity.this.isOfflineForm.booleanValue()) {
                        String message = SignupActivity.this.message.getText().toString();
                        SignupActivity.this.dialog.setMessage((CharSequence)"Sending message ...");
                        SignupActivity.this.dialog.show();
                        SignupActivity.this.api.sendOfflineMessage(username, email, message, (MessageListener.OfflineMessageListener)SignupActivity.this);
                    } else {
                        SignupActivity.this.dialog.show();
                        SignupActivity.this.api.registerGuest(username, email, SignupActivity.this.selectedDeptId, (AuthListener.RegisterListener)SignupActivity.this);
                    }
                } else {
                    AppUtils.showToast((Context)SignupActivity.this, "Not connected to server", true);
                }
            }
        });
    }

    public void onConnect(String sessionID) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Snackbar.make((View)SignupActivity.this.findViewById(R.id.activity_signup), (int)R.string.connected, (int)0).show();
            }
        });
        this.api.getInitialData((InitialDataListener)this);
    }

    public void onDisconnect(boolean closedByServer) {
        this.isconnected = false;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppUtils.getSnackbar(SignupActivity.this.findViewById(R.id.activity_signup), R.string.disconnected_from_server).setAction((CharSequence)"RETRY", new View.OnClickListener(){

                    public void onClick(View view) {
                        SignupActivity.this.api.reconnect();
                    }
                }).show();
            }
        });
    }

    public void onConnectError(Exception websocketException) {
        this.isconnected = false;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppUtils.getSnackbar(SignupActivity.this.findViewById(R.id.activity_signup), R.string.connection_error).setAction((CharSequence)"RETRY", new View.OnClickListener(){

                    public void onClick(View view) {
                        SignupActivity.this.api.reconnect();
                    }
                }).show();
            }
        });
    }

    public void onInitialData(LiveChatConfigObject object, ErrorObject error) {
        if (error == null) {
            this.isconnected = true;
            this.chatConfigObject = object;
            if (this.chatConfigObject.getEnabled().booleanValue()) {
                if (this.chatConfigObject.getOnline().booleanValue()) {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            SignupActivity.this.setUpRegistrationForm(SignupActivity.this.chatConfigObject.getPopupTitle(), Department.getDepartments(SignupActivity.this.chatConfigObject.getDepartments()));
                        }
                    });
                } else if (this.chatConfigObject.getDisplayOfflineFOrm().booleanValue()) {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            SignupActivity.this.setUpOfflineForm(SignupActivity.this.chatConfigObject.getOfflineTitle(), SignupActivity.this.chatConfigObject.getOfflineMessage());
                        }
                    });
                } else {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            SignupActivity.this.showSuccessMessage(SignupActivity.this.chatConfigObject.getOfflineUnavailableMessage());
                        }
                    });
                }
            } else {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        SignupActivity.this.showSuccessMessage(R.string.livechat_enabled);
                    }
                });
            }
        }
    }

    public void onRegister(GuestObject object, final ErrorObject error) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (error != null) {
                    AppUtils.showToast((Context)SignupActivity.this, error.getMessage(), false);
                    SignupActivity.this.dialog.dismiss();
                } else {
                    AppUtils.showToast((Context)SignupActivity.this, "Registration successful", false);
                    SignupActivity.this.dialog.dismiss();
                }
            }
        });
        if (error == null) {
            this.api.login(object.getToken(), (AuthListener.LoginListener)this);
        }
    }

    public void onLogin(GuestObject object, ErrorObject error) {
        if (error == null) {
            System.out.println("login success");
            this.editor.putString("username", this.username.getText().toString());
            this.editor.putString("email", this.email.getText().toString());
            this.editor.commit();
            LiveChatAPI.ChatRoom room = this.api.createRoom(object.getUserID(), object.getToken());
            Intent intent = new Intent();
            intent.putExtra("roomInfo", room.toString());
            intent.putExtra("title", this.chatConfigObject.getPopupTitle());
            this.setResult(-1, intent);
            this.finish();
        }
    }

    public void onBackPressed() {
        this.setResult(0);
        this.finish();
    }

    public void setUpOfflineForm(String offlineTitle, String defaultMessage) {
        this.isOfflineForm = true;
        this.default_message.setVisibility(0);
        this.message.setVisibility(0);
        this.success_message.setVisibility(8);
        this.username.setHint(R.string.type_name);
        this.email.setHint(R.string.type_email);
        this.departments.setVisibility(8);
        this.register.setText(R.string.button_send);
        this.getSupportActionBar().setTitle((CharSequence)offlineTitle);
        if (!defaultMessage.equals("")) {
            this.default_message.setText((CharSequence)defaultMessage);
        }
    }

    public void setUpRegistrationForm(String title, final ArrayList<Department> showDepartments) {
        this.isOfflineForm = false;
        this.default_message.setVisibility(8);
        this.message.setVisibility(8);
        this.success_message.setVisibility(8);
        this.username.setHint(R.string.username);
        this.email.setHint(R.string.emailid);
        this.register.setHint(R.string.register);
        this.getSupportActionBar().setTitle((CharSequence)title);
        if (showDepartments.size() > 0) {
            this.selectedDeptId = showDepartments.get(0).getId();
        }
        if (showDepartments.size() > 1) {
            this.departments.setVisibility(0);
            ArrayAdapter adapter = new ArrayAdapter((Context)this, 17367048, showDepartments);
            adapter.setDropDownViewResource(0x1090009);
            this.departments.setAdapter((SpinnerAdapter)adapter);
            this.departments.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                    Department selectedDept = (Department)showDepartments.get(i);
                    System.out.println(selectedDept.toString());
                    SignupActivity.this.selectedDeptId = selectedDept.getId();
                }

                public void onNothingSelected(AdapterView<?> adapterView) {
                }
            });
        }
    }

    @UiThread
    public void showSuccessMessage(Object msg) {
        this.default_message.setVisibility(8);
        this.message.setVisibility(8);
        this.username.setVisibility(8);
        this.email.setVisibility(8);
        this.register.setVisibility(8);
        this.departments.setVisibility(8);
        this.success_message.setVisibility(0);
        if (msg instanceof CharSequence) {
            this.success_message.setText((CharSequence)msg);
        } else {
            this.success_message.setText(((Integer)msg).intValue());
        }
    }

    public void onOfflineMesssageSuccess(Boolean success, ErrorObject error) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (SignupActivity.this.dialog.isShowing()) {
                    SignupActivity.this.dialog.dismiss();
                }
                if (SignupActivity.this.chatConfigObject.getOfflineSuccessMessage().equals("")) {
                    SignupActivity.this.showSuccessMessage(R.string.successMessage);
                } else {
                    SignupActivity.this.showSuccessMessage(SignupActivity.this.chatConfigObject.getOfflineSuccessMessage());
                }
            }
        });
    }
}

