/*
 * Decompiled with CFR 0.152.
 */
package eu.roboflax.cloudflare.objects.crypto.customhostname;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import eu.roboflax.cloudflare.objects.Identifiable;
import eu.roboflax.cloudflare.objects.crypto.customhostname.Method;
import eu.roboflax.cloudflare.objects.crypto.customhostname.Settings;
import eu.roboflax.cloudflare.objects.crypto.customhostname.SslStatus;
import eu.roboflax.cloudflare.objects.crypto.customhostname.Type;

public class Ssl
implements Identifiable {
    @SerializedName(value="id")
    @Expose
    private String id;
    @SerializedName(value="method")
    @Expose
    private Method method;
    @SerializedName(value="type")
    @Expose
    private Type type;
    @SerializedName(value="settings")
    @Expose
    private Settings settings;
    @SerializedName(value="status")
    @Expose
    private SslStatus status;
    @SerializedName(value="http_url")
    @Expose
    private String httpUrl;
    @SerializedName(value="http_body")
    @Expose
    private String httpBody;

    public static SslBuilder builder() {
        return new SslBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Method getMethod() {
        return this.method;
    }

    public Type getType() {
        return this.type;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public SslStatus getStatus() {
        return this.status;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public String getHttpBody() {
        return this.httpBody;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setStatus(SslStatus status) {
        this.status = status;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public void setHttpBody(String httpBody) {
        this.httpBody = httpBody;
    }

    public String toString() {
        return "Ssl(id=" + this.getId() + ", method=" + (Object)((Object)this.getMethod()) + ", type=" + (Object)((Object)this.getType()) + ", settings=" + this.getSettings() + ", status=" + (Object)((Object)this.getStatus()) + ", httpUrl=" + this.getHttpUrl() + ", httpBody=" + this.getHttpBody() + ")";
    }

    public Ssl(String id, Method method, Type type, Settings settings, SslStatus status, String httpUrl, String httpBody) {
        this.id = id;
        this.method = method;
        this.type = type;
        this.settings = settings;
        this.status = status;
        this.httpUrl = httpUrl;
        this.httpBody = httpBody;
    }

    public Ssl() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ssl)) {
            return false;
        }
        Ssl other = (Ssl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        SslStatus this$status = this.getStatus();
        SslStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$httpUrl = this.getHttpUrl();
        String other$httpUrl = other.getHttpUrl();
        if (this$httpUrl == null ? other$httpUrl != null : !this$httpUrl.equals(other$httpUrl)) {
            return false;
        }
        String this$httpBody = this.getHttpBody();
        String other$httpBody = other.getHttpBody();
        return !(this$httpBody == null ? other$httpBody != null : !this$httpBody.equals(other$httpBody));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Ssl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        SslStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $httpUrl = this.getHttpUrl();
        result = result * 59 + ($httpUrl == null ? 43 : $httpUrl.hashCode());
        String $httpBody = this.getHttpBody();
        result = result * 59 + ($httpBody == null ? 43 : $httpBody.hashCode());
        return result;
    }

    public static class SslBuilder {
        private String id;
        private Method method;
        private Type type;
        private Settings settings;
        private SslStatus status;
        private String httpUrl;
        private String httpBody;

        SslBuilder() {
        }

        public SslBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SslBuilder method(Method method) {
            this.method = method;
            return this;
        }

        public SslBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public SslBuilder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public SslBuilder status(SslStatus status) {
            this.status = status;
            return this;
        }

        public SslBuilder httpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
            return this;
        }

        public SslBuilder httpBody(String httpBody) {
            this.httpBody = httpBody;
            return this;
        }

        public Ssl build() {
            return new Ssl(this.id, this.method, this.type, this.settings, this.status, this.httpUrl, this.httpBody);
        }

        public String toString() {
            return "Ssl.SslBuilder(id=" + this.id + ", method=" + (Object)((Object)this.method) + ", type=" + (Object)((Object)this.type) + ", settings=" + this.settings + ", status=" + (Object)((Object)this.status) + ", httpUrl=" + this.httpUrl + ", httpBody=" + this.httpBody + ")";
        }
    }
}

