/*
 * Decompiled with CFR 0.152.
 */
package eu.roboflax.cloudflare.objects.crypto.customhostname;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import eu.roboflax.cloudflare.objects.crypto.customhostname.Status;
import eu.roboflax.cloudflare.objects.crypto.customhostname.TlsVersion;
import java.util.HashSet;
import java.util.Set;

public class Settings {
    @SerializedName(value="http2")
    @Expose
    private Status http2;
    @SerializedName(value="min_tls_version")
    @Expose
    private TlsVersion minTlsVersion;
    @SerializedName(value="tls_1_3")
    @Expose
    private Status tls13;
    @SerializedName(value="ciphers")
    @Expose
    private Set<String> ciphers = new HashSet<String>();

    public static SettingsBuilder builder() {
        return new SettingsBuilder();
    }

    public Status getHttp2() {
        return this.http2;
    }

    public TlsVersion getMinTlsVersion() {
        return this.minTlsVersion;
    }

    public Status getTls13() {
        return this.tls13;
    }

    public Set<String> getCiphers() {
        return this.ciphers;
    }

    public void setHttp2(Status http2) {
        this.http2 = http2;
    }

    public void setMinTlsVersion(TlsVersion minTlsVersion) {
        this.minTlsVersion = minTlsVersion;
    }

    public void setTls13(Status tls13) {
        this.tls13 = tls13;
    }

    public void setCiphers(Set<String> ciphers) {
        this.ciphers = ciphers;
    }

    public String toString() {
        return "Settings(http2=" + (Object)((Object)this.getHttp2()) + ", minTlsVersion=" + (Object)((Object)this.getMinTlsVersion()) + ", tls13=" + (Object)((Object)this.getTls13()) + ", ciphers=" + this.getCiphers() + ")";
    }

    public Settings(Status http2, TlsVersion minTlsVersion, Status tls13, Set<String> ciphers) {
        this.http2 = http2;
        this.minTlsVersion = minTlsVersion;
        this.tls13 = tls13;
        this.ciphers = ciphers;
    }

    public Settings() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Settings)) {
            return false;
        }
        Settings other = (Settings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Status this$http2 = this.getHttp2();
        Status other$http2 = other.getHttp2();
        if (this$http2 == null ? other$http2 != null : !((Object)((Object)this$http2)).equals((Object)other$http2)) {
            return false;
        }
        TlsVersion this$minTlsVersion = this.getMinTlsVersion();
        TlsVersion other$minTlsVersion = other.getMinTlsVersion();
        if (this$minTlsVersion == null ? other$minTlsVersion != null : !((Object)((Object)this$minTlsVersion)).equals((Object)other$minTlsVersion)) {
            return false;
        }
        Status this$tls13 = this.getTls13();
        Status other$tls13 = other.getTls13();
        if (this$tls13 == null ? other$tls13 != null : !((Object)((Object)this$tls13)).equals((Object)other$tls13)) {
            return false;
        }
        Set<String> this$ciphers = this.getCiphers();
        Set<String> other$ciphers = other.getCiphers();
        return !(this$ciphers == null ? other$ciphers != null : !((Object)this$ciphers).equals(other$ciphers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Settings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $http2 = this.getHttp2();
        result = result * 59 + ($http2 == null ? 43 : ((Object)((Object)$http2)).hashCode());
        TlsVersion $minTlsVersion = this.getMinTlsVersion();
        result = result * 59 + ($minTlsVersion == null ? 43 : ((Object)((Object)$minTlsVersion)).hashCode());
        Status $tls13 = this.getTls13();
        result = result * 59 + ($tls13 == null ? 43 : ((Object)((Object)$tls13)).hashCode());
        Set<String> $ciphers = this.getCiphers();
        result = result * 59 + ($ciphers == null ? 43 : ((Object)$ciphers).hashCode());
        return result;
    }

    public static class SettingsBuilder {
        private Status http2;
        private TlsVersion minTlsVersion;
        private Status tls13;
        private Set<String> ciphers;

        SettingsBuilder() {
        }

        public SettingsBuilder http2(Status http2) {
            this.http2 = http2;
            return this;
        }

        public SettingsBuilder minTlsVersion(TlsVersion minTlsVersion) {
            this.minTlsVersion = minTlsVersion;
            return this;
        }

        public SettingsBuilder tls13(Status tls13) {
            this.tls13 = tls13;
            return this;
        }

        public SettingsBuilder ciphers(Set<String> ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        public Settings build() {
            return new Settings(this.http2, this.minTlsVersion, this.tls13, this.ciphers);
        }

        public String toString() {
            return "Settings.SettingsBuilder(http2=" + (Object)((Object)this.http2) + ", minTlsVersion=" + (Object)((Object)this.minTlsVersion) + ", tls13=" + (Object)((Object)this.tls13) + ", ciphers=" + this.ciphers + ")";
        }
    }
}

