/*
 * Decompiled with CFR 0.152.
 */
package eu.roboflax.cloudflare.constants;

import eu.roboflax.cloudflare.http.HttpMethod;

public enum Category {
    USER_DETAILS(HttpMethod.GET, "user"),
    UPDATE_USER(HttpMethod.PATCH, "user"),
    USER_BILLING_PROFILE(HttpMethod.GET, "user/billing/profile"),
    USER_BILLING_HISTORY(HttpMethod.GET, "user/billing/history"),
    USER_SUBSCRIPTION(HttpMethod.GET, "user/subscription"),
    UPDATE_USER_SUBSCRIPTION(HttpMethod.PUT, "user/subscriptions/{id-1}"),
    DELETE_USER_SUBSCRIPTION(HttpMethod.DELETE, "user/subscriptions/{id-1}"),
    LIST_USER_ACCESS_RULES(HttpMethod.GET, "user/firewall/access_rules/rules"),
    CREATE_USER_ACCESS_RULE(HttpMethod.POST, "user/firewall/access_rules/rules"),
    UPDATE_USER_ACCESS_RULE(HttpMethod.PATCH, "user/firewall/access_rules/rules/{id-1}"),
    DELETE_USER_ACCESS_RULE(HttpMethod.DELETE, "user/firewall/access_rules/rules/{id-1}"),
    LIST_USER_ORGANIZATIONS(HttpMethod.GET, "user/organizations"),
    USER_ORGANIZATION_DETAILS(HttpMethod.GET, "user/organizations/{id-1}"),
    USER_LEAVE_ORGANIZATION(HttpMethod.DELETE, "user/organizations/{id-1}"),
    LIST_USER_INVITES(HttpMethod.GET, "user/invites"),
    USER_INVITATION_DETAILS(HttpMethod.GET, "user/invites/{id-1}"),
    USER_RESPOND_INVITATION(HttpMethod.PATCH, "user/invites/{id-1}"),
    CREATE_ZONE(HttpMethod.POST, "zones"),
    INITIATE_ANOTHER_ZONE_ACTIVATION_CHECK(HttpMethod.PUT, "zones/{id-1}/activation_check"),
    LIST_ZONES(HttpMethod.GET, "zones"),
    ZONE_DETAILS(HttpMethod.GET, "zones/{id-1}"),
    EDIT_ZONE_PROPERTIES(HttpMethod.PATCH, "zones/{id-1}"),
    PURGE_ZONE_ALL_FILES(HttpMethod.DELETE, "zones/{id-1}/purge_cache"),
    PURGE_ZONE_FILES_BY_URL(HttpMethod.DELETE, "zones/{id-1}/purge_cache"),
    PURGE_ZONE_FILES_BY_CACHE_TAG_OR_HOST(HttpMethod.DELETE, "zones/{id-1}/purge_cache"),
    DELETE_ZONE(HttpMethod.DELETE, "zones/{id-1}"),
    ZONE_RATE_PLAN(HttpMethod.GET, "zones/{id-1}/available_rate_plans"),
    LIST_ZONE_SETTINGS(HttpMethod.GET, "zones/{id-1}/settings"),
    DDOS_SETTING(HttpMethod.GET, "zones/{id-1}/settings/advanced_ddos"),
    ALWAYS_ONLINE_SETTING(HttpMethod.GET, "zones/{id-1}/settings/always_online"),
    ALWAYS_USE_HTTPS_SETTING(HttpMethod.GET, "zones/{id-1}/settings/always_use_https"),
    AUTOMATIC_HTTPS_REWRITES_SETTING(HttpMethod.GET, "zones/{id-1}/settings/automatic_https_rewrites"),
    BROWSER_CACHE_TTL_SETTING(HttpMethod.GET, "zones/{id-1}/settings/browser_cache_ttl"),
    BROWSER_CHECK_SETTING(HttpMethod.GET, "zones/{id-1}/settings/browser_check"),
    CACHE_LEVEL_SETTING(HttpMethod.GET, "zones/{id-1}/settings/cache_level"),
    CHALLENGE_TTL_SETTING(HttpMethod.GET, "zones/{id-1}/settings/challenge_ttl"),
    DEV_MODE_SETTING(HttpMethod.GET, "zones/{id-1}/settings/development_mode"),
    EMAIL_OBFUSCATION_SETTING(HttpMethod.GET, "zones/{id-1}/settings/email_obfuscation"),
    HOTLINK_PROTECTION_SETTING(HttpMethod.GET, "zones/{id-1}/settings/hotlink_protection"),
    IP_GEOLOCATION_SETTING(HttpMethod.GET, "zones/{id-1}/settings/ip_geolocation"),
    IPV6_SETTING(HttpMethod.GET, "zones/{id-1}/settings/ipv6"),
    MINIFY_SETTING(HttpMethod.GET, "zones/{id-1}/settings/minify"),
    MOBILE_REDIRECT_SETTING(HttpMethod.GET, "zones/{id-1}/settings/mobile_redirect"),
    MIRAGE_SETTING(HttpMethod.GET, "zones/{id-1}/settings/mirage"),
    ENABLE_ERROR_PAGES_SETTING(HttpMethod.GET, "zones/{id-1}/settings/origin_error_page_pass_thru"),
    OPPORTUNISTIC_ENCRYPTION_SETTING(HttpMethod.GET, "zones/{id-1}/settings/opportunistic_encryption"),
    POLISH_SETTING(HttpMethod.GET, "zones/{id-1}/settings/polish"),
    WEBP_SETTING(HttpMethod.GET, "zones/{id-1}/settings/webp"),
    PREFECH_PRELOAD_SETTING(HttpMethod.GET, "zones/{id-1}/settings/prefetch_preload"),
    RESPONSE_BUFFERING_SETTING(HttpMethod.GET, "zones/{id-1}/settings/response_buffering"),
    ROCKET_LOADER_SETTING(HttpMethod.GET, "zones/{id-1}/settings/rocket_loader"),
    SECURITY_HEADER_SETTING(HttpMethod.GET, "zones/{id-1}/settings/security_header"),
    SECURITY_LEVEL_SETTING(HttpMethod.GET, "zones/{id-1}/settings/security_level"),
    SERVER_SIDE_EXCLUDE_SETTING(HttpMethod.GET, "zones/{id-1}/settings/server_side_exclude"),
    ENABLE_QUERY_STRING_SORT_SETTING(HttpMethod.GET, "zones/{id-1}/settings/sort_query_string_for_cache"),
    SSL_SETTING(HttpMethod.GET, "zones/{id-1}/settings/ssl"),
    ENABLE_TLS_1_2_SETTING(HttpMethod.GET, "zones/{id-1}/settings/tls_1_2_only"),
    ENABLE_TLS_1_3_SETTING(HttpMethod.GET, "zones/{id-1}/settings/tls_1_3"),
    TLS_CLIENT_AUTH_SETTING(HttpMethod.GET, "zones/{id-1}/settings/tls_client_auth"),
    TRUE_CLIENT_IP_SETTING(HttpMethod.GET, "zones/{id-1}/settings/true_client_ip_header"),
    WEB_APPLICATION_FIREWALL_SETTING(HttpMethod.GET, "zones/{id-1}/settings/waf"),
    HTTP2_SETTING(HttpMethod.GET, "zones/{id-1}/settings/http2"),
    PSEUDO_IPV4_SETTING(HttpMethod.GET, "zones/{id-1}/settings/pseudo_ipv4"),
    WEBSOCKETS_SETTING(HttpMethod.GET, "zones/{id-1}/settings/websockets"),
    EDIT_ZONE_SETTINGS_INFO(HttpMethod.PATCH, "zones/{id-1}/settings"),
    CHANGE_ALWAYS_ONLINE_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/always_online"),
    CHANGE_ALWAYS_USE_HTTPS_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/always_use_https"),
    CHANGE_AUTOMATIC_HTTPS_REWRITES_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/automatic_https_rewrites"),
    CHANGE_BROWSER_CACHE_TTL_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/browser_cache_ttl"),
    CHANGE_BROWSER_CHECK_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/browser_check"),
    CHANGE_CACHE_LEVEL_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/cache_level"),
    CHANGE_CHALLENGE_TTL_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/challenge_ttl"),
    CHANGE_DEV_MODE_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/development_mode"),
    CHANGE_EMAIL_OBFUSCATION_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/email_obfuscation"),
    CHANGE_ENABLE_ERROR_PAGES_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/origin_error_page_pass_thru"),
    CHANGE_ENABLE_QUERY_STRING_SORT_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/sort_query_string_for_cache"),
    CHANGE_HOTLINK_PROTECTION_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/hotlink_protection"),
    CHANGE_IP_GEOLOCATION_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/ip_geolocation"),
    CHANGE_IPV6_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/ipv6"),
    CHANGE_MINIFY_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/minify"),
    CHANGE_MOBILE_REDIRECT_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/mobile_redirect"),
    CHANGE_MIRAGE_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/mirage"),
    CHANGE_OPPORTUNISTIC_ENCRYPTION_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/opportunistic_encryption"),
    CHANGE_POLISH_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/polish"),
    CHANGE_WEBP_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/webp"),
    CHANGE_PREFECH_PRELOAD_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/prefetch_preload"),
    CHANGE_RESPONSE_BUFFERING_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/response_buffering"),
    CHANGE_ROCKET_LOADER_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/rocket_loader"),
    CHANGE_SECURITY_HEADER_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/security_header"),
    CHANGE_SECURITY_LEVEL_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/security_level"),
    CHANGE_SERVER_SIDE_EXCLUDE_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/server_side_exclude"),
    CHANGE_SSL_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/ssl"),
    CHANGE_ENABLE_TLS_1_2_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/tls_1_2_only"),
    CHANGE_ENABLE_TLS_1_3_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/tls_1_3"),
    CHANGE_TLS_CLIENT_AUTH_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/tls_client_auth"),
    CHANGE_TRUE_CLIENT_IP_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/true_client_ip_header"),
    CHANGE_WEB_APPLICATION_FIREWALL_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/waf"),
    CHANGE_HTTP2_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/http2"),
    CHANGE_PSEUDO_IPV4_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/pseudo_ipv4"),
    CHANGE_WEBSOCKETS_SETTING(HttpMethod.PATCH, "zones/{id-1}/settings/websockets"),
    CREATE_DNS_RECORD(HttpMethod.POST, "zones/{id-1}/dns_records"),
    LIST_DNS_RECORDS(HttpMethod.GET, "zones/{id-1}/dns_records"),
    DNS_RECORD_DETAILS(HttpMethod.GET, "zones/{id-1}/dns_records/{id-2}"),
    UPDATE_DNS_RECORD(HttpMethod.PUT, "zones/{id-1}/dns_records/{id-2}"),
    DELETE_DNS_RECORD(HttpMethod.DELETE, "zones/{id-1}/dns_records/{id-2}"),
    IMPORT_DNS_RECORDS(HttpMethod.POST, "zones/{id-1}/dns_records/import"),
    ZONE_RAILGRUNS_AVAILABLE(HttpMethod.GET, "zones/{id-1}/railguns"),
    ZONE_RAILGUN_DETAILS(HttpMethod.GET, "zones/{id-1}/railguns/{id-2}"),
    ZONE_TEST_RAILGUN_CONNECTION(HttpMethod.GET, "zones/{id-1}/railguns/{id-2}/diagnose"),
    ZONE_CONNECT_OR_DISCONNECT_RAILGUN(HttpMethod.PATCH, "zones/{id-1}/railguns/{id-2}"),
    ANALYTICS_DASHBOARD(HttpMethod.GET, "zones/{id-1}/analytics/dashboard"),
    ANALYTICS_BY_CO_LOCATIONS(HttpMethod.GET, "zones/{id-1}/analytics/colos"),
    ANALYTICS_TABLE(HttpMethod.GET, "zones/{id-1}/dns_analytics/report"),
    ANALYTICS_BY_TIME(HttpMethod.GET, "zones/{id-1}/dns_analytics/report/bytime"),
    CREATE_RAILGUN(HttpMethod.POST, "railguns"),
    LIST_RAILGUNS(HttpMethod.GET, "railguns"),
    RAILGUN_DETAILS(HttpMethod.GET, "railguns/{id-1}"),
    ZONES_CONNECTED_TO_RAILGUN(HttpMethod.GET, "railguns/{id-1}/zones"),
    ENABLE_OR_DISABLE_RAILGUN(HttpMethod.PATCH, "railguns/{id-1}"),
    DELETE_RAILGUN(HttpMethod.DELETE, "railguns/{id-1}"),
    CUSTOM_PAGES_AVAILABLE(HttpMethod.GET, "zones/{id-1}/custom_pages"),
    CUSTOM_PAGE_DETAILS(HttpMethod.GET, "zones/{id-1}/custom_pages/{id-2}"),
    UPDATE_CUSTOM_PAGE_URL(HttpMethod.PUT, "zones/{id-1}/custom_pages/{id-2}"),
    CREATE_SSL_CONFIGURATION(HttpMethod.POST, "zones/{id-1}/custom_certificates"),
    LIST_SSL_CONFIGURATIONS(HttpMethod.GET, "zones/{id-1}/custom_certificates"),
    SSL_CONFIGURATION_DETAILS(HttpMethod.GET, "zones/{id-1}/custom_certificates/{id-2}"),
    UPDATE_SSL_CONFIGURATION(HttpMethod.PATCH, "zones/{id-1}/custom_certificates/{id-2}"),
    RE_PRIORITIZE_SSL_CERTIFICATES(HttpMethod.PUT, "zones/{id-1}/custom_certificates/prioritize"),
    DELETE_SSL_CERTIFICATE(HttpMethod.DELETE, "zones/{id-1}/custom_certificates/{id-2}"),
    CREATE_CUSTOM_HOSTNAME(HttpMethod.POST, "zones/{id-1}/custom_hostnames"),
    LIST_CUSTOM_HOSTNAMES(HttpMethod.GET, "zones/{id-1}/custom_hostnames"),
    CUSTOM_HOSTNAME_CONFIGURATION_DETAILS(HttpMethod.GET, "zones/{id-1}/custom_hostnames/{id-2}"),
    UPDATE_CUSTOM_HOSTNAME_CONFIGURATION(HttpMethod.PATCH, "zones/{id-1}/custom_hostnames/{id-2}"),
    DELETE_CUSTOM_HOSTNAME_CONFIGURATION(HttpMethod.DELETE, "zones/{id-1}/custom_hostnames/{id-2}"),
    CREATE_KEYLESS_SSL_CONFIGURATION(HttpMethod.POST, "zones/{id-1}/keyless_certificates"),
    LIST_KEYLESS_SSL_CONFIGURATIONS(HttpMethod.GET, "zones/{id-1}/keyless_certificates"),
    KEYLESS_SSL_DETAILS(HttpMethod.GET, "zones/{id-1}/keyless_certificates/{id-2}"),
    UPDATE_KEYLESS_SSL_CONFIGURATION(HttpMethod.PATCH, "zones/{id-1}/keyless_certificates/{id-2}"),
    DELETE_KEYLESS_CONFIGURATION(HttpMethod.DELETE, "zones/{id-1}/keyless_certificates/{id-2}"),
    CREATE_PAGE_RULE(HttpMethod.POST, "zones/{id-1}/pagerules"),
    LIST_PAGE_RULES(HttpMethod.GET, "zones/{id-1}/pagerules"),
    PAGE_RULE_DETAILS(HttpMethod.GET, "zones/{id-1}/pagerules/{id-2}"),
    CHANGE_PAGE_RULE(HttpMethod.PATCH, "zones/{id-1}/pagerules/{id-2}"),
    UPDATE_PAGE_RULE(HttpMethod.PUT, "zones/{id-1}/pagerules/{id-2}"),
    DELETE_PAGE_RULE(HttpMethod.DELETE, "zones/{id-1}/pagerules/{id-2}"),
    LIST_RATE_LIMITS(HttpMethod.GET, "zones/{id-1}/rate_limits"),
    CREATE_RATE_LIMIT(HttpMethod.POST, "zones/{id-1}/rate_limits"),
    RATE_LIMIT_DETAILS(HttpMethod.GET, "zones/{id-1}/rate_limits/{id-2}"),
    UPDATE_RATE_LIMIT(HttpMethod.PUT, "zones/{id-1}/rate_limits/{id-2}"),
    DELETE_RATE_LIMIT(HttpMethod.DELETE, "zones/{id-1}/rate_limits/{id-2}"),
    LIST_ZONE_ACCESS_RULES(HttpMethod.GET, "zones/{id-1}/firewall/access_rules/rules"),
    CREATE_ZONE_ACCESS_RULE(HttpMethod.POST, "zones/{id-1}/firewall/access_rules/rules"),
    UPDATE_ZONE_ACCESS_RULE(HttpMethod.PATCH, "zones/{id-1}/firewall/access_rules/rules/{id-2}"),
    DELETE_ZONE_ACCESS_RULE(HttpMethod.DELETE, "zones/{id-1}/firewall/access_rules/rules/{id-2}"),
    LIST_FIREWALL_PACKAGES(HttpMethod.GET, "zones/{id-1}/firewall/waf/packages"),
    FIREWALL_PACKAGE_INFO(HttpMethod.GET, "zones/{id-1}/firewall/waf/packages/{id-2}"),
    CHANGE_ANOMALY_DETECTION_WEB_APP_FIREWALL_PACKAGE_SETTINGS(HttpMethod.PATCH, "zones/{id-1}/firewall/waf/packages/{id-2}"),
    LIST_RULE_GROUPS(HttpMethod.GET, "zones/{id-1}/firewall/waf/packages/{id-2}/groups"),
    RULE_GROUP_INFO(HttpMethod.GET, "zones/{id-1}/firewall/waf/packages/{id-2}/groups/{id-3}"),
    UPDATE_RULE_GROUP(HttpMethod.PATCH, "zones/{id-1}/firewall/waf/packages/{id-2}/groups/{id-3}"),
    LIST_RULES(HttpMethod.GET, "zones/{id-1}/firewall/waf/packages/{id-2}/rules"),
    RULE_INFO(HttpMethod.GET, "zones/{id-1}/firewall/waf/packages/{id-2}/rules/{id-3}"),
    UPDATE_RULE(HttpMethod.PATCH, "zones/{id-1}/firewall/waf/packages/{id-2}/rules/{id-3}"),
    LIST_USERAGENT_RULES(HttpMethod.GET, "zones/{id-1}/firewall/ua_rules"),
    CREATE_USERAGENT_RULE(HttpMethod.POST, "zones/{id-1}/firewall/ua_rules"),
    USERAGENT_RULE_DETAILS(HttpMethod.GET, "zones/{id-1}/firewall/ua_rules/{id-2}"),
    DELETE_USERAGENT_RULE(HttpMethod.DELETE, "zones/{id-1}/firewall/ua_rules/{id-2}"),
    LIST_LOCKDOWN_RULES(HttpMethod.GET, "zones/{id-1}/firewall/lockdowns"),
    CREATE_LOCKDOWN_RULE(HttpMethod.POST, "zones/{id-1}/firewall/lockdowns"),
    LOCKDOWN_RULE_DETAILS(HttpMethod.GET, "zones/{id-1}/firewall/lockdowns/{id-2}"),
    UPDATE_LOCKDOWN_RULE(HttpMethod.PUT, "zones/{id-1}/firewall/lockdowns/{id-2}"),
    DELETE_LOCKDOWN_RULE(HttpMethod.DELETE, "zones/{id-1}/firewall/lockdowns/{id-2}"),
    ANALYZE_CERTIFICATE(HttpMethod.POST, "zones/{id-1}/ssl/analyze"),
    LIST_CERTIFICATE_PACKS(HttpMethod.GET, "zones/{id-1}/ssl/certificate_packs"),
    ORDER_CERTIFICATE_PACK(HttpMethod.PUT, "zones/{id-1}/ssl/certificate_packs"),
    EDIT_CERTIFICATE_PACK(HttpMethod.PATCH, "zones/{id-1}/ssl/certificate_packs/{id-2}"),
    SSL_VERIFICATION(HttpMethod.GET, "zones/{id-1}/ssl/verification"),
    UNIVERSAL_SSL_SETTINGS(HttpMethod.GET, "zones/{id-1}/ssl/universal/settings"),
    CHANGE_UNIVERSAL_SSL_SETTINGS(HttpMethod.GET, "zones/{id-1}/ssl/universal/settings"),
    ZONE_SUBSCRIPTION(HttpMethod.GET, "zones/{id-1}/subscription"),
    CREATE_ZONE_SUBSCRIPTION(HttpMethod.POST, "zones/{id-1}/subscription"),
    UPDATE_ZONE_SUBSCRIPTION(HttpMethod.PUT, "zones/{id-1}/subscription"),
    ORGANIZATION_DETAILS(HttpMethod.GET, "organizations/{id-1}"),
    UPDATE_ORGANIZATION(HttpMethod.PATCH, "organizations/{id-1}"),
    LIST_ORGANIZATION_MEMBERS(HttpMethod.GET, "organizations/{id-1}/members"),
    ORGANIZATION_MEMBER_DETAILS(HttpMethod.GET, "organizations/{id-1}/members/{id-2}"),
    UPDATE_ORGANIZATION_MEMBER_RULES(HttpMethod.PATCH, "organizations/{id-1}/members/{id-2}"),
    REMOVE_ORGANIZATION_MEMBER(HttpMethod.PATCH, "organizations/{id-1}/members/{id-2}"),
    CREATE_INVITATION(HttpMethod.POST, "organizations/{id-1}/invites"),
    LIST_INVITATIONS(HttpMethod.GET, "organizations/{id-1}/invites"),
    INVITATION_DETAILS(HttpMethod.GET, "organizations/{id-1}/invites/{id-2}"),
    UPDATE_INVITATION_ROLES(HttpMethod.PATCH, "organizations/{id-1}/invites/{id-2}"),
    CANCELINVITATION(HttpMethod.DELETE, "organizations/{id-1}/invites/{id-2}"),
    LIST_ORGANIZATION_ROLES(HttpMethod.GET, "organizations/{id-1}/roles"),
    ORGANIZATION_ROLE_DETAILS(HttpMethod.GET, "organizations/{id-1}/roles/{id-2}"),
    LIST_ORGANIZATION_ACCESS_RULES(HttpMethod.GET, "organizations/{id-1}/firewall/access_rules/rules"),
    CREATE_ORGANIZATION_ACCESS_RULE(HttpMethod.POST, "organizations/{id-1}/firewall/access_rules/rules"),
    UPDATE_ORGANIZATION_ACCESS_RULE(HttpMethod.PATCH, "organizations/{id-1}/firewall/access_rules/rules/{id-2}"),
    DELETE_ORGANIZATION_ACCESS_RULE(HttpMethod.DELETE, "organizations/{id-1}/firewall/access_rules/rules/{id-2}"),
    CREATE_ORGANIZATION_RAILGUN(HttpMethod.POST, "organizations/{id-1}/railguns"),
    LIST_ORGANIZATION_RAILGUNS(HttpMethod.GET, "organizations/{id-1}/railguns"),
    ORGANIZATION_RAILGUN_DETAILS(HttpMethod.GET, "organizations/{id-1}/railguns/{id-2}"),
    ORGANIZATION_ZONES_CONNECTED_TO_RAILGUNS(HttpMethod.GET, "organizations/{id-1}/railguns/{id-2}/zones"),
    ENABLE_ORGANIZATION_RAILGUN(HttpMethod.PATCH, "organizations/{id-1}/railguns/{id-2}"),
    DELETE_ORGANIZATION_RAILGUN(HttpMethod.DELETE, "organizations/{id-1}/railguns/{id-2}"),
    LIST_CERTIFICATES(HttpMethod.GET, "certificates"),
    CREATE_CERTIFICATE(HttpMethod.POST, "certificates"),
    CERTIFICATE_DETAILS(HttpMethod.GET, "certificates/{id-1}"),
    REVOKE_CERTIFICATE(HttpMethod.DELETE, "certificates/{id-1}"),
    LIST_VIRTUAL_USER_DNS_CLUSTER(HttpMethod.GET, "user/virtual_dns"),
    CREATE_VIRTUAL_USER_DNS_CLUSTER(HttpMethod.POST, "user/virtual_dns"),
    VIRTUAL_USER_DNS_CLUSTER_DETAILS(HttpMethod.GET, "user/virtual_dns/{id-1}"),
    DELETE_VIRTUAL_USER_DNS_CLUSTER(HttpMethod.DELETE, "user/virtual_dns/{id-1}"),
    MODIFY_VIRTUAL_USER_DNS_CLIUSTER(HttpMethod.PATCH, "user/virtual_dns/{id-1}"),
    LIST_VIRTUAL_ORGANIZATION_DNS_CLUSTER(HttpMethod.GET, "organizations/{id-1}/virtual_dns"),
    CREATE_VIRTUAL_ORGANIZATION_DNS_CLUSTER(HttpMethod.POST, "organizations/{id-1}/virtual_dns/{id-2}"),
    VIRTUAL_ORGANIZATION_DNS_CLUSTER_DETAILS(HttpMethod.GET, "organizations/{id-1}/virtual_dns/{id-2}"),
    DELETE_VIRTUAL_ORGANIZATION_DNS_CLUSTER(HttpMethod.DELETE, "organizations/{id-1}/virtual_dns/{id-2}"),
    MODIFY_VIRTUAL_ORGANIZATION_DNS_CLIUSTER(HttpMethod.PATCH, "organizations/{id-1}/virtual_dns/{id-2}"),
    VIRTUAL_USER_DNS_ANALYTICS_TABLE(HttpMethod.GET, "user/virtual_dns/{id-1}/dns_analytics/report"),
    VIRTUAL_USER_DNS_ANALYTICS_TABLE_BY_TIME(HttpMethod.GET, "user/virtual_dns/{id-1}/dns_analytics/report/bytime"),
    VIRTUAL_ORGANIZATION_DNS_ANALYTICS_TABLE(HttpMethod.GET, "organizations/virtual_dns/{id-1}/dns_analytics/report"),
    VIRTUAL_ORGANIZATION_DNS_ANALYTICS_TABLE_BY_TIME(HttpMethod.GET, "organizations/virtual_dns/{id-1}/dns_analytics/report/bytime"),
    CLOUDFLARE_IPS(HttpMethod.GET, "ips"),
    AML_SETTINGS(HttpMethod.GET, "zones/{id-1}/amp/viewer"),
    UPDATE_AML_SETTINGS(HttpMethod.PUT, "zones/{id-1}/amp/viewer"),
    LIST_USER_MONITORS(HttpMethod.GET, "user/load_balancers/monitors"),
    CREATE_USER_MONITOR(HttpMethod.POST, "user/load_balancers/monitors"),
    MONITOR_USER_DETAILS(HttpMethod.POST, "user/load_balancers/monitors/{id-1}"),
    DELETE_USER_MONITOR(HttpMethod.DELETE, "user/load_balancers/monitors/{id-1}"),
    MODIFY_USER_MONITOR(HttpMethod.PUT, "user/load_balancers/monitors/{id-1}"),
    LIST_USER_POOLS(HttpMethod.GET, "user/load_balancers/pools"),
    CREATE_USER_POOL(HttpMethod.POST, "user/load_balancers/pools"),
    POOL_USER_DETAILS(HttpMethod.GET, "user/load_balancers/pools/{id-1}"),
    DELETE_USER_POOL(HttpMethod.DELETE, "user/load_balancers/pools/{id-1}"),
    MODIFY_USER_POOL(HttpMethod.PUT, "user/load_balancers/pools/{id-1}"),
    LIST_ORGANIZATION_MONITORS(HttpMethod.GET, "organizations/{id-1}/load_balancers/monitors"),
    CREATE_ORGANIZATION_MONITOR(HttpMethod.POST, "organizations/{id-1}/load_balancers/monitors"),
    MONITOR_ORGANIZATION_DETAILS(HttpMethod.POST, "organizations/{id-1}/load_balancers/monitors/{id-2}"),
    DELETE_ORGANIZATION_MONITOR(HttpMethod.DELETE, "organizations/{id-1}/load_balancers/monitors/{id-2}"),
    MODIFY_ORGANIZATION_MONITOR(HttpMethod.PUT, "organizations/{id-1}/load_balancers/monitors/{id-2}"),
    LIST_ORGANIZATION_POOLS(HttpMethod.GET, "organizations/{id-1}/load_balancers/pools"),
    CREATE_ORGANIZATION_POOL(HttpMethod.POST, "organizations/{id-1}/load_balancers/pools"),
    POOL_ORGANIZATION_DETAILS(HttpMethod.GET, "organizations/{id-1}/load_balancers/pools/{id-2}"),
    DELETE_ORGANIZATION_POOL(HttpMethod.DELETE, "organizations/{id-1}/load_balancers/pools/{id-2}"),
    MODIFY_ORGANIZATION_POOL(HttpMethod.PUT, "organizations/{id-1}/load_balancers/pools/{id-2}"),
    LIST_ZONE_LOAD_BALANCERS(HttpMethod.GET, "zones/{id-1}/load_balancers"),
    CREATE_ZONE_LOAD_BALANCER(HttpMethod.POST, "zones/{id-1}/load_balancers"),
    ZONE_LOAD_BALANSER_DETAILS(HttpMethod.GET, "zones/{id-1}/load_balancers/{id-2}"),
    DELETE_ZONE_LOAD_BALANCER(HttpMethod.DELETE, "zones/{id-1}/load_balancers/{id-2}"),
    MODIFY_ZONE_LOAD_BALANCER(HttpMethod.PUT, "zones/{id-1}/load_balancers/{id-2}"),
    LIST_USER_AUDIT_LOGS(HttpMethod.GET, "user/audit_logs"),
    LIST_ORGANIZATION_AUDIT_LOGS(HttpMethod.GET, "organizations/audit_logs"),
    CREATE_SPECTRUM_APPLICATION(HttpMethod.POST, "zones/{id-1}/spectrum/apps"),
    LIST_SPECTRUM_APPLICATIONS(HttpMethod.GET, "zones/{id-1}/spectrum/apps"),
    SPECTRUM_APPLICATION_DETAILS(HttpMethod.GET, "zones/{id-1}/spectrum/apps/{id-2}"),
    UPDATE_SPECTRUM_APPLICATION(HttpMethod.PUT, "zones/{id-1}/spectrum/apps/{id-2}"),
    DELETE_SPECTRUM_APPLICATION(HttpMethod.DELETE, "zones/{id-1}/spectrum/apps/{id-2}"),
    UPLOAD_WORKER_SCRIPT(HttpMethod.PUT, "accounts/{id-1}/workers/scripts/{id-2}"),
    LIST_WORKER_SCRIPTS(HttpMethod.GET, "accounts/{id-1}/workers/scripts"),
    DOWNLOAD_WORKER_SCRIPT(HttpMethod.GET, "accounts/{id-1}/workers/scripts/{id-2}"),
    DELETE_WORKER_SCRIPT(HttpMethod.DELETE, "accounts/{id-1}/workers/scripts/{id-2}"),
    CREATE_WORKER_ROUTE(HttpMethod.POST, "zones/{id-1}/workers/routes"),
    LIST_WORKER_ROUTES(HttpMethod.GET, "zones/{id-1}/workers/routes"),
    GET_WORKER_ROUTE(HttpMethod.GET, "zones/{id-1}/workers/routes/{id-2}"),
    UPDATE_WORKER_ROUTE(HttpMethod.PUT, "zones/{id-1}/workers/routes/{id-2}"),
    DELETE_WORKER_ROUTE(HttpMethod.DELETE, "zones/{id-1}/workers/routes/{id-2}");

    private HttpMethod httpMethod;
    private String additionalPath;

    private Category(HttpMethod httpMethod, String additionalPath) {
        this.httpMethod = httpMethod;
        this.additionalPath = additionalPath;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getAdditionalPath() {
        return this.additionalPath;
    }

    public String getPath() {
        return "https://api.cloudflare.com/client/v4/" + this.additionalPath;
    }
}

