/*
 * Decompiled with CFR 0.152.
 */
package eu.roboflax.cloudflare;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.roboflax.cloudflare.CloudflareAccess;
import eu.roboflax.cloudflare.objects.ResultInfo;
import java.util.List;
import java.util.Map;

public class CloudflareResponse<T> {
    private final JsonObject json;
    private final T object;
    private final boolean successful;
    private final int statusCode;
    private final String statusMessage;
    private final List<String> messages = Lists.newArrayList();
    private final Map<Integer, String> errors;
    private final ResultInfo resultInfo;

    CloudflareResponse(JsonObject json, T object, boolean successful, int statusCode, String statusMessage) {
        this.json = json;
        this.successful = successful;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.errors = Maps.newHashMap();
        if (this.getJson().has("errors")) {
            for (JsonElement e : this.getJson().getAsJsonArray("errors")) {
                JsonObject o = e.getAsJsonObject();
                this.errors.put(o.get("code").getAsInt(), o.get("message").getAsString());
            }
        }
        this.resultInfo = this.getJson().has("result_info") ? (ResultInfo)CloudflareAccess.getGson().fromJson((JsonElement)this.getJson().getAsJsonObject("result_info"), ResultInfo.class) : null;
        this.object = object;
    }

    public JsonObject getJson() {
        return this.json;
    }

    public T getObject() {
        return this.object;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public Map<Integer, String> getErrors() {
        return this.errors;
    }

    public ResultInfo getResultInfo() {
        return this.resultInfo;
    }
}

