/*
 * Decompiled with CFR 0.152.
 */
package eu.roboflax.cloudflare;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.roboflax.cloudflare.json.ZoneSettingDeserializer;
import eu.roboflax.cloudflare.objects.zone.ZoneSetting;
import io.joshworks.restclient.http.RestClient;
import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;

public class CloudflareAccess
implements Closeable {
    private String xAuthKey = null;
    private String xAuthEmail = null;
    private String xAuthToken = null;
    private final RestClient restClient;
    private ExecutorService threadPool;
    public static final String API_BASE_URL = "https://api.cloudflare.com/client/v4/";
    public static final int DEFAULT_MAX_THREADS = 100;
    public static final ExecutorService DEFAULT_THREAD_POOL = CloudflareAccess.newDefaultThreadPool(100);
    private static Gson gson = new GsonBuilder().registerTypeAdapter(ZoneSetting.class, (Object)new ZoneSettingDeserializer()).create();

    private static ExecutorService newDefaultThreadPool(int maxThreads) {
        return Executors.newFixedThreadPool(maxThreads);
    }

    public CloudflareAccess(@NonNull String xAuthKey, @NonNull String xAuthEmail, @Nullable ExecutorService threadPool) {
        this(xAuthKey, xAuthEmail, threadPool, API_BASE_URL);
        if (xAuthKey == null) {
            throw new NullPointerException("xAuthKey");
        }
        if (xAuthEmail == null) {
            throw new NullPointerException("xAuthEmail");
        }
    }

    public CloudflareAccess(@NonNull String xAuthKey, @NonNull String xAuthEmail, @Nullable ExecutorService threadPool, String apiBaseUrl) {
        if (xAuthKey == null) {
            throw new NullPointerException("xAuthKey");
        }
        if (xAuthEmail == null) {
            throw new NullPointerException("xAuthEmail");
        }
        this.xAuthKey = xAuthKey;
        this.xAuthEmail = xAuthEmail;
        this.threadPool = threadPool;
        this.restClient = RestClient.builder().baseUrl(apiBaseUrl).defaultHeader("Content-Type", "application/json").defaultHeader("X-Auth-Key", this.getXAuthKey()).defaultHeader("X-Auth-Email", this.getXAuthEmail()).followRedirect(false).cookieSpec("ignoreCookies").build();
    }

    public CloudflareAccess(String xAuthKey, String xAuthEmail, int maxThreads) {
        this(xAuthKey, xAuthEmail, CloudflareAccess.newDefaultThreadPool(maxThreads));
    }

    public CloudflareAccess(String xAuthKey, String xAuthEmail) {
        this(xAuthKey, xAuthEmail, null);
    }

    public CloudflareAccess(String xAuthToken, @Nullable ExecutorService threadPool) {
        this(xAuthToken, threadPool, API_BASE_URL);
    }

    public CloudflareAccess(@NonNull String xAuthToken, @Nullable ExecutorService threadPool, String apiBaseUrl) {
        if (xAuthToken == null) {
            throw new NullPointerException("xAuthToken");
        }
        this.xAuthToken = xAuthToken;
        this.threadPool = threadPool;
        this.restClient = RestClient.builder().baseUrl(apiBaseUrl).defaultHeader("Content-Type", "application/json").defaultHeader("Authorization", "Bearer " + this.getXAuthToken()).followRedirect(false).cookieSpec("ignoreCookies").build();
    }

    public CloudflareAccess(String xAuthToken, int maxThreads) {
        this(xAuthToken, CloudflareAccess.newDefaultThreadPool(maxThreads));
    }

    public CloudflareAccess(String xAuthToken) {
        this(xAuthToken, (ExecutorService)null);
    }

    public static void setGson(Gson gson) {
        CloudflareAccess.gson = (Gson)Preconditions.checkNotNull((Object)gson);
    }

    public boolean isThreadPoolInitialized() {
        return this.threadPool != null;
    }

    public ExecutorService getThreadPool() {
        if (!this.isThreadPoolInitialized()) {
            this.threadPool = DEFAULT_THREAD_POOL;
        }
        return this.threadPool;
    }

    public void close(long timeout, TimeUnit unit) {
        this.getRestClient().close();
        if (this.threadPool != null) {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)timeout, (TimeUnit)((TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit)))));
        }
    }

    @Override
    public void close() {
        this.close(4L, TimeUnit.SECONDS);
    }

    public String getXAuthKey() {
        return this.xAuthKey;
    }

    public String getXAuthEmail() {
        return this.xAuthEmail;
    }

    public String getXAuthToken() {
        return this.xAuthToken;
    }

    protected RestClient getRestClient() {
        return this.restClient;
    }

    public static Gson getGson() {
        return gson;
    }
}

