/*
 * Copyright (c) RoboFlax. All rights reserved.
 * Use is subject to license terms.
 */
package eu.roboflax.cloudflare.objects.zone;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import eu.roboflax.cloudflare.objects.Identifiable;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.List;

/**
 * @see <a href="https://api.cloudflare.com/#zone-properties">https://api.cloudflare.com</a>
 */
@Getter
@Setter
public class RatePlan implements Identifiable {
    
    @SerializedName("id")
    @Expose
    private String id;
    @SerializedName("name")
    @Expose
    private String name;
    @SerializedName("currency")
    @Expose
    private String currency;
    @SerializedName("duration")
    @Expose
    private Integer duration;
    @SerializedName("Frequency")
    @Expose
    private String frequency;
    @SerializedName("components")
    @Expose
    private List<Component> components = null;
    
    @Override
    public String toString( ) {
        return new ToStringBuilder( this ).append( "id", id ).append( "name", name ).append( "currency", currency ).append( "duration", duration ).append( "Frequency", frequency ).append( "components", components ).toString();
    }
    
}
