/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.functions;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.idlab.knows.functions.agent.Arguments;
import be.ugent.rml.functions.MultipleRecordsFunctionExecutor;
import be.ugent.rml.functions.ParameterValueOriginPair;
import be.ugent.rml.functions.TermGeneratorOriginPair;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMultipleRecordsFunctionExecutor
implements MultipleRecordsFunctionExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMultipleRecordsFunctionExecutor.class);
    private final List<ParameterValueOriginPair> parameterValuePairs;
    private final Agent functionAgent;
    private boolean needsEOFMarker = false;

    public DynamicMultipleRecordsFunctionExecutor(List<ParameterValueOriginPair> parameterValuePairs, Agent functionAgent) {
        this.parameterValuePairs = parameterValuePairs;
        this.functionAgent = functionAgent;
        for (ParameterValueOriginPair parameterValuePair : parameterValuePairs) {
            for (TermGeneratorOriginPair valueGeneratorPair : parameterValuePair.getValueGeneratorPairs()) {
                if (!valueGeneratorPair.getTermGenerator().needsEOFMarker()) continue;
                this.needsEOFMarker = true;
                return;
            }
        }
    }

    @Override
    public Object execute(Map<String, Record> records) throws Exception {
        ArrayList fnTerms = new ArrayList();
        Arguments arguments = new Arguments();
        Record child = records.get("child");
        this.parameterValuePairs.forEach(pv -> {
            ArrayList parameters = new ArrayList();
            ArrayList values = new ArrayList();
            pv.getParameterGenerators().forEach(parameterGen -> {
                try {
                    parameters.addAll(parameterGen.generate(child));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            pv.getValueGeneratorPairs().forEach(pair -> {
                try {
                    values.addAll(pair.getTermGenerator().generate((Record)records.get(pair.getOrigin())));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            if (parameters.contains(new NamedNode("http://w3id.org/function/ontology#executes")) || parameters.contains(new NamedNode("https://w3id.org/function/ontology#executes"))) {
                if (parameters.contains(new NamedNode("http://w3id.org/function/ontology#executes"))) {
                    logger.warn("http is used instead of https for {}. Still works for now, but will be deprecated in the future.", (Object)"https://w3id.org/function/ontology#");
                }
                fnTerms.add((Term)values.get(0));
            } else {
                for (Term parameter : parameters) {
                    for (Term value : values) {
                        arguments.add(parameter.getValue(), (Object)value.getValue());
                    }
                }
            }
        });
        if (fnTerms.isEmpty()) {
            throw new Exception("No function was defined for parameters: " + arguments.getArgumentNames());
        }
        String functionId = ((Term)fnTerms.get(0)).getValue();
        try {
            return this.functionAgent.execute(functionId, arguments);
        }
        catch (InvocationTargetException e) {
            logger.error("Function '{}' failed to execute with {}", (Object)functionId, (Object)e.getTargetException().getMessage());
            return null;
        }
    }

    @Override
    public boolean needsEOFMarker() {
        return this.needsEOFMarker;
    }
}

