/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.conformer;

import be.ugent.idlab.knows.dataio.access.DatabaseType;
import be.ugent.rml.conformer.Converter;
import be.ugent.rml.records.ReferenceFormulation;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.BlankNode;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMLConverterNew
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(RMLConverterNew.class);
    private final Map<String, ReplacementEntry> replacementsObjects = new HashMap<String, ReplacementEntry>(){
        {
            this.put("http://semweb.mmlab.be/ns/rml#BaseSource", new ReplacementEntry("http://w3id.org/rml/LogicalSource", null));
            this.put("http://www.w3.org/ns/r2rml#BaseTableOrView", new ReplacementEntry("http://w3id.org/rml/LogicalSource", null));
            this.put("http://www.w3.org/ns/r2rml#Literal", new ReplacementEntry("http://w3id.org/rml/Literal", null));
            this.put("http://www.w3.org/ns/r2rml#R2RMLView", new ReplacementEntry("http://w3id.org/rml/LogicalSource", null));
            this.put("http://www.w3.org/ns/r2rml#SQL2008", new ReplacementEntry("http://w3id.org/rml/SQL2008", null));
        }
    };
    private final Map<String, ReplacementEntry> replacementsPredicates = new HashMap<String, ReplacementEntry>(){
        {
            this.put("http://semweb.mmlab.be/ns/rml#source", new ReplacementEntry("http://w3id.org/rml/source", (quad, quadStore) -> RMLConverterNew.this.processSources(quad, quadStore)));
            this.put("http://semweb.mmlab.be/ns/rml#query", new ReplacementEntry("http://w3id.org/rml/query", (quad, quadStore) -> RMLConverterNew.this.processQueries(quad, quadStore)));
            this.put("http://www.w3.org/ns/r2rml#column", new ReplacementEntry("http://w3id.org/rml/reference", null));
            this.put("http://www.w3.org/ns/r2rml#SQL2008", new ReplacementEntry("http://w3id.org/rml/SQL2008", null));
            this.put("http://www.w3.org/ns/r2rml#logicalTable", new ReplacementEntry("http://w3id.org/rml/logicalSource", (quad, quadStore) -> RMLConverterNew.this.processLogicalTable(quad, quadStore)));
            this.put("http://www.w3.org/ns/r2rml#sqlVersion", new ReplacementEntry("http://w3id.org/rml/referenceFormulation", null));
            this.put("http://www.w3.org/ns/r2rml#tableName", new ReplacementEntry("http://w3id.org/rml/source", RMLConverterNew::processTableName));
            this.put("http://www.w3.org/ns/r2rml#Literal", new ReplacementEntry("http://w3id.org/rml/Literal", RMLConverterNew::processTableName));
        }
    };
    private final Map<String, String> objectRenames = new HashMap<String, String>(){
        {
            this.put("http://semweb.mmlab.be/ns/ql#CSV", ReferenceFormulation.CSV);
            this.put("http://semweb.mmlab.be/ns/ql#JSONPath", ReferenceFormulation.JSONPath);
            this.put("http://semweb.mmlab.be/ns/ql#XPath", ReferenceFormulation.XPath);
            this.put("http://semweb.mmlab.be/ns/rml#LogicalSource", "http://w3id.org/rml/LogicalSource");
            this.put("http://www.w3.org/ns/r2rml#Literal", "http://w3id.org/rml/Literal");
            this.put("http://semweb.mmlab.be/ns/rml#TriplesMap", "http://w3id.org/rml/TriplesMap");
            this.put("http://www.w3.org/ns/r2rml#BlankNode", "http://w3id.org/rml/BlankNode");
            this.put("http://www.w3.org/ns/r2rml#IRI", "http://w3id.org/rml/IRI");
            this.put("http://www.w3.org/ns/r2rml#Join", "http://w3id.org/rml/Join");
            this.put("http://www.w3.org/ns/r2rml#PredicateMap", "http://w3id.org/rml/PredicateMap");
            this.put("http://www.w3.org/ns/r2rml#PredicateObjectMap", "http://w3id.org/rml/PredicateObjectMap");
            this.put("http://www.w3.org/ns/r2rml#RefObjectMap", "http://w3id.org/rml/RefObjectMap");
            this.put("http://www.w3.org/ns/r2rml#SubjectMap", "http://w3id.org/rml/SubjectMap");
            this.put("http://www.w3.org/ns/r2rml#ObjectMap", "http://w3id.org/rml/ObjectMap");
            this.put("http://www.w3.org/ns/r2rml#TermMap", "http://w3id.org/rml/TermMap");
            this.put("http://www.w3.org/ns/r2rml#TriplesMap", "http://w3id.org/rml/TriplesMap");
            this.put("http://www.w3.org/ns/r2rml#GraphMap", "http://w3id.org/rml/GraphMap");
            this.put("http://www.w3.org/ns/r2rml#defaultGraph", "http://w3id.org/rml/defaultGraph");
            this.put("http://semweb.mmlab.be/ns/rml#LanguageMap", "http://w3id.org/rml/LanguageMap");
            this.put("http://semweb.mmlab.be/ns/rml-target#LogicalTarget", "http://w3id.org/rml/LogicalTarget");
            this.put("http://semweb.mmlab.be/ns/rml-target#Target", "http://w3id.org/rml/Target");
        }
    };
    private final Map<String, String> predicateRenames = new HashMap<String, String>(){
        {
            this.put("http://semweb.mmlab.be/ns/rml#iterator", "http://w3id.org/rml/iterator");
            this.put("http://semweb.mmlab.be/ns/rml#logicalSource", "http://w3id.org/rml/logicalSource");
            this.put("http://semweb.mmlab.be/ns/rml#logicalTarget", "http://w3id.org/rml/logicalTarget");
            this.put("http://semweb.mmlab.be/ns/rml#reference", "http://w3id.org/rml/reference");
            this.put("http://semweb.mmlab.be/ns/rml#referenceFormulation", "http://w3id.org/rml/referenceFormulation");
            this.put("http://semweb.mmlab.be/ns/rml#languageMap", "http://w3id.org/rml/languageMap");
            this.put("http://semweb.mmlab.be/ns/rml#parentTermMap", "http://w3id.org/rml/parentTermMap");
            this.put("http://semweb.mmlab.be/ns/rml-target#target", "http://w3id.org/rml/target");
            this.put("http://semweb.mmlab.be/ns/rml-target#serialization", "http://w3id.org/rml/serialization");
            this.put("http://semweb.mmlab.be/ns/rml-target#compression", "http://w3id.org/rml/compression");
            this.put("http://www.w3.org/ns/r2rml#joinCondition", "http://w3id.org/rml/joinCondition");
            this.put("http://www.w3.org/ns/r2rml#parent", "http://w3id.org/rml/parent");
            this.put("http://www.w3.org/ns/r2rml#child", "http://w3id.org/rml/child");
            this.put("http://www.w3.org/ns/r2rml#parentTriplesMap", "http://w3id.org/rml/parentTriplesMap");
            this.put("http://www.w3.org/ns/r2rml#column", "http://w3id.org/rml/reference");
            this.put("http://www.w3.org/ns/r2rml#class", "http://w3id.org/rml/class");
            this.put("http://www.w3.org/ns/r2rml#constant", "http://w3id.org/rml/constant");
            this.put("http://www.w3.org/ns/r2rml#datatype", "http://w3id.org/rml/datatype");
            this.put("http://www.w3.org/ns/r2rml#graph", "http://w3id.org/rml/graph");
            this.put("http://www.w3.org/ns/r2rml#graphMap", "http://w3id.org/rml/graphMap");
            this.put("http://www.w3.org/ns/r2rml#language", "http://w3id.org/rml/language");
            this.put("http://www.w3.org/ns/r2rml#object", "http://w3id.org/rml/object");
            this.put("http://www.w3.org/ns/r2rml#objectMap", "http://w3id.org/rml/objectMap");
            this.put("http://www.w3.org/ns/r2rml#predicate", "http://w3id.org/rml/predicate");
            this.put("http://www.w3.org/ns/r2rml#predicateMap", "http://w3id.org/rml/predicateMap");
            this.put("http://www.w3.org/ns/r2rml#predicateObjectMap", "http://w3id.org/rml/predicateObjectMap");
            this.put("http://www.w3.org/ns/r2rml#subject", "http://w3id.org/rml/subject");
            this.put("http://www.w3.org/ns/r2rml#subjectMap", "http://w3id.org/rml/subjectMap");
            this.put("http://www.w3.org/ns/r2rml#termType", "http://w3id.org/rml/termType");
            this.put("http://www.w3.org/ns/r2rml#template", "http://w3id.org/rml/template");
            this.put("http://www.w3.org/ns/r2rml#logicalTable", "http://w3id.org/rml/logicalSource");
        }
    };
    private final Set<String> obsoletes = new HashSet<String>(){
        {
            this.add("http://www.w3.org/ns/r2rml#sqlVersion");
        }
    };
    private final QuadStore store;

    public RMLConverterNew(QuadStore store) {
        this.store = store;
    }

    private static void processTableName(Quad tableName, QuadStore store) {
        store.addQuad(tableName.getSubject(), new NamedNode("http://w3id.org/rml/referenceFormulation"), new NamedNode("http://w3id.org/rml/SQL2008Table"));
        store.removeQuads(tableName.getSubject(), new NamedNode("http://w3id.org/rml/referenceFormulation"), null);
    }

    private void processLogicalTable(Quad logicalTableQuad, QuadStore quadStore) {
        BlankNode blank = new BlankNode();
        quadStore.addQuad(logicalTableQuad.getSubject(), new NamedNode("http://w3id.org/rml/logicalSource"), blank);
        quadStore.removeQuads(logicalTableQuad.getSubject(), new NamedNode("http://w3id.org/rml/referenceFormulation"), new NamedNode(ReferenceFormulation.RDBTable));
        Term logicalTable = logicalTableQuad.getObject();
        Term tableName = quadStore.getQuads(logicalTable, new NamedNode("http://www.w3.org/ns/r2rml#tableName"), null).get(0).getObject();
        quadStore.addQuad(blank, new NamedNode("http://w3id.org/rml/source"), tableName);
        quadStore.addQuad(blank, new NamedNode("http://w3id.org/rml/referenceFormulation"), new NamedNode(ReferenceFormulation.RDBTable));
        quadStore.removeQuads(logicalTableQuad);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void convert(Map<String, String> mappingOptions) throws Exception {
        if (mappingOptions != null) {
            List<Quad> logicalTableMaps = this.store.getQuads(null, new NamedNode("http://www.w3.org/ns/r2rml#logicalTable"), null);
            for (Quad quad : logicalTableMaps) {
                NamedNode namedNode = new NamedNode(quad.getSubject().getValue() + "_database");
                this.store.addQuad(namedNode, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#Database"));
                for (Map.Entry entry : mappingOptions.entrySet()) {
                    this.store.addQuad(namedNode, new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#" + (String)entry.getKey()), new Literal((String)entry.getValue()));
                    if (!((String)entry.getKey()).equals("jdbcDSN")) continue;
                    DatabaseType type = DatabaseType.getDBtype((String)((String)entry.getValue()));
                    this.store.addQuad(namedNode, new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#jdbcDriver"), new Literal(type.getDriver()));
                }
                NamedNode logicalSource = new NamedNode(quad.getSubject().getValue() + "_logicalSource");
                this.store.addQuad(logicalSource, new NamedNode("http://w3id.org/rml/source"), namedNode);
                Term term = quad.getObject();
                List<Quad> tableNames = this.store.getQuads(term, new NamedNode("http://www.w3.org/ns/r2rml#tableName"), null);
                if (tableNames.isEmpty()) {
                    List<Quad> queries = this.store.getQuads(term, new NamedNode("http://www.w3.org/ns/r2rml#sqlQuery"), null);
                    if (queries.isEmpty()) {
                        throw new IllegalArgumentException("Logical table contains neither a tableName, nor a SQL query");
                    }
                    this.store.addQuad(logicalSource, new NamedNode("http://w3id.org/rml/referenceFormulation"), new NamedNode(ReferenceFormulation.RDBQuery));
                    this.store.addQuad(logicalSource, new NamedNode("http://w3id.org/rml/iterator"), new Literal(queries.get(0).getObject().getValue()));
                    this.store.removeQuads(term, new NamedNode("http://www.w3.org/ns/r2rml#sqlQuery"), null);
                } else {
                    this.store.addQuad(logicalSource, new NamedNode("http://w3id.org/rml/referenceFormulation"), new NamedNode(ReferenceFormulation.RDBTable));
                    this.store.addQuad(logicalSource, new NamedNode("http://w3id.org/rml/iterator"), new Literal(tableNames.get(0).getObject().getValue()));
                    this.store.removeQuads(term, new NamedNode("http://www.w3.org/ns/r2rml#tableName"), null);
                }
                this.store.addQuad(quad.getSubject(), new NamedNode("http://w3id.org/rml/logicalSource"), logicalSource);
                this.store.removeQuads(quad.getSubject(), new NamedNode("http://www.w3.org/ns/r2rml#logicalTable"), null);
            }
            List<Quad> list = this.store.getQuads(null, new NamedNode("http://www.w3.org/ns/r2rml#tableName"), null);
            for (Quad quad : list) {
                this.store.addQuad(quad.getSubject(), new NamedNode("http://w3id.org/rml/referenceFormulation"), new NamedNode(ReferenceFormulation.RDBTable));
                String tableName = quad.getObject().getValue();
                this.store.addQuad(quad.getSubject(), new NamedNode("http://w3id.org/rml/iterator"), new Literal(tableName));
                this.store.removeQuads(quad.getSubject(), new NamedNode("http://www.w3.org/ns/r2rml#sqlVersion"), null);
                this.store.removeQuads(quad);
            }
            List<Quad> list2 = this.store.getQuads(null, new NamedNode("http://semweb.mmlab.be/ns/rml#query"), null);
            for (Quad ls : list2) {
                void var7_43;
                Object var7_41 = null;
                if (this.store.contains(ls.getSubject(), new NamedNode("http://semweb.mmlab.be/ns/rml#source"), null)) {
                    Term term = this.store.getQuad(ls.getSubject(), new NamedNode("http://semweb.mmlab.be/ns/rml#source"), null).getObject();
                }
                this.store.removeQuads(ls.getSubject(), new NamedNode("http://semweb.mmlab.be/ns/rml#referenceFormulation"), null);
                if (var7_43 != null && this.store.contains((Term)var7_43, new NamedNode("http://www.w3.org/ns/sparql-service-description#resultFormat"), null)) {
                    Term resultsFormat = this.store.getQuad((Term)var7_43, new NamedNode("http://www.w3.org/ns/sparql-service-description#resultFormat"), null).getObject();
                    this.store.addQuad(ls.getSubject(), new NamedNode("http://w3id.org/rml/referenceFormulation"), resultsFormat);
                } else {
                    this.store.addQuad(ls.getSubject(), new NamedNode("http://w3id.org/rml/referenceFormulation"), new NamedNode(ReferenceFormulation.RDBQuery));
                }
                this.store.addQuad(ls.getSubject(), new NamedNode("http://w3id.org/rml/iterator"), ls.getObject());
                this.store.removeQuads(ls.getSubject(), new NamedNode("http://www.w3.org/ns/r2rml#sqlVersion"), null);
                this.store.removeQuads(ls);
            }
        }
        for (Map.Entry<String, ReplacementEntry> entry : this.replacementsPredicates.entrySet()) {
            List<Quad> list = this.store.getQuads(null, new NamedNode(entry.getKey()), null);
            ReplacementEntry replacementEntry = entry.getValue();
            for (Quad quad : list) {
                if (replacementEntry.function != null) {
                    replacementEntry.function.call(quad, this.store);
                    continue;
                }
                this.store.renameAllPredicates(new NamedNode(entry.getKey()), new NamedNode(replacementEntry.replacementTerm));
                logger.warn("Predicate replacement function for term {} is not yet defined!", (Object)entry.getKey());
            }
        }
        for (Map.Entry<String, ReplacementEntry> entry : this.replacementsObjects.entrySet()) {
            List<Quad> list = this.store.getQuads(null, null, new NamedNode(entry.getKey()));
            ReplacementEntry replacementEntry = entry.getValue();
            for (Quad quad : list) {
                this.store.addQuad(quad.getSubject(), quad.getPredicate(), new NamedNode(replacementEntry.replacementTerm));
                if (replacementEntry.function != null) {
                    replacementEntry.function.call(quad, this.store);
                    continue;
                }
                logger.warn("Object replacement function for term {} is not yet defined!", (Object)entry.getKey());
            }
            this.store.removeQuads(list);
        }
        for (Map.Entry<String, Object> entry : this.predicateRenames.entrySet()) {
            String string = entry.getKey();
            String string2 = (String)entry.getValue();
            this.store.renameAllPredicates(new NamedNode(string), new NamedNode(string2));
        }
        for (Map.Entry<String, Object> entry : this.objectRenames.entrySet()) {
            String string = entry.getKey();
            String string3 = (String)entry.getValue();
            this.store.renameAllObjects(new NamedNode(string), new NamedNode(string3));
        }
        this.store.removeNameSpace("rml");
        this.store.removeNameSpace("rr");
        this.store.removeNameSpace("ql");
        this.store.addNameSpace("rml", "http://w3id.org/rml/");
        this.dropObsolete();
    }

    private void processSources(Quad source, QuadStore store) {
        if (source.getObject().isLiteral()) {
            String path = source.getObject().getValue();
            BlankNode node = new BlankNode();
            store.addQuad(node, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/ns/dcat#Distribution"));
            store.addQuad(node, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://w3id.org/rml/Source"));
            store.addQuad(node, new NamedNode("http://www.w3.org/ns/dcat#downloadURL"), new Literal(path));
            store.addQuad(source.getSubject(), new NamedNode("http://w3id.org/rml/source"), node);
            store.removeQuads(source.getSubject(), source.getPredicate(), source.getObject());
        }
        store.renameAllPredicates(new NamedNode("http://semweb.mmlab.be/ns/rml#source"), new NamedNode("http://w3id.org/rml/source"));
    }

    private void processQueries(Quad query, QuadStore store) throws Exception {
        Term source = store.getQuad(query.getSubject(), new NamedNode("http://w3id.org/rml/source"), null).getObject();
        if (store.contains(source, new NamedNode("http://www.w3.org/ns/sparql-service-description#resultFormat"), null)) {
            Term supportedLanguage = store.getQuad(source, new NamedNode("http://www.w3.org/ns/sparql-service-description#resultFormat"), null).getObject();
            store.addQuad(query.getSubject(), new NamedNode("http://w3id.org/rml/referenceFormulation"), supportedLanguage);
        } else {
            store.addQuad(query.getSubject(), new NamedNode("http://w3id.org/rml/referenceFormulation"), new NamedNode("http://w3id.org/rml/SQL2008Query"));
        }
        store.removeQuads(query.getSubject(), new NamedNode("http://semweb.mmlab.be/ns/rml#referenceFormulation"), null);
        store.removeQuads(query.getSubject(), new NamedNode("http://semweb.mmlab.be/ns/rml#iterator"), null);
        store.renameAllPredicates(new NamedNode("http://semweb.mmlab.be/ns/rml#query"), new NamedNode("http://w3id.org/rml/iterator"));
    }

    private void dropObsolete() {
        for (String obsolete : this.obsoletes) {
            this.store.removeQuads(null, new NamedNode(obsolete), null);
        }
    }

    private record ReplacementEntry(String replacementTerm, ReplaceFunction function) {
    }

    @FunctionalInterface
    private static interface ReplaceFunction {
        public void call(Quad var1, QuadStore var2) throws Exception;
    }
}

