/*
 * Decompiled with CFR 0.152.
 */
package com.github.rkumsher.enums;

import com.github.rkumsher.collection.IterableUtils;
import java.util.Collection;
import java.util.EnumSet;

public final class RandomEnumUtils {
    private RandomEnumUtils() {
    }

    public static <T extends Enum<T>> T random(Class<T> enumClass) {
        EnumSet<T> enums = EnumSet.allOf(enumClass);
        return (T)((Enum)IterableUtils.randomFrom(enums));
    }

    @SafeVarargs
    public static <T extends Enum<T>> T random(Class<T> enumClass, T ... excludes) {
        EnumSet<T> enums = EnumSet.allOf(enumClass);
        return (T)((Enum)IterableUtils.randomFrom(enums, excludes));
    }

    public static <T extends Enum<T>> T random(Class<T> enumClass, Collection<T> excludes) {
        EnumSet<T> enums = EnumSet.allOf(enumClass);
        return (T)((Enum)IterableUtils.randomFrom(enums, excludes));
    }
}

