/*
 * Decompiled with CFR 0.152.
 */
package com.github.rkumsher.date;

import com.github.rkumsher.collection.IterableUtils;
import com.github.rkumsher.date.DateUtils;
import com.github.rkumsher.enums.RandomEnumUtils;
import com.github.rkumsher.number.RandomNumberUtils;
import com.google.common.base.Preconditions;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.util.Date;
import org.apache.commons.lang3.RandomUtils;

public final class RandomDateUtils {
    private static final ZoneId UTC = ZoneId.of("UTC").normalized();
    private static final ZoneOffset UTC_OFFSET = ZoneOffset.UTC;
    private static final int LEAP_YEAR = 2004;
    private static final int MAX_ZONE_OFFSET_SECONDS = 64800;
    private static final int MIN_YEAR = 1970;
    private static final int MAX_YEAR = 9999;
    static final Instant MIN_INSTANT = Instant.ofEpochMilli(0L);
    static final Instant MAX_INSTANT = Instant.ofEpochMilli(LocalDate.of(9999, 12, 31).atStartOfDay(UTC).toInstant().toEpochMilli());

    private RandomDateUtils() {
    }

    public static ZonedDateTime randomZonedDateTime() {
        return ZonedDateTime.ofInstant(RandomDateUtils.randomInstant(), UTC);
    }

    public static ZonedDateTime randomZonedDateTime(ZonedDateTime startInclusive, ZonedDateTime endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        Instant instant = RandomDateUtils.randomInstant(startInclusive.toInstant(), endExclusive.toInstant());
        return ZonedDateTime.ofInstant(instant, UTC);
    }

    public static ZonedDateTime randomFutureZonedDateTime() {
        return RandomDateUtils.randomZonedDateTimeAfter(ZonedDateTime.now());
    }

    public static ZonedDateTime randomZonedDateTimeAfter(ZonedDateTime after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        Instant instant = RandomDateUtils.randomInstantAfter(after.toInstant());
        return ZonedDateTime.ofInstant(instant, UTC);
    }

    public static ZonedDateTime randomPastZonedDateTime() {
        return RandomDateUtils.randomZonedDateTimeBefore(ZonedDateTime.now());
    }

    public static ZonedDateTime randomZonedDateTimeBefore(ZonedDateTime before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        Instant instant = RandomDateUtils.randomInstantBefore(before.toInstant());
        return ZonedDateTime.ofInstant(instant, UTC);
    }

    public static OffsetDateTime randomOffsetDateTime() {
        return OffsetDateTime.ofInstant(RandomDateUtils.randomInstant(), UTC);
    }

    public static OffsetDateTime randomOffsetDateTime(OffsetDateTime startInclusive, OffsetDateTime endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        Instant instant = RandomDateUtils.randomInstant(startInclusive.toInstant(), endExclusive.toInstant());
        return OffsetDateTime.ofInstant(instant, UTC);
    }

    public static OffsetDateTime randomFutureOffsetDateTime() {
        return RandomDateUtils.randomOffsetDateTimeAfter(OffsetDateTime.now());
    }

    public static OffsetDateTime randomOffsetDateTimeAfter(OffsetDateTime after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        Instant instant = RandomDateUtils.randomInstantAfter(after.toInstant());
        return OffsetDateTime.ofInstant(instant, UTC);
    }

    public static OffsetDateTime randomPastOffsetDateTime() {
        return RandomDateUtils.randomOffsetDateTimeBefore(OffsetDateTime.now());
    }

    public static OffsetDateTime randomOffsetDateTimeBefore(OffsetDateTime before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        Instant instant = RandomDateUtils.randomInstantBefore(before.toInstant());
        return OffsetDateTime.ofInstant(instant, UTC);
    }

    public static LocalDateTime randomLocalDateTime() {
        return LocalDateTime.ofInstant(RandomDateUtils.randomInstant(), UTC);
    }

    public static LocalDateTime randomLocalDateTime(LocalDateTime startInclusive, LocalDateTime endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        Instant startInstant = startInclusive.toInstant(UTC_OFFSET);
        Instant endInstant = endExclusive.toInstant(UTC_OFFSET);
        Instant instant = RandomDateUtils.randomInstant(startInstant, endInstant);
        return LocalDateTime.ofInstant(instant, UTC);
    }

    public static LocalDateTime randomFutureLocalDateTime() {
        return RandomDateUtils.randomLocalDateTimeAfter(LocalDateTime.now());
    }

    public static LocalDateTime randomLocalDateTimeAfter(LocalDateTime after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        Instant instant = RandomDateUtils.randomInstantAfter(after.toInstant(UTC_OFFSET));
        return LocalDateTime.ofInstant(instant, UTC);
    }

    public static LocalDateTime randomPastLocalDateTime() {
        return RandomDateUtils.randomLocalDateTimeBefore(LocalDateTime.now());
    }

    public static LocalDateTime randomLocalDateTimeBefore(LocalDateTime before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        Instant instant = RandomDateUtils.randomInstantBefore(before.toInstant(UTC_OFFSET));
        return LocalDateTime.ofInstant(instant, UTC);
    }

    public static LocalDate randomLocalDate() {
        return RandomDateUtils.randomInstant().atZone(UTC).toLocalDate();
    }

    public static LocalDate randomLocalDate(LocalDate startInclusive, LocalDate endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        Instant startInstant = startInclusive.atStartOfDay().toInstant(UTC_OFFSET);
        Instant endInstant = endExclusive.atStartOfDay().toInstant(UTC_OFFSET);
        Instant instant = RandomDateUtils.randomInstant(startInstant, endInstant);
        return instant.atZone(UTC).toLocalDate();
    }

    public static LocalDate randomFutureLocalDate() {
        return RandomDateUtils.randomLocalDateAfter(LocalDate.now());
    }

    public static LocalDate randomLocalDateAfter(LocalDate after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        Instant instant = RandomDateUtils.randomInstantAfter(after.atStartOfDay(UTC).plus(1L, ChronoUnit.DAYS).toInstant());
        return instant.atZone(UTC).toLocalDate();
    }

    public static LocalDate randomPastLocalDate() {
        return RandomDateUtils.randomLocalDateBefore(LocalDate.now());
    }

    public static LocalDate randomLocalDateBefore(LocalDate before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        Instant instant = RandomDateUtils.randomInstantBefore(before.atStartOfDay(UTC).toInstant());
        return instant.atZone(UTC).toLocalDate();
    }

    public static Date randomDate() {
        return Date.from(RandomDateUtils.randomInstant());
    }

    public static Date randomDate(Date startInclusive, Date endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        Instant startInstant = startInclusive.toInstant();
        Instant endInstant = endExclusive.toInstant();
        Instant instant = RandomDateUtils.randomInstant(startInstant, endInstant);
        return Date.from(instant);
    }

    public static Date randomFutureDate() {
        return RandomDateUtils.randomDateAfter(new Date());
    }

    public static Date randomDateAfter(Date after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        Instant instant = RandomDateUtils.randomInstantAfter(after.toInstant());
        return Date.from(instant);
    }

    public static Date randomPastDate() {
        return RandomDateUtils.randomDateBefore(new Date());
    }

    public static Date randomDateBefore(Date before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        Instant instant = RandomDateUtils.randomInstantBefore(before.toInstant());
        return Date.from(instant);
    }

    public static Instant randomInstant() {
        return RandomDateUtils.randomInstant(MIN_INSTANT, MAX_INSTANT);
    }

    public static Instant randomInstant(Instant startInclusive, Instant endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        Preconditions.checkArgument((!startInclusive.isAfter(endExclusive) ? 1 : 0) != 0, (Object)"End must be on or after start");
        Preconditions.checkArgument((startInclusive.equals(MIN_INSTANT) || startInclusive.isAfter(MIN_INSTANT) ? 1 : 0) != 0, (String)"Start must be on or after %s", (Object)MIN_INSTANT);
        Preconditions.checkArgument((endExclusive.equals(MAX_INSTANT) || endExclusive.isBefore(MAX_INSTANT) ? 1 : 0) != 0, (String)"End must be on or before %s", (Object)MAX_INSTANT);
        return Instant.ofEpochMilli(RandomUtils.nextLong((long)startInclusive.toEpochMilli(), (long)endExclusive.toEpochMilli()));
    }

    public static Instant randomFutureInstant() {
        return RandomDateUtils.randomInstantAfter(Instant.now());
    }

    public static Instant randomInstantAfter(Instant after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        Preconditions.checkArgument((boolean)after.isBefore(MAX_INSTANT), (String)"Cannot produce date after %s", (Object)MAX_INSTANT);
        return RandomDateUtils.randomInstant(after.plus(1L, ChronoUnit.MILLIS), MAX_INSTANT);
    }

    public static Instant randomPastInstant() {
        return RandomDateUtils.randomInstantBefore(Instant.now());
    }

    public static Instant randomInstantBefore(Instant before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        Preconditions.checkArgument((boolean)before.isAfter(MIN_INSTANT), (String)"Cannot produce date before %s", (Object)MIN_INSTANT);
        return RandomDateUtils.randomInstant(MIN_INSTANT, before);
    }

    public static LocalTime randomLocalTime() {
        return LocalTime.ofNanoOfDay(RandomDateUtils.random(ChronoField.NANO_OF_DAY));
    }

    public static LocalTime randomLocalTime(LocalTime startInclusive, LocalTime endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        long nanoOfDay = RandomDateUtils.random(ChronoField.NANO_OF_DAY, startInclusive.toNanoOfDay(), endExclusive.toNanoOfDay());
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    public static LocalTime randomLocalTimeAfter(LocalTime after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        Preconditions.checkArgument((boolean)after.isBefore(LocalTime.MAX), (String)"After must be before %s", (Object)LocalTime.MAX);
        long nanoOfDay = RandomDateUtils.randomAfter(ChronoField.NANO_OF_DAY, after.toNanoOfDay() + 1L);
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    public static LocalTime randomLocalTimeBefore(LocalTime before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        Preconditions.checkArgument((boolean)before.isAfter(LocalTime.MIN), (String)"Before must be after %s", (Object)LocalTime.MIN);
        long nanoOfDay = RandomDateUtils.randomBefore(ChronoField.NANO_OF_DAY, before.toNanoOfDay());
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    public static long random(TemporalField field) {
        long max = Math.min(field.range().getMaximum(), 0x7FFFFFFFFFFFFFFEL);
        return RandomNumberUtils.randomLong(field.range().getMinimum(), max + 1L);
    }

    public static long random(TemporalField field, long startInclusive, long endExclusive) {
        long min = field.range().getMinimum();
        long max = field.range().getMaximum();
        Preconditions.checkArgument((startInclusive >= min ? 1 : 0) != 0, (String)"Start must be on or after %s", (long)min);
        Preconditions.checkArgument((endExclusive <= max ? 1 : 0) != 0, (String)"End must be on or before %s", (long)max);
        Preconditions.checkArgument((startInclusive <= endExclusive ? 1 : 0) != 0, (Object)"End must be on or after start");
        min = Math.max(startInclusive, field.range().getMinimum());
        max = Math.min(endExclusive, field.range().getMaximum());
        return RandomNumberUtils.randomLong(min, max);
    }

    public static long randomAfter(TemporalField field, long after) {
        Long min = field.range().getMinimum();
        Long max = field.range().getMaximum();
        Preconditions.checkArgument((after < max ? 1 : 0) != 0, (String)"After must be before %s", (Object)max);
        Preconditions.checkArgument((after >= min ? 1 : 0) != 0, (String)"After must be on or after %s", (Object)min);
        return RandomNumberUtils.randomLong(after + 1L, Math.min(max, 0x7FFFFFFFFFFFFFFEL) + 1L);
    }

    public static long randomBefore(TemporalField field, long before) {
        long min = field.range().getMinimum();
        long max = field.range().getMaximum();
        Preconditions.checkArgument((before > min ? 1 : 0) != 0, (String)"Before must be after %s", (long)min);
        Preconditions.checkArgument((before <= max ? 1 : 0) != 0, (String)"Before must be on or before %s", (long)max);
        return RandomNumberUtils.randomLong(min, before);
    }

    public static MonthDay randomMonthDay() {
        return RandomDateUtils.randomMonthDay(Year.now().isLeap());
    }

    public static MonthDay randomMonthDay(boolean includeLeapDay) {
        Month month = RandomDateUtils.randomMonth();
        int dayOfMonth = RandomUtils.nextInt((int)1, (int)(month.maxLength() + 1));
        MonthDay monthDay = MonthDay.of(month, dayOfMonth);
        if (!includeLeapDay && DateUtils.isLeapDay(monthDay)) {
            return RandomDateUtils.randomMonthDay(false);
        }
        return monthDay;
    }

    public static MonthDay randomMonthDay(MonthDay startInclusive, MonthDay endExclusive) {
        return RandomDateUtils.randomMonthDay(startInclusive, endExclusive, Year.now().isLeap());
    }

    public static MonthDay randomMonthDay(MonthDay startInclusive, MonthDay endExclusive, boolean includeLeapDay) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        Preconditions.checkArgument((includeLeapDay || !startInclusive.equals(DateUtils.LEAP_DAY) || !endExclusive.equals(DateUtils.LEAP_DAY) ? 1 : 0) != 0, (Object)"Start and End can't both be leap day");
        int year = includeLeapDay ? 2004 : 2003;
        LocalDate start = startInclusive.atYear(year);
        LocalDate end = endExclusive.atYear(year);
        LocalDate localDate = RandomDateUtils.randomLocalDate(start, end);
        return MonthDay.of(localDate.getMonth(), localDate.getDayOfMonth());
    }

    public static MonthDay randomMonthDayAfter(MonthDay after) {
        return RandomDateUtils.randomMonthDayAfter(after, Year.now().isLeap());
    }

    public static MonthDay randomMonthDayAfter(MonthDay after, boolean includeLeapDay) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        Preconditions.checkArgument((boolean)after.isBefore(MonthDay.of(Month.DECEMBER, 31)), (Object)"After must be before December 31st");
        int year = includeLeapDay ? 2004 : 2003;
        LocalDate start = after.atYear(year).plus(1L, ChronoUnit.DAYS);
        LocalDate end = Year.of(year + 1).atDay(1);
        LocalDate localDate = RandomDateUtils.randomLocalDate(start, end);
        return MonthDay.of(localDate.getMonth(), localDate.getDayOfMonth());
    }

    public static MonthDay randomMonthDayBefore(MonthDay before) {
        return RandomDateUtils.randomMonthDayBefore(before, Year.now().isLeap());
    }

    public static MonthDay randomMonthDayBefore(MonthDay before, boolean includeLeapDay) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        Preconditions.checkArgument((boolean)before.isAfter(MonthDay.of(Month.JANUARY, 1)), (Object)"Before must be after January 1st");
        int year = includeLeapDay ? 2004 : 2003;
        LocalDate startOfYear = Year.of(year).atDay(1);
        LocalDate end = before.atYear(year);
        LocalDate localDate = RandomDateUtils.randomLocalDate(startOfYear, end);
        return MonthDay.of(localDate.getMonth(), localDate.getDayOfMonth());
    }

    public static YearMonth randomYearMonth() {
        return YearMonth.of(RandomDateUtils.randomYear().getValue(), RandomDateUtils.randomMonth());
    }

    public static YearMonth randomYearMonth(YearMonth startInclusive, YearMonth endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        LocalDate start = startInclusive.atDay(1);
        LocalDate end = endExclusive.atDay(1);
        LocalDate localDate = RandomDateUtils.randomLocalDate(start, end);
        return YearMonth.of(localDate.getYear(), localDate.getMonth());
    }

    public static YearMonth randomFutureYearMonth() {
        return RandomDateUtils.randomYearMonthAfter(YearMonth.now());
    }

    public static YearMonth randomYearMonthAfter(YearMonth after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        LocalDate start = after.plus(1L, ChronoUnit.MONTHS).atDay(1);
        LocalDate localDate = RandomDateUtils.randomLocalDateAfter(start);
        return YearMonth.of(localDate.getYear(), localDate.getMonth());
    }

    public static YearMonth randomPastYearMonth() {
        return RandomDateUtils.randomYearMonthBefore(YearMonth.now());
    }

    public static YearMonth randomYearMonthBefore(YearMonth before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        LocalDate start = before.atDay(1);
        LocalDate localDate = RandomDateUtils.randomLocalDateBefore(start);
        return YearMonth.of(localDate.getYear(), localDate.getMonth());
    }

    public static Year randomYear() {
        return Year.of(RandomUtils.nextInt((int)1970, (int)9999));
    }

    public static Year randomYear(Year startInclusive, Year endExclusive) {
        Preconditions.checkArgument((startInclusive != null ? 1 : 0) != 0, (Object)"Start must be non-null");
        Preconditions.checkArgument((endExclusive != null ? 1 : 0) != 0, (Object)"End must be non-null");
        return RandomDateUtils.randomYear(startInclusive.getValue(), endExclusive.getValue());
    }

    public static Year randomYear(int startInclusive, int endExclusive) {
        Preconditions.checkArgument((startInclusive < 9999 ? 1 : 0) != 0, (String)"Start must be before %s", (int)9999);
        Preconditions.checkArgument((startInclusive >= 1970 ? 1 : 0) != 0, (String)"Start must be on or after %s", (int)1970);
        Preconditions.checkArgument((endExclusive > 1970 ? 1 : 0) != 0, (String)"End must be after %s", (int)1970);
        Preconditions.checkArgument((endExclusive <= 9999 ? 1 : 0) != 0, (String)"End must be on or before %s", (int)9999);
        Preconditions.checkArgument((startInclusive <= endExclusive ? 1 : 0) != 0, (Object)"End must be on or after start");
        return Year.of(RandomUtils.nextInt((int)startInclusive, (int)endExclusive));
    }

    public static Year randomFutureYear() {
        return RandomDateUtils.randomYearAfter(Year.now());
    }

    public static Year randomYearAfter(Year after) {
        Preconditions.checkArgument((after != null ? 1 : 0) != 0, (Object)"After must be non-null");
        return RandomDateUtils.randomYearAfter(after.getValue());
    }

    public static Year randomYearAfter(int after) {
        Preconditions.checkArgument((after < 9999 ? 1 : 0) != 0, (String)"After must be before %s", (int)9999);
        return Year.of(RandomUtils.nextInt((int)(after + 1), (int)9999));
    }

    public static Year randomPastYear() {
        return RandomDateUtils.randomYearBefore(Year.now());
    }

    public static Year randomYearBefore(Year before) {
        Preconditions.checkArgument((before != null ? 1 : 0) != 0, (Object)"Before must be non-null");
        return RandomDateUtils.randomYearBefore(before.getValue());
    }

    public static Year randomYearBefore(int before) {
        Preconditions.checkArgument((before > 1970 ? 1 : 0) != 0, (String)"Before must be after %s", (int)1970);
        return Year.of(RandomUtils.nextInt((int)1970, (int)before));
    }

    public static Clock randomFixedUtcClock() {
        return Clock.fixed(RandomDateUtils.randomInstant(), UTC);
    }

    public static Clock randomFixedClock() {
        return Clock.fixed(RandomDateUtils.randomInstant(), RandomDateUtils.randomZoneId());
    }

    public static ZoneId randomZoneId() {
        return ZoneId.of(IterableUtils.randomFrom(ZoneOffset.getAvailableZoneIds()));
    }

    public static DayOfWeek randomDayOfWeek() {
        return RandomEnumUtils.random(DayOfWeek.class);
    }

    public static Month randomMonth() {
        return RandomEnumUtils.random(Month.class);
    }

    public static ZoneOffset randomZoneOffset() {
        int totalSeconds = 64800 - RandomUtils.nextInt((int)0, (int)129601);
        return ZoneOffset.ofTotalSeconds(totalSeconds);
    }

    public static Period randomPeriod() {
        return Period.of(RandomNumberUtils.randomInt(), RandomNumberUtils.randomInt(), RandomNumberUtils.randomInt());
    }

    public static Period randomPositivePeriod() {
        return Period.of(RandomNumberUtils.randomPositiveInt(), RandomNumberUtils.randomPositiveInt(), RandomNumberUtils.randomPositiveInt());
    }

    public static Period randomNegativePeriod() {
        return Period.of(RandomNumberUtils.randomNegativeInt(), RandomNumberUtils.randomInt(), RandomNumberUtils.randomInt());
    }

    public static Duration randomDuration() {
        return Duration.ofNanos(RandomNumberUtils.randomLong());
    }

    public static Duration randomPositiveDuration() {
        return Duration.ofNanos(RandomNumberUtils.randomPositiveLong());
    }

    public static Duration randomNegativeDuration() {
        return Duration.ofNanos(RandomNumberUtils.randomNegativeLong());
    }
}

