/*
 * Decompiled with CFR 0.152.
 */
package com.github.rkumsher.collection;

import com.github.rkumsher.collection.IterableUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RandomCollectionUtils {
    private RandomCollectionUtils() {
    }

    public static <T> Set<T> randomSetFrom(Iterable<T> elements, Range<Integer> attemptedSize) {
        return Sets.newHashSet(RandomCollectionUtils.randomListFrom(elements, attemptedSize));
    }

    public static <T> Set<T> randomSetFrom(Iterable<T> elements, int attemptedSize) {
        return Sets.newHashSet(RandomCollectionUtils.randomListFrom(elements, attemptedSize));
    }

    public static <T> Set<T> randomSetFrom(Supplier<T> elementSupplier, Range<Integer> attemptedSize) {
        return Sets.newHashSet(RandomCollectionUtils.randomListFrom(elementSupplier, attemptedSize));
    }

    public static <T> Set<T> randomSetFrom(Supplier<T> elementSupplier, int attemptedSize) {
        return Sets.newHashSet(RandomCollectionUtils.randomListFrom(elementSupplier, attemptedSize));
    }

    public static <T> List<T> randomListFrom(Iterable<T> elements, Range<Integer> size) {
        Preconditions.checkArgument((!Iterables.isEmpty(elements) ? 1 : 0) != 0, (Object)"Elements to populate from must not be empty");
        return RandomCollectionUtils.randomListFrom(() -> IterableUtils.randomFrom(elements), size);
    }

    public static <T> List<T> randomListFrom(Iterable<T> elements, int size) {
        Preconditions.checkArgument((!Iterables.isEmpty(elements) ? 1 : 0) != 0, (Object)"Elements to populate from must not be empty");
        return RandomCollectionUtils.randomListFrom(() -> IterableUtils.randomFrom(elements), size);
    }

    public static <T> List<T> randomListFrom(Supplier<T> elementSupplier, Range<Integer> size) {
        Preconditions.checkArgument((size.hasLowerBound() && (Integer)size.lowerEndpoint() >= 0 ? 1 : 0) != 0, (Object)"Size range must consist of only positive integers");
        ContiguousSet rangeSet = ContiguousSet.create(size, (DiscreteDomain)DiscreteDomain.integers());
        int limit = (Integer)IterableUtils.randomFrom(rangeSet);
        return RandomCollectionUtils.randomListFrom(elementSupplier, limit);
    }

    public static <T> List<T> randomListFrom(Supplier<T> elementSupplier, int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"Size must be greater than or equal to zero");
        return Stream.generate(elementSupplier).limit(size).collect(Collectors.toList());
    }
}

