/*
 * Decompiled with CFR 0.152.
 */
package com.ricardojlrufino.jexplorer;

import com.ricardojlrufino.jexplorer.utils.AcceptAllFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FileTreeModel
extends DefaultTreeModel {
    public FileTreeModel(TreeNode root) {
        super(root);
    }

    public FileFilter getFileFilter() {
        if (this.getRoot() instanceof FileTreeNode) {
            return ((FileTreeNode)this.getRoot()).getFileFilter();
        }
        return new AcceptAllFileFilter();
    }

    public void setFileFilter(FileFilter fileFilter) {
        FileTreeNode root = (FileTreeNode)this.getRoot();
        root.setFileFilter(fileFilter);
        root.reloadChildren();
        this.nodeStructureChanged(root);
    }

    @Override
    public void setRoot(TreeNode root) {
        FileFilter fileFilter = this.getFileFilter();
        super.setRoot(root);
        this.setFileFilter(fileFilter);
    }

    public static class FileTreeNode
    extends DefaultMutableTreeNode {
        private File file;
        private FileFilter fileFilter = new AcceptAllFileFilter();
        protected String name;
        protected boolean populated;
        protected boolean interim;
        protected boolean isDir;

        public FileTreeNode(File f) {
            this.file = f;
            this.setUserObject(f);
            this.name = f.getName();
            this.isDir = f.isDirectory();
            if (!this.isDir && !f.isFile()) {
                this.isDir = true;
            }
        }

        public void reloadChildren() {
            this.populated = false;
            this.removeAllChildren();
            this.populateDirectories(true);
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public boolean isLeaf() {
            return !this.isDir;
        }

        @Override
        public boolean getAllowsChildren() {
            return this.isDir;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public String getFullName() {
            return this.file.getAbsolutePath();
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public void setUserObject(Object userObject) {
            this.file = (File)userObject;
            super.setUserObject(userObject);
        }

        boolean populateDirectories(boolean descend) {
            boolean addedNodes = false;
            if (!this.populated) {
                File f = this.getFile();
                if (!f.isDirectory()) {
                    return false;
                }
                try {
                    f.canRead();
                }
                catch (SecurityException e) {
                    this.populated = true;
                    return false;
                }
                if (this.interim) {
                    this.removeAllChildren();
                    this.interim = false;
                }
                File[] files = f.listFiles(this.getFileFilter());
                ArrayList<FileTreeNode> list = new ArrayList<FileTreeNode>();
                for (int i = 0; i < files.length; ++i) {
                    File d = files[i];
                    try {
                        FileTreeNode node = new FileTreeNode(d);
                        list.add(node);
                        if (descend && d.isDirectory()) {
                            node.populateDirectories(false);
                        }
                        addedNodes = true;
                        if (descend) continue;
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (addedNodes) {
                    Object[] nodes = list.toArray();
                    Arrays.sort(nodes, new Comparator(){

                        @Override
                        public boolean equals(Object o) {
                            return false;
                        }

                        public int compare(Object o1, Object o2) {
                            FileTreeNode node1 = (FileTreeNode)o1;
                            FileTreeNode node2 = (FileTreeNode)o2;
                            if (node1.isDir != node2.isDir) {
                                return node1.isDir ? -1 : 1;
                            }
                            return node1.getFullName().compareTo(node2.getFullName());
                        }
                    });
                    for (int j = 0; j < nodes.length; ++j) {
                        this.add((FileTreeNode)nodes[j]);
                    }
                }
                if (descend || !addedNodes) {
                    this.populated = true;
                } else {
                    this.interim = true;
                }
            }
            return addedNodes;
        }

        public int addNode(String name) {
            if (this.populated) {
                int childCount = this.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    FileTreeNode node = (FileTreeNode)this.getChildAt(i);
                    if (!node.name.equals(name)) continue;
                    if (node.isDir()) {
                        node.interim = true;
                        node.populated = false;
                    }
                    return -1;
                }
                try {
                    FileTreeNode node = new FileTreeNode(new File(this.file, name));
                    this.add(node);
                    return childCount;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return -1;
        }

        public FileFilter getFileFilter() {
            if (this.getParent() != null) {
                return ((FileTreeNode)this.getParent()).getFileFilter();
            }
            return this.fileFilter;
        }

        public void setFileFilter(FileFilter fileFilter) {
            if (this.getParent() instanceof FileTreeNode) {
                ((FileTreeNode)this.getParent()).setFileFilter(fileFilter);
            } else {
                this.fileFilter = fileFilter;
            }
        }
    }
}

