/*
 * Decompiled with CFR 0.152.
 */
package com.ricardojlrufino.jexplorer;

import com.ricardojlrufino.jexplorer.utils.FormUtility;
import com.ricardojlrufino.jexplorer.utils.Translate;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class FilePropertiesDialog
extends JDialog {
    private File file;
    private Translate translate;
    private static final long serialVersionUID = 1L;

    public FilePropertiesDialog(File file, Translate translate) {
        super((Frame)null);
        this.file = file;
        this.translate = translate;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(this.tr("Properties"));
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FilePropertiesDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        JPanel form = new JPanel(new GridBagLayout());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(form);
        form.setBorder(BorderFactory.createTitledBorder(this.tr("File Properties")));
        FormUtility formUtility = new FormUtility();
        formUtility.addLabel(this.tr("Name: "), (Container)form);
        formUtility.addLastField(new JLabel(this.file.getName()), form);
        formUtility.addLabel(this.tr("Size: "), (Container)form);
        formUtility.addLastField(new JLabel(this.file.length() + " bytes"), form);
        String date = DateFormat.getDateTimeInstance().format(new Date(this.file.lastModified()));
        formUtility.addLabel(this.tr("Date: "), (Container)form);
        formUtility.addLastField(new JLabel(date), form);
        JPanel form2 = new JPanel(new GridBagLayout());
        form2.setBorder(BorderFactory.createTitledBorder(this.tr("Location")));
        this.getContentPane().add(form2);
        JButton open = new JButton(this.tr("Open"));
        JTextField textField = new JTextField(this.file.getAbsolutePath(), 30);
        textField.setEditable(false);
        open.setPreferredSize(new Dimension(open.getPreferredSize().width, textField.getPreferredSize().height));
        formUtility.addLabel(textField, (Container)form2);
        formUtility.addLastField(open, form2);
        JPanel buttons = new JPanel(new FlowLayout(2));
        this.getContentPane().add(buttons);
        final JButton close = new JButton(this.tr("Close"));
        close.addActionListener(escapeAction);
        buttons.add(close);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                close.requestFocus();
            }
        });
    }

    public void setTranslate(Translate translate) {
        this.translate = translate;
    }

    private String tr(String name) {
        if (this.translate == null) {
            return name;
        }
        return this.translate.get(name);
    }
}

