/*
 * Decompiled with CFR 0.152.
 */
package com.ricardojlrufino.jexplorer;

import com.ricardojlrufino.jexplorer.FileTreeModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class FileOperation {
    private TreePath[] selections;
    private TreePath leadSelection;
    protected JTree tree;

    public abstract boolean execute() throws IOException;

    public abstract boolean undo() throws IOException;

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    protected void saveTreeSelection() {
        this.selections = this.tree.getSelectionPaths();
        this.leadSelection = this.tree.getLeadSelectionPath();
    }

    protected void restoreTreeSelection() {
        this.tree.setSelectionPaths(this.selections);
        if (this.leadSelection != null) {
            this.tree.removeSelectionPath(this.leadSelection);
            this.tree.addSelectionPath(this.leadSelection);
        }
    }

    public TreePath[] getSelections() {
        return this.selections;
    }

    public TreePath getLeadSelection() {
        return this.leadSelection;
    }

    public static class FileOperationDelete
    extends FileOperationMove {
        public FileOperationDelete(List<File> originFiles) {
            super(originFiles, null);
        }

        @Override
        public boolean execute() throws IOException {
            Path path = Files.createTempDirectory("jfileexplorer" + System.currentTimeMillis(), new FileAttribute[0]);
            this.toDir = path.toFile();
            return super.execute();
        }

        @Override
        public boolean undo() throws IOException {
            boolean undo = super.undo();
            if (undo) {
                this.toDir.delete();
            }
            return undo;
        }
    }

    public static class FileOperationRename
    extends FileOperation {
        private FileTreeModel.FileTreeNode fileNode;
        private File oldFile;
        private String newName;

        public FileOperationRename(FileTreeModel.FileTreeNode selectedNode, String newName) {
            this.fileNode = selectedNode;
            this.newName = newName;
            this.oldFile = this.fileNode.getFile();
        }

        private File getOldFile() {
            return this.oldFile;
        }

        public File getNewFile() {
            return new File(this.getOldFile().getParent(), this.newName);
        }

        @Override
        public boolean execute() {
            File newFile = this.getNewFile();
            boolean renamed = this.oldFile.renameTo(newFile);
            if (renamed) {
                this.fileNode.setUserObject(newFile);
            }
            if (newFile.isDirectory()) {
                this.fileNode.reloadChildren();
            }
            return renamed;
        }

        @Override
        public boolean undo() {
            File newFile = this.getNewFile();
            boolean renamed = newFile.renameTo(this.oldFile);
            if (renamed) {
                this.fileNode.setUserObject(this.oldFile);
                if (this.oldFile.isDirectory()) {
                    this.fileNode.reloadChildren();
                }
            }
            return renamed;
        }
    }

    public static class FileOperationMove
    extends FileOperationCopy {
        public FileOperationMove(List<File> originFiles, File toDir) {
            super(originFiles, toDir, true);
        }
    }

    public static class FileOperationCopy
    extends FileOperation {
        protected List<File> originFiles = new LinkedList<File>();
        protected File toDir;
        private boolean move;

        public FileOperationCopy(List<File> originFiles, File toDir, boolean move) {
            this.originFiles = this.buildFolderList(originFiles);
            this.toDir = toDir;
            this.move = move;
        }

        private List<File> buildFolderList(List<File> originFiles) {
            return originFiles;
        }

        @Override
        public boolean execute() throws IOException {
            for (File from : this.originFiles) {
                File to = new File(this.toDir, from.getName());
                if (to.exists() && !to.isDirectory() && !this.move) {
                    to = new File(this.toDir, "copy_" + from.getName());
                    continue;
                }
                if (this.move) {
                    if (from.isDirectory()) {
                        FileOperationCopy.moveTree(from, to);
                        continue;
                    }
                    Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                if (from.isDirectory()) {
                    this.copyTree(from.toPath(), to.toPath());
                    continue;
                }
                Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }

        private void copyTree(Path src, Path dest) throws IOException {
            try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
                stream.forEach(source -> this.copy((Path)source, dest.resolve(src.relativize((Path)source))));
            }
        }

        private void copy(Path source, Path dest) {
            try {
                Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private static void moveTree(File currDir, File toDir) throws IOException {
            try {
                System.out.println("form: " + currDir);
                System.out.println("to: " + toDir);
                if (!toDir.exists()) {
                    toDir.mkdirs();
                }
                for (File file : currDir.listFiles()) {
                    if (file.isDirectory()) {
                        System.out.println("  >>" + new File(toDir, currDir.getName()));
                        FileOperationCopy.moveTree(file, new File(toDir, file.getName()));
                        continue;
                    }
                    File to = new File(toDir, file.getName());
                    System.out.println("  >>" + to);
                    Files.move(file.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                currDir.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        public List<File> getTargetFiles() {
            ArrayList<File> targetFiles = new ArrayList<File>();
            for (File from : this.originFiles) {
                File to = new File(this.toDir, from.getName());
                if (!to.exists()) continue;
                targetFiles.add(to);
            }
            return targetFiles;
        }

        @Override
        public boolean undo() throws IOException {
            TreePath[] selections;
            List<File> reverFiles = this.getTargetFiles();
            if (this.move) {
                File reverDir = this.originFiles.get(0).getParentFile();
                FileOperationCopy copy = new FileOperationCopy(reverFiles, reverDir, true);
                copy.execute();
            } else {
                for (File file : reverFiles) {
                    file.delete();
                }
            }
            for (TreePath treePath : selections = this.getSelections()) {
                FileTreeModel.FileTreeNode parentNode = (FileTreeModel.FileTreeNode)treePath.getParentPath().getLastPathComponent();
                parentNode.reloadChildren();
            }
            return true;
        }
    }
}

