/*
 * Decompiled with CFR 0.152.
 */
package com.ricardojlrufino.jexplorer;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FileTreeCellRenderer
extends DefaultTreeCellRenderer {
    private FileSystemView fileSystemView;
    private JLabel label;
    private Color deletedColor = Color.LIGHT_GRAY;

    FileTreeCellRenderer() {
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.fileSystemView = FileSystemView.getFileSystemView();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        File file = (File)node.getUserObject();
        if (selected) {
            this.label.setBackground(this.backgroundSelectionColor);
            this.label.setForeground(this.textSelectionColor);
        } else {
            this.label.setBackground(this.backgroundNonSelectionColor);
            this.label.setForeground(this.textNonSelectionColor);
        }
        if (file.exists()) {
            this.label.setIcon(this.fileSystemView.getSystemIcon(file));
            this.label.setToolTipText(file.getPath());
            this.label.setText(this.fileSystemView.getSystemDisplayName(file));
        } else {
            this.label.setText(file.getName());
            this.label.setForeground(this.deletedColor);
        }
        return this.label;
    }
}

