/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class TreeDragTest
extends JFrame {
    TreeDragSource ds;
    TreeDropTarget dt;
    JTree tree;

    public TreeDragTest() {
        super("Rearrangeable Tree");
        this.setSize(300, 200);
        this.setDefaultCloseOperation(3);
        this.tree = new AutoScrollingJTree();
        this.getContentPane().add((Component)new JScrollPane(this.tree), "Center");
        this.ds = new TreeDragSource(this.tree, 3);
        this.dt = new TreeDropTarget(this.tree);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new TreeDragTest();
    }

    public class AutoScrollingJTree
    extends JTree
    implements Autoscroll {
        private int margin = 12;

        @Override
        public void autoscroll(Point p) {
            int realrow = this.getRowForLocation(p.x, p.y);
            Rectangle outer = this.getBounds();
            realrow = p.y + outer.y <= this.margin ? (realrow < 1 ? 0 : realrow - 1) : (realrow < this.getRowCount() - 1 ? realrow + 1 : realrow);
            this.scrollRowToVisible(realrow);
        }

        @Override
        public Insets getAutoscrollInsets() {
            Rectangle outer = this.getBounds();
            Rectangle inner = this.getParent().getBounds();
            return new Insets(inner.y - outer.y + this.margin, inner.x - outer.x + this.margin, outer.height - inner.height - inner.y + outer.y + this.margin, outer.width - inner.width - inner.x + outer.x + this.margin);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle outer = this.getBounds();
            Rectangle inner = this.getParent().getBounds();
            g.setColor(Color.red);
            g.drawRect(-outer.x + 12, -outer.y + 12, inner.width - 24, inner.height - 24);
        }
    }
}

