/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.extensions;

import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.readium.r2.shared.extensions.HashAlgorithm;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0001\u001a\u0018\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\n*\u00020\u0001H\u0000\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0001H\u0000\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0000\u00a8\u0006\u0010"}, d2={"addPrefix", "", "prefix", "", "hash", "algorithm", "Lorg/readium/r2/shared/extensions/HashAlgorithm;", "iso8601ToDate", "Ljava/util/Date;", "queryParameters", "", "toJsonOrNull", "Lorg/json/JSONObject;", "toUrlOrNull", "Ljava/net/URL;", "context", "r2-shared_release"})
public final class StringKt {
    @Nullable
    public static final Date iso8601ToDate(@NotNull String $this$iso8601ToDate) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$iso8601ToDate, (String)"$this$iso8601ToDate");
        try {
            DateTimeZone defaultTZ = DateTimeZone.getDefault();
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
            Date date2 = new DateTime((Object)$this$iso8601ToDate).toDateTime(DateTimeZone.UTC).toDate();
            DateTimeZone.setDefault((DateTimeZone)defaultTZ);
            date = date2;
        }
        catch (Exception e) {
            date = null;
        }
        return date;
    }

    @NotNull
    public static final String addPrefix(@NotNull String $this$addPrefix, @NotNull CharSequence prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$addPrefix, (String)"$this$addPrefix");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (StringsKt.startsWith$default((CharSequence)$this$addPrefix, (CharSequence)prefix, (boolean)false, (int)2, null)) {
            return $this$addPrefix;
        }
        return prefix + $this$addPrefix;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String hash(@NotNull String $this$hash, @NotNull HashAlgorithm algorithm) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"$this$hash");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm.getKey());
        Object object = $this$hash;
        Charset charset2 = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = ((String)object).getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"MessageDigest\n        .g\u2026igest(this.toByteArray())");
        object = byArray2;
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        void var6_6 = $this$fold$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var10_10 = element$iv = var6_6[i];
            String str = accumulator$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append(str);
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            boolean bl3 = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
            accumulator$iv = stringBuilder.append(string3).toString();
        }
        return accumulator$iv;
    }

    @Nullable
    public static final URL toUrlOrNull(@NotNull String $this$toUrlOrNull, @Nullable URL context) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)$this$toUrlOrNull, (String)"$this$toUrlOrNull");
        try {
            uRL = new URL(context, $this$toUrlOrNull);
        }
        catch (Exception e) {
            uRL = null;
        }
        return uRL;
    }

    public static /* synthetic */ URL toUrlOrNull$default(String string2, URL uRL, int n, Object object) {
        if ((n & 1) != 0) {
            uRL = null;
        }
        return StringKt.toUrlOrNull(string2, uRL);
    }

    @Nullable
    public static final JSONObject toJsonOrNull(@NotNull String $this$toJsonOrNull) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)$this$toJsonOrNull, (String)"$this$toJsonOrNull");
        try {
            jSONObject = new JSONObject($this$toJsonOrNull);
        }
        catch (JSONException e) {
            jSONObject = null;
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> queryParameters(@NotNull String $this$queryParameters) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        String string2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$queryParameters, (String)"$this$queryParameters");
            String string3 = URLDecoder.decode($this$queryParameters, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"URLDecoder.decode(this, \"UTF-8\")");
            String $this$takeWhile$iv = StringsKt.substringAfter$default((String)string3, (String)"?", null, (int)2, null);
            boolean $i$f$takeWhile = false;
            int n = 0;
            int n2 = $this$takeWhile$iv.length();
            while (n < n2) {
                void index$iv;
                char it2 = $this$takeWhile$iv.charAt((int)index$iv);
                int n3 = 0;
                if (!(it2 != '#')) {
                    String it2 = $this$takeWhile$iv;
                    n3 = 0;
                    boolean bl = false;
                    String string4 = it2.substring(n3, (int)index$iv);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block4;
                }
                ++index$iv;
            }
            string2 = $this$takeWhile$iv;
        }
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable index$iv = $this$mapNotNull$iv;
        Iterable<List> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            List list2 = StringsKt.split$default((CharSequence)it, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            boolean bl3 = false;
            boolean bl4 = false;
            List it3 = list2;
            boolean bl5 = false;
            if ((it3.size() == 2 ? list2 : null) == null) continue;
            list = list;
            boolean bl6 = false;
            boolean bl7 = false;
            List it$iv$iv = list;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair(it.get(0), it.get(1));
            boolean bl9 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }
}

