/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util.http;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.util.mediatype.MediaType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u001b\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003JC\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020\u0003J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010&\u001a\u00020\u0003R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lorg/readium/r2/shared/util/http/HttpResponse;", "", "url", "", "statusCode", "", "headers", "", "", "mediaType", "Lorg/readium/r2/shared/util/mediatype/MediaType;", "(Ljava/lang/String;ILjava/util/Map;Lorg/readium/r2/shared/util/mediatype/MediaType;)V", "acceptsByteRanges", "", "getAcceptsByteRanges", "()Z", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getHeaders", "()Ljava/util/Map;", "getMediaType", "()Lorg/readium/r2/shared/util/mediatype/MediaType;", "getStatusCode", "()I", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "valueForHeader", "name", "valuesForHeader", "r2-shared_release"})
public final class HttpResponse {
    @NotNull
    private final String url;
    private final int statusCode;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final MediaType mediaType;

    public HttpResponse(@NotNull String url, int statusCode, @NotNull Map<String, ? extends List<String>> headers, @NotNull MediaType mediaType2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        this.url = url;
        this.statusCode = statusCode;
        this.headers = headers;
        this.mediaType = mediaType2;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final MediaType getMediaType() {
        return this.mediaType;
    }

    @Nullable
    public final String valueForHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (String)CollectionsKt.firstOrNull(this.valuesForHeader(name));
    }

    @NotNull
    public final List<String> valuesForHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = name;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String name2 = string3;
        Map<String, List<String>> $this$filterKeys$iv = this.headers;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, List<String>> result$iv = new LinkedHashMap<String, List<String>>();
        Map<String, List<String>> map = $this$filterKeys$iv;
        boolean bl2 = false;
        for (Map.Entry<String, List<String>> entry$iv : map.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl3 = false;
            String string4 = it;
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
            boolean bl4 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
            if (!Intrinsics.areEqual((Object)string6, (Object)name2)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.flatten((Iterable)((Map)result$iv).values());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getAcceptsByteRanges() {
        Object object;
        String string2;
        String string3;
        String string4 = this.valueForHeader("Accept-Ranges");
        if (string4 == null) {
            string3 = null;
        } else {
            string2 = string4;
            object = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROOT");
            boolean bl = false;
            String string5 = string2.toLowerCase((Locale)object);
            string3 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        if (Intrinsics.areEqual(string3, (Object)"bytes")) return true;
        string4 = this.valueForHeader("Content-Range");
        if (string4 == null) {
            return false;
        }
        object = string4;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string6 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
        string2 = string6;
        if (string2 == null) {
            return false;
        }
        if (!StringsKt.startsWith$default((String)string2, (String)"bytes", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public final Long getContentLength() {
        Long l;
        String string2 = this.valueForHeader("Content-Length");
        if (string2 == null) {
            l = null;
        } else {
            Long l2 = StringsKt.toLongOrNull((String)string2);
            if (l2 == null) {
                l = null;
            } else {
                Long l3 = l2;
                boolean bl = false;
                boolean bl2 = false;
                long it = ((Number)l3).longValue();
                boolean bl3 = false;
                l = it >= 0L ? l3 : null;
            }
        }
        return l;
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    public final int component2() {
        return this.statusCode;
    }

    @NotNull
    public final Map<String, List<String>> component3() {
        return this.headers;
    }

    @NotNull
    public final MediaType component4() {
        return this.mediaType;
    }

    @NotNull
    public final HttpResponse copy(@NotNull String url, int statusCode, @NotNull Map<String, ? extends List<String>> headers, @NotNull MediaType mediaType2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)mediaType2, (String)"mediaType");
        return new HttpResponse(url, statusCode, headers, mediaType2);
    }

    public static /* synthetic */ HttpResponse copy$default(HttpResponse httpResponse, String string2, int n, Map map, MediaType mediaType2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = httpResponse.url;
        }
        if ((n2 & 2) != 0) {
            n = httpResponse.statusCode;
        }
        if ((n2 & 4) != 0) {
            map = httpResponse.headers;
        }
        if ((n2 & 8) != 0) {
            mediaType2 = httpResponse.mediaType;
        }
        return httpResponse.copy(string2, n, map, mediaType2);
    }

    @NotNull
    public String toString() {
        return "HttpResponse(url=" + this.url + ", statusCode=" + this.statusCode + ", headers=" + this.headers + ", mediaType=" + this.mediaType + ')';
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + Integer.hashCode(this.statusCode);
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + this.mediaType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpResponse)) {
            return false;
        }
        HttpResponse httpResponse = (HttpResponse)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)httpResponse.url)) {
            return false;
        }
        if (this.statusCode != httpResponse.statusCode) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, httpResponse.headers)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mediaType, (Object)httpResponse.mediaType);
    }
}

