/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.format;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000J\u0013\u0010 \u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003J\u0010\u0010#\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000J#\u0010$\u001a\u00020\n2\u0016\u0010%\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030&\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010'J#\u0010$\u001a\u00020\n2\u0016\u0010%\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00000&\"\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019\u00a8\u0006+"}, d2={"Lorg/readium/r2/shared/format/MediaType;", "", "string", "", "(Ljava/lang/String;)V", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "isAudio", "", "()Z", "isBitmap", "isHtml", "isJson", "isOpds", "isPublication", "isRwpm", "isZip", "parameters", "", "getParameters", "()Ljava/util/Map;", "structuredSyntaxSuffix", "getStructuredSyntaxSuffix", "()Ljava/lang/String;", "subtype", "getSubtype", "type", "getType", "contains", "other", "equals", "hashCode", "", "matches", "matchesAny", "others", "", "([Ljava/lang/String;)Z", "([Lorg/readium/r2/shared/format/MediaType;)Z", "toString", "Companion", "r2-shared_release"})
public final class MediaType {
    @NotNull
    private final String type;
    @NotNull
    private final String subtype;
    @NotNull
    private final Map<String, String> parameters;
    @NotNull
    private static final MediaType AAC;
    @NotNull
    private static final MediaType ACSM;
    @NotNull
    private static final MediaType AIFF;
    @NotNull
    private static final MediaType AVI;
    @NotNull
    private static final MediaType BINARY;
    @NotNull
    private static final MediaType BMP;
    @NotNull
    private static final MediaType CBZ;
    @NotNull
    private static final MediaType CSS;
    @NotNull
    private static final MediaType DIVINA;
    @NotNull
    private static final MediaType DIVINA_MANIFEST;
    @NotNull
    private static final MediaType EPUB;
    @NotNull
    private static final MediaType GIF;
    @NotNull
    private static final MediaType GZ;
    @NotNull
    private static final MediaType JAVASCRIPT;
    @NotNull
    private static final MediaType JPEG;
    @NotNull
    private static final MediaType HTML;
    @NotNull
    private static final MediaType OPDS1;
    @NotNull
    private static final MediaType OPDS1_ENTRY;
    @NotNull
    private static final MediaType OPDS2;
    @NotNull
    private static final MediaType OPDS2_PUBLICATION;
    @NotNull
    private static final MediaType OPDS_AUTHENTICATION;
    @NotNull
    private static final MediaType JSON;
    @NotNull
    private static final MediaType LCP_PROTECTED_AUDIOBOOK;
    @NotNull
    private static final MediaType LCP_PROTECTED_PDF;
    @NotNull
    private static final MediaType LCP_LICENSE_DOCUMENT;
    @NotNull
    private static final MediaType LCP_STATUS_DOCUMENT;
    @NotNull
    private static final MediaType LPF;
    @NotNull
    private static final MediaType MP3;
    @NotNull
    private static final MediaType MPEG;
    @NotNull
    private static final MediaType NCX;
    @NotNull
    private static final MediaType OGG;
    @NotNull
    private static final MediaType OGV;
    @NotNull
    private static final MediaType OPUS;
    @NotNull
    private static final MediaType OTF;
    @NotNull
    private static final MediaType PDF;
    @NotNull
    private static final MediaType PNG;
    @NotNull
    private static final MediaType READIUM_AUDIOBOOK;
    @NotNull
    private static final MediaType READIUM_AUDIOBOOK_MANIFEST;
    @NotNull
    private static final MediaType READIUM_WEBPUB;
    @NotNull
    private static final MediaType READIUM_WEBPUB_MANIFEST;
    @NotNull
    private static final MediaType SMIL;
    @NotNull
    private static final MediaType SVG;
    @NotNull
    private static final MediaType TEXT;
    @NotNull
    private static final MediaType TIFF;
    @NotNull
    private static final MediaType TTF;
    @NotNull
    private static final MediaType W3C_WPUB_MANIFEST;
    @NotNull
    private static final MediaType WAV;
    @NotNull
    private static final MediaType WEBM_AUDIO;
    @NotNull
    private static final MediaType WEBM_VIDEO;
    @NotNull
    private static final MediaType WEBP;
    @NotNull
    private static final MediaType WOFF;
    @NotNull
    private static final MediaType WOFF2;
    @NotNull
    private static final MediaType XHTML;
    @NotNull
    private static final MediaType XML;
    @NotNull
    private static final MediaType ZAB;
    @NotNull
    private static final MediaType ZIP;
    public static final Companion Companion;

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getSubtype() {
        return this.subtype;
    }

    @NotNull
    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    @Nullable
    public final String getStructuredSyntaxSuffix() {
        List parts = StringsKt.split$default((CharSequence)this.subtype, (String[])new String[]{"+"}, (boolean)false, (int)0, (int)6, null);
        return parts.size() > 1 ? '+' + (String)CollectionsKt.last((List)parts) : null;
    }

    @Nullable
    public final Charset getCharset() {
        Charset charset2;
        String string = this.parameters.get("charset");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            charset2 = Charset.forName(it);
        } else {
            charset2 = null;
        }
        return charset2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = this.parameters;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        String params = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        CharSequence charSequence = params;
        boolean bl3 = false;
        if (charSequence.length() > 0) {
            params = ';' + params;
        }
        return this.type + '/' + this.subtype + params;
    }

    public boolean equals(@Nullable Object other) {
        String string = this.toString();
        Object object = other;
        if (!(object instanceof MediaType)) {
            object = null;
        }
        MediaType mediaType = (MediaType)object;
        return Intrinsics.areEqual((Object)string, (Object)(mediaType != null ? mediaType.toString() : null));
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + ((Object)this.parameters).hashCode();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(@Nullable MediaType other) {
        void $this$mapTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (other == null || Intrinsics.areEqual((Object)this.type, (Object)"*") ^ true && Intrinsics.areEqual((Object)this.type, (Object)other.type) ^ true || Intrinsics.areEqual((Object)this.subtype, (Object)"*") ^ true && Intrinsics.areEqual((Object)this.subtype, (Object)other.subtype) ^ true) {
            return false;
        }
        Map<String, String> $this$map$iv = this.parameters;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_10 = $this$mapTo$iv$iv2;
        boolean bl = false;
        Iterator iterator = var8_10.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        Set paramsSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Map<String, String> $this$map$iv2 = other.parameters;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        void var9_13 = $this$mapTo$iv$iv;
        boolean bl3 = false;
        Iterator iterator2 = var9_13.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry bl2 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl4 = false;
            string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        Set otherParamsSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return otherParamsSet.containsAll(paramsSet);
    }

    public final boolean contains(@Nullable String other) {
        Object object;
        block3: {
            block2: {
                object = other;
                if (object == null) break block2;
                String string = object;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                object = Companion.parse(it);
                if (object != null) break block3;
            }
            return false;
        }
        Object mediaType = object;
        return this.contains((MediaType)mediaType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matches(@Nullable MediaType other) {
        if (this.contains(other)) return true;
        MediaType mediaType = other;
        if (mediaType == null) return false;
        if (!mediaType.contains(this)) return false;
        return true;
    }

    public final boolean matches(@Nullable String other) {
        MediaType mediaType;
        MediaType mediaType2 = this;
        String string = other;
        if (string != null) {
            String string2 = string;
            MediaType mediaType3 = mediaType2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            MediaType mediaType4 = Companion.parse(it);
            mediaType2 = mediaType3;
            mediaType = mediaType4;
        } else {
            mediaType = null;
        }
        return mediaType2.matches(mediaType);
    }

    public final boolean matchesAny(MediaType ... others) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)others, (String)"others");
            MediaType[] $this$any$iv = others;
            boolean $i$f$any = false;
            MediaType[] mediaTypeArray = $this$any$iv;
            int n = mediaTypeArray.length;
            for (int i = 0; i < n; ++i) {
                MediaType element$iv;
                MediaType it = element$iv = mediaTypeArray[i];
                boolean bl2 = false;
                if (!this.matches(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean matchesAny(String ... others) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)others, (String)"others");
            String[] $this$any$iv = others;
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!this.matches(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean isZip() {
        return this.matchesAny(ZIP, LCP_PROTECTED_AUDIOBOOK, LCP_PROTECTED_PDF) || Intrinsics.areEqual((Object)this.getStructuredSyntaxSuffix(), (Object)"+zip");
    }

    public final boolean isJson() {
        return this.matches(JSON) || Intrinsics.areEqual((Object)this.getStructuredSyntaxSuffix(), (Object)"+json");
    }

    public final boolean isOpds() {
        return this.matchesAny(OPDS1, OPDS1_ENTRY, OPDS2, OPDS2_PUBLICATION, OPDS_AUTHENTICATION);
    }

    public final boolean isHtml() {
        return this.matchesAny(HTML, XHTML);
    }

    public final boolean isBitmap() {
        return this.matchesAny(BMP, GIF, JPEG, PNG, TIFF, WEBP);
    }

    public final boolean isAudio() {
        return Intrinsics.areEqual((Object)this.type, (Object)"audio");
    }

    public final boolean isRwpm() {
        return this.matchesAny(READIUM_AUDIOBOOK_MANIFEST, DIVINA_MANIFEST, READIUM_WEBPUB_MANIFEST);
    }

    public final boolean isPublication() {
        return this.matchesAny(READIUM_AUDIOBOOK, READIUM_AUDIOBOOK_MANIFEST, CBZ, DIVINA, DIVINA_MANIFEST, EPUB, LCP_PROTECTED_AUDIOBOOK, LCP_PROTECTED_PDF, LPF, PDF, W3C_WPUB_MANIFEST, READIUM_WEBPUB, READIUM_WEBPUB_MANIFEST, ZAB);
    }

    /*
     * WARNING - void declaration
     */
    private MediaType(String string) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        List it;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Object object2;
        Object object3;
        Locale $this$mapTo$iv$iv2;
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("Invalid media type: " + string);
        }
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{";"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map22 = false;
        Object object4 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Iterator it2;
            Object item$iv$iv = iterator.next();
            String string2 = (String)item$iv$iv;
            object3 = destination$iv$iv22;
            boolean bl2 = false;
            object2 = it2;
            boolean bl3 = false;
            void v0 = object2;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
            object3.add(object);
        }
        List components = (List)destination$iv$iv22;
        List types = StringsKt.split$default((CharSequence)((CharSequence)components.get(0)), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        if (types.size() != 2) {
            throw (Throwable)new IllegalArgumentException("Invalid media type: " + string);
        }
        String $i$f$map22 = (String)types.get(0);
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        $this$mapTo$iv$iv2 = locale;
        object3 = this;
        boolean destination$iv$iv22 = false;
        String string3 = $i$f$map22;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase($this$mapTo$iv$iv2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        object = string4;
        ((MediaType)object3).type = object;
        $i$f$map22 = (String)types.get(1);
        Locale locale2 = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.ROOT");
        $this$mapTo$iv$iv2 = locale2;
        object3 = this;
        destination$iv$iv22 = false;
        String string5 = $i$f$map22;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase($this$mapTo$iv$iv2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
        object = string6;
        ((MediaType)object3).subtype = object;
        Iterable $this$map$iv2 = CollectionsKt.drop((Iterable)components, (int)1);
        boolean $i$f$map = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object2 = (String)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl4 = false;
            object = StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            object3.add(object);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl5 = false;
            if (!(it.size() == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            String string7;
            Locale locale3;
            Map bl5 = destination$iv$iv3;
            List it3 = (List)element$iv$iv;
            boolean bl6 = false;
            String string8 = (String)it3.get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ROOT, (String)"Locale.ROOT");
            boolean bl7 = false;
            String string9 = string8;
            if (string9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string9.toLowerCase(locale3), (String)"(this as java.lang.String).toLowerCase(locale)");
            Object e = it3.get(1);
            String string10 = string7;
            Pair pair = new Pair((Object)string10, e);
            boolean bl8 = false;
            bl5.put(pair.getFirst(), pair.getSecond());
        }
        Map parameters = MapsKt.toMutableMap((Map)destination$iv$iv3);
        String string11 = (String)parameters.get("charset");
        if (string11 != null) {
            String string12;
            Object object5;
            object4 = string11;
            boolean bl9 = false;
            boolean bl10 = false;
            Object it4 = object4;
            boolean bl11 = false;
            String string13 = "charset";
            Object object6 = parameters;
            try {
                object5 = object6;
                string12 = string13;
                object2 = Charset.forName((String)it4).name();
            }
            catch (Exception bl5) {
                object5 = object6;
                string12 = string13;
                object2 = it4;
            }
            Object object7 = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"(try { Charset.forName(i\u2026ch (e: Exception) { it })");
            object2 = object7;
            Locale locale4 = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.ROOT");
            Locale locale5 = locale4;
            string13 = string12;
            object6 = object5;
            boolean bl12 = false;
            Object object8 = object2;
            if (object8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string14 = ((String)object8).toUpperCase(locale5);
            Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.String).toUpperCase(locale)");
            String string15 = string14;
            object6.put(string13, string15);
        }
        this.parameters = parameters;
    }

    static {
        Companion = new Companion(null);
        AAC = new MediaType("audio/aac");
        ACSM = new MediaType("application/vnd.adobe.adept+xml");
        AIFF = new MediaType("audio/aiff");
        AVI = new MediaType("video/x-msvideo");
        BINARY = new MediaType("application/octet-stream");
        BMP = new MediaType("image/bmp");
        CBZ = new MediaType("application/vnd.comicbook+zip");
        CSS = new MediaType("text/css");
        DIVINA = new MediaType("application/divina+zip");
        DIVINA_MANIFEST = new MediaType("application/divina+json");
        EPUB = new MediaType("application/epub+zip");
        GIF = new MediaType("image/gif");
        GZ = new MediaType("application/gzip");
        JAVASCRIPT = new MediaType("text/javascript");
        JPEG = new MediaType("image/jpeg");
        HTML = new MediaType("text/html");
        OPDS1 = new MediaType("application/atom+xml;profile=opds-catalog");
        OPDS1_ENTRY = new MediaType("application/atom+xml;type=entry;profile=opds-catalog");
        OPDS2 = new MediaType("application/opds+json");
        OPDS2_PUBLICATION = new MediaType("application/opds-publication+json");
        OPDS_AUTHENTICATION = new MediaType("application/opds-authentication+json");
        JSON = new MediaType("application/json");
        LCP_PROTECTED_AUDIOBOOK = new MediaType("application/audiobook+lcp");
        LCP_PROTECTED_PDF = new MediaType("application/pdf+lcp");
        LCP_LICENSE_DOCUMENT = new MediaType("application/vnd.readium.lcp.license.v1.0+json");
        LCP_STATUS_DOCUMENT = new MediaType("application/vnd.readium.license.status.v1.0+json");
        LPF = new MediaType("application/lpf+zip");
        MP3 = new MediaType("audio/mpeg");
        MPEG = new MediaType("video/mpeg");
        NCX = new MediaType("application/x-dtbncx+xml");
        OGG = new MediaType("audio/ogg");
        OGV = new MediaType("video/ogg");
        OPUS = new MediaType("audio/opus");
        OTF = new MediaType("font/otf");
        PDF = new MediaType("application/pdf");
        PNG = new MediaType("image/png");
        READIUM_AUDIOBOOK = new MediaType("application/audiobook+zip");
        READIUM_AUDIOBOOK_MANIFEST = new MediaType("application/audiobook+json");
        READIUM_WEBPUB = new MediaType("application/webpub+zip");
        READIUM_WEBPUB_MANIFEST = new MediaType("application/webpub+json");
        SMIL = new MediaType("application/smil+xml");
        SVG = new MediaType("image/svg+xml");
        TEXT = new MediaType("text/plain");
        TIFF = new MediaType("image/tiff");
        TTF = new MediaType("font/ttf");
        W3C_WPUB_MANIFEST = new MediaType("application/x.readium.w3c.wpub+json");
        WAV = new MediaType("audio/wav");
        WEBM_AUDIO = new MediaType("audio/webm");
        WEBM_VIDEO = new MediaType("video/webm");
        WEBP = new MediaType("image/webp");
        WOFF = new MediaType("font/woff");
        WOFF2 = new MediaType("font/woff2");
        XHTML = new MediaType("application/xhtml+xml");
        XML = new MediaType("application/xml");
        ZAB = new MediaType("application/x.readium.zab+zip");
        ZIP = new MediaType("application/zip");
    }

    public /* synthetic */ MediaType(String string, DefaultConstructorMarker $constructor_marker) {
        this(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b~\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0006R\u001a\u0010\u000e\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0011\u00103\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0006R\u0011\u00105\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0006R\u0011\u00107\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0006R\u0011\u00109\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0006R\u0011\u0010;\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0006R\u0011\u0010=\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0006R\u0011\u0010?\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0006R\u0011\u0010A\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0006R\u0011\u0010C\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u0006R\u0011\u0010E\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0006R\u0011\u0010G\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0006R\u0011\u0010I\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u0006R\u0011\u0010K\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u0006R\u0011\u0010M\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010\u0006R\u0011\u0010O\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010\u0006R\u0011\u0010Q\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u0006R\u0011\u0010S\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u0006R\u0011\u0010U\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u0006R\u0011\u0010W\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u0006R\u0011\u0010Y\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\u0006R\u0011\u0010[\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010\u0006R\u0011\u0010]\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\u0006R\u0011\u0010_\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010\u0006R\u0011\u0010a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010\u0006R\u0011\u0010c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010\u0006R\u0011\u0010e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010\u0006R\u0011\u0010g\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010\u0006R\u0011\u0010i\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010\u0006R\u0011\u0010k\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010\u0006R\u0011\u0010m\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010\u0006R\u001a\u0010o\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bp\u0010\u0002\u001a\u0004\bq\u0010\u0006R\u001a\u0010r\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bs\u0010\u0002\u001a\u0004\bt\u0010\u0006R\u0011\u0010u\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010\u0006R\u0011\u0010w\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010\u0006R\u0011\u0010y\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bz\u0010\u0006R\u0011\u0010{\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010\u0006R\u0011\u0010}\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b~\u0010\u0006R\u0012\u0010\u007f\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0080\u0001\u0010\u0006\u00a8\u0006\u0084\u0001"}, d2={"Lorg/readium/r2/shared/format/MediaType$Companion;", "", "()V", "AAC", "Lorg/readium/r2/shared/format/MediaType;", "getAAC", "()Lorg/readium/r2/shared/format/MediaType;", "ACSM", "getACSM", "AIFF", "getAIFF", "AUDIOBOOK", "AUDIOBOOK$annotations", "getAUDIOBOOK", "AUDIOBOOK_MANIFEST", "AUDIOBOOK_MANIFEST$annotations", "getAUDIOBOOK_MANIFEST", "AVI", "getAVI", "BINARY", "getBINARY", "BMP", "getBMP", "CBZ", "getCBZ", "CSS", "getCSS", "DIVINA", "getDIVINA", "DIVINA_MANIFEST", "getDIVINA_MANIFEST", "EPUB", "getEPUB", "GIF", "getGIF", "GZ", "getGZ", "HTML", "getHTML", "JAVASCRIPT", "getJAVASCRIPT", "JPEG", "getJPEG", "JSON", "getJSON", "LCP_LICENSE_DOCUMENT", "getLCP_LICENSE_DOCUMENT", "LCP_PROTECTED_AUDIOBOOK", "getLCP_PROTECTED_AUDIOBOOK", "LCP_PROTECTED_PDF", "getLCP_PROTECTED_PDF", "LCP_STATUS_DOCUMENT", "getLCP_STATUS_DOCUMENT", "LPF", "getLPF", "MP3", "getMP3", "MPEG", "getMPEG", "NCX", "getNCX", "OGG", "getOGG", "OGV", "getOGV", "OPDS1", "getOPDS1", "OPDS1_ENTRY", "getOPDS1_ENTRY", "OPDS2", "getOPDS2", "OPDS2_PUBLICATION", "getOPDS2_PUBLICATION", "OPDS_AUTHENTICATION", "getOPDS_AUTHENTICATION", "OPUS", "getOPUS", "OTF", "getOTF", "PDF", "getPDF", "PNG", "getPNG", "READIUM_AUDIOBOOK", "getREADIUM_AUDIOBOOK", "READIUM_AUDIOBOOK_MANIFEST", "getREADIUM_AUDIOBOOK_MANIFEST", "READIUM_WEBPUB", "getREADIUM_WEBPUB", "READIUM_WEBPUB_MANIFEST", "getREADIUM_WEBPUB_MANIFEST", "SMIL", "getSMIL", "SVG", "getSVG", "TEXT", "getTEXT", "TIFF", "getTIFF", "TTF", "getTTF", "W3C_WPUB_MANIFEST", "getW3C_WPUB_MANIFEST", "WAV", "getWAV", "WEBM_AUDIO", "getWEBM_AUDIO", "WEBM_VIDEO", "getWEBM_VIDEO", "WEBP", "getWEBP", "WEBPUB", "WEBPUB$annotations", "getWEBPUB", "WEBPUB_MANIFEST", "WEBPUB_MANIFEST$annotations", "getWEBPUB_MANIFEST", "WOFF", "getWOFF", "WOFF2", "getWOFF2", "XHTML", "getXHTML", "XML", "getXML", "ZAB", "getZAB", "ZIP", "getZIP", "parse", "string", "", "r2-shared_release"})
    public static final class Companion {
        @Nullable
        public final MediaType parse(@NotNull String string) {
            MediaType mediaType;
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            try {
                mediaType = new MediaType(string, null);
            }
            catch (Exception e) {
                mediaType = null;
            }
            return mediaType;
        }

        @NotNull
        public final MediaType getAAC() {
            return AAC;
        }

        @NotNull
        public final MediaType getACSM() {
            return ACSM;
        }

        @NotNull
        public final MediaType getAIFF() {
            return AIFF;
        }

        @NotNull
        public final MediaType getAVI() {
            return AVI;
        }

        @NotNull
        public final MediaType getBINARY() {
            return BINARY;
        }

        @NotNull
        public final MediaType getBMP() {
            return BMP;
        }

        @NotNull
        public final MediaType getCBZ() {
            return CBZ;
        }

        @NotNull
        public final MediaType getCSS() {
            return CSS;
        }

        @NotNull
        public final MediaType getDIVINA() {
            return DIVINA;
        }

        @NotNull
        public final MediaType getDIVINA_MANIFEST() {
            return DIVINA_MANIFEST;
        }

        @NotNull
        public final MediaType getEPUB() {
            return EPUB;
        }

        @NotNull
        public final MediaType getGIF() {
            return GIF;
        }

        @NotNull
        public final MediaType getGZ() {
            return GZ;
        }

        @NotNull
        public final MediaType getJAVASCRIPT() {
            return JAVASCRIPT;
        }

        @NotNull
        public final MediaType getJPEG() {
            return JPEG;
        }

        @NotNull
        public final MediaType getHTML() {
            return HTML;
        }

        @NotNull
        public final MediaType getOPDS1() {
            return OPDS1;
        }

        @NotNull
        public final MediaType getOPDS1_ENTRY() {
            return OPDS1_ENTRY;
        }

        @NotNull
        public final MediaType getOPDS2() {
            return OPDS2;
        }

        @NotNull
        public final MediaType getOPDS2_PUBLICATION() {
            return OPDS2_PUBLICATION;
        }

        @NotNull
        public final MediaType getOPDS_AUTHENTICATION() {
            return OPDS_AUTHENTICATION;
        }

        @NotNull
        public final MediaType getJSON() {
            return JSON;
        }

        @NotNull
        public final MediaType getLCP_PROTECTED_AUDIOBOOK() {
            return LCP_PROTECTED_AUDIOBOOK;
        }

        @NotNull
        public final MediaType getLCP_PROTECTED_PDF() {
            return LCP_PROTECTED_PDF;
        }

        @NotNull
        public final MediaType getLCP_LICENSE_DOCUMENT() {
            return LCP_LICENSE_DOCUMENT;
        }

        @NotNull
        public final MediaType getLCP_STATUS_DOCUMENT() {
            return LCP_STATUS_DOCUMENT;
        }

        @NotNull
        public final MediaType getLPF() {
            return LPF;
        }

        @NotNull
        public final MediaType getMP3() {
            return MP3;
        }

        @NotNull
        public final MediaType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final MediaType getNCX() {
            return NCX;
        }

        @NotNull
        public final MediaType getOGG() {
            return OGG;
        }

        @NotNull
        public final MediaType getOGV() {
            return OGV;
        }

        @NotNull
        public final MediaType getOPUS() {
            return OPUS;
        }

        @NotNull
        public final MediaType getOTF() {
            return OTF;
        }

        @NotNull
        public final MediaType getPDF() {
            return PDF;
        }

        @NotNull
        public final MediaType getPNG() {
            return PNG;
        }

        @NotNull
        public final MediaType getREADIUM_AUDIOBOOK() {
            return READIUM_AUDIOBOOK;
        }

        @NotNull
        public final MediaType getREADIUM_AUDIOBOOK_MANIFEST() {
            return READIUM_AUDIOBOOK_MANIFEST;
        }

        @NotNull
        public final MediaType getREADIUM_WEBPUB() {
            return READIUM_WEBPUB;
        }

        @NotNull
        public final MediaType getREADIUM_WEBPUB_MANIFEST() {
            return READIUM_WEBPUB_MANIFEST;
        }

        @NotNull
        public final MediaType getSMIL() {
            return SMIL;
        }

        @NotNull
        public final MediaType getSVG() {
            return SVG;
        }

        @NotNull
        public final MediaType getTEXT() {
            return TEXT;
        }

        @NotNull
        public final MediaType getTIFF() {
            return TIFF;
        }

        @NotNull
        public final MediaType getTTF() {
            return TTF;
        }

        @NotNull
        public final MediaType getW3C_WPUB_MANIFEST() {
            return W3C_WPUB_MANIFEST;
        }

        @NotNull
        public final MediaType getWAV() {
            return WAV;
        }

        @NotNull
        public final MediaType getWEBM_AUDIO() {
            return WEBM_AUDIO;
        }

        @NotNull
        public final MediaType getWEBM_VIDEO() {
            return WEBM_VIDEO;
        }

        @NotNull
        public final MediaType getWEBP() {
            return WEBP;
        }

        @NotNull
        public final MediaType getWOFF() {
            return WOFF;
        }

        @NotNull
        public final MediaType getWOFF2() {
            return WOFF2;
        }

        @NotNull
        public final MediaType getXHTML() {
            return XHTML;
        }

        @NotNull
        public final MediaType getXML() {
            return XML;
        }

        @NotNull
        public final MediaType getZAB() {
            return ZAB;
        }

        @NotNull
        public final MediaType getZIP() {
            return ZIP;
        }

        @Deprecated(message="Use [READIUM_AUDIOBOOK] instead", replaceWith=@ReplaceWith(imports={}, expression="READIUM_AUDIOBOOK"))
        public static /* synthetic */ void AUDIOBOOK$annotations() {
        }

        @NotNull
        public final MediaType getAUDIOBOOK() {
            return Companion.getREADIUM_AUDIOBOOK();
        }

        @Deprecated(message="Use [READIUM_AUDIOBOOK_MANIFEST] instead", replaceWith=@ReplaceWith(imports={}, expression="READIUM_AUDIOBOOK_MANIFEST"))
        public static /* synthetic */ void AUDIOBOOK_MANIFEST$annotations() {
        }

        @NotNull
        public final MediaType getAUDIOBOOK_MANIFEST() {
            return Companion.getREADIUM_AUDIOBOOK_MANIFEST();
        }

        @Deprecated(message="Use [READIUM_WEBPUB] instead", replaceWith=@ReplaceWith(imports={}, expression="READIUM_WEBPUB"))
        public static /* synthetic */ void WEBPUB$annotations() {
        }

        @NotNull
        public final MediaType getWEBPUB() {
            return Companion.getREADIUM_WEBPUB();
        }

        @Deprecated(message="Use [READIUM_WEBPUB_MANIFEST] instead", replaceWith=@ReplaceWith(imports={}, expression="READIUM_WEBPUB_MANIFEST"))
        public static /* synthetic */ void WEBPUB_MANIFEST$annotations() {
        }

        @NotNull
        public final MediaType getWEBPUB_MANIFEST() {
            return Companion.getREADIUM_WEBPUB_MANIFEST();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

