/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.publication.Contributor;
import org.readium.r2.shared.publication.LocalizedString;
import org.readium.r2.shared.publication.Subject;
import org.readium.r2.streamer.parser.epub.Title;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u000b0\n\u00a2\u0006\u0002\u0010\fJ\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u000b0\nH\u00c6\u0003Jg\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u000b0\nH\u00c6\u0001J\u0013\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0012\u0010;\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\t\u0010<\u001a\u00020\u0017H\u00d6\u0001J\b\u0010=\u001a\u00020>H\u0002J\u0014\u0010?\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020@0\u001bJ\u0014\u0010A\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020@0\u001bJ\u0006\u0010B\u001a\u00020\u0001J\t\u0010C\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020GR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012R\u0016\u0010#\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0012R\u0016\u0010(\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0012R\u0016\u0010+\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0012R\u0016\u0010-\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0012\u00a8\u0006H"}, d2={"Lorg/readium/r2/streamer/parser/epub/MetadataItem;", "", "property", "", "value", "lang", "scheme", "refines", "id", "children", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "alternateScript", "getAlternateScript", "()Ljava/util/Map;", "authority", "getAuthority", "()Ljava/lang/String;", "getChildren", "collectionType", "getCollectionType", "displaySeq", "", "getDisplaySeq", "()Ljava/lang/Integer;", "fileAs", "Lkotlin/Pair;", "getFileAs", "()Lkotlin/Pair;", "groupPosition", "", "getGroupPosition", "()Ljava/lang/Double;", "getId", "identifier", "getIdentifier", "getLang", "getProperty", "getRefines", "role", "getRole", "getScheme", "term", "getTerm", "titleType", "getTitleType", "getValue", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "firstValue", "hashCode", "localizedString", "Lorg/readium/r2/shared/publication/LocalizedString;", "toCollection", "Lorg/readium/r2/shared/publication/Contributor;", "toContributor", "toMap", "toString", "toSubject", "Lorg/readium/r2/shared/publication/Subject;", "toTitle", "Lorg/readium/r2/streamer/parser/epub/Title;", "streamer_release"})
public final class MetadataItem {
    @NotNull
    private final String property;
    @NotNull
    private final String value;
    @NotNull
    private final String lang;
    @Nullable
    private final String scheme;
    @Nullable
    private final String refines;
    @Nullable
    private final String id;
    @NotNull
    private final Map<String, List<MetadataItem>> children;

    public MetadataItem(@NotNull String property, @NotNull String value, @NotNull String lang, @Nullable String scheme, @Nullable String refines, @Nullable String id, @NotNull Map<String, ? extends List<MetadataItem>> children) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.property = property;
        this.value = value;
        this.lang = lang;
        this.scheme = scheme;
        this.refines = refines;
        this.id = id;
        this.children = children;
    }

    public /* synthetic */ MetadataItem(String string, String string2, String string3, String string4, String string5, String string6, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, string2, string3, string4, string5, string6, map);
    }

    @NotNull
    public final String getProperty() {
        return this.property;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String getLang() {
        return this.lang;
    }

    @Nullable
    public final String getScheme() {
        return this.scheme;
    }

    @Nullable
    public final String getRefines() {
        return this.refines;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Map<String, List<MetadataItem>> getChildren() {
        return this.children;
    }

    @NotNull
    public final Subject toSubject() {
        LocalizedString localizedString;
        if (!Intrinsics.areEqual((Object)this.property, (Object)"http://purl.org/dc/terms/subject")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        LocalizedString values = this.localizedString();
        Pair<String, String> pair = this.getFileAs();
        if (pair == null) {
            localizedString = null;
        } else {
            Pair<String, String> it = pair;
            boolean bl = false;
            localizedString = new LocalizedString((String)it.getSecond(), (String)it.getFirst());
        }
        LocalizedString localizedSortAs = localizedString;
        return new Subject(values, localizedSortAs, this.getAuthority(), this.getTerm(), null, 16, null);
    }

    @NotNull
    public final Title toTitle() {
        LocalizedString localizedString;
        if (!Intrinsics.areEqual((Object)this.property, (Object)"http://purl.org/dc/terms/title")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        LocalizedString values = this.localizedString();
        Pair<String, String> pair = this.getFileAs();
        if (pair == null) {
            localizedString = null;
        } else {
            Pair<String, String> it = pair;
            boolean bl = false;
            localizedString = new LocalizedString((String)it.getSecond(), (String)it.getFirst());
        }
        LocalizedString localizedSortAs = localizedString;
        return new Title(values, localizedSortAs, this.getTitleType(), this.getDisplaySeq());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String, Contributor> toContributor() {
        String string;
        String string2;
        Set set;
        Set set2;
        Object it;
        LocalizedString localizedString;
        void $this$mapTo$iv$iv;
        Object[] objectArray = new String[]{"creator", "contributor", "publisher"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.stringPlus((String)"http://purl.org/dc/terms/", (Object)it2));
        }
        if (!CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)"http://www.idpf.org/epub/vocab/overlays/#narrator"), (Object)"http://idpf.org/epub/vocab/package/meta/#belongs-to-collection").contains(this.property)) {
            String $i$f$map2 = "Failed requirement.";
            throw new IllegalArgumentException($i$f$map2.toString());
        }
        Object[] $i$f$map2 = new String[]{"aut", "trl", "edt", "pbl", "art", "ill", "clr", "nrt"};
        Set knownRoles = SetsKt.setOf((Object[])$i$f$map2);
        LocalizedString names = this.localizedString();
        Pair<String, String> pair = this.getFileAs();
        if (pair == null) {
            localizedString = null;
        } else {
            it = pair;
            boolean bl = false;
            localizedString = new LocalizedString((String)it.getSecond(), (String)it.getFirst());
        }
        LocalizedString localizedSortAs = localizedString;
        it = this.getRole();
        Object it3 = it;
        boolean bl = false;
        Object object = !CollectionsKt.contains((Iterable)knownRoles, it3) ? it : null;
        if (object == null) {
            set2 = null;
        } else {
            it3 = object;
            boolean bl2 = false;
            set2 = set = SetsKt.setOf(it3);
        }
        if (set2 == null) {
            set = SetsKt.emptySet();
        }
        Set roles = set;
        switch (this.property) {
            case "http://idpf.org/epub/vocab/package/meta/#belongs-to-collection": {
                string2 = this.getCollectionType();
                break;
            }
            case "http://purl.org/dc/terms/creator": {
                string2 = "aut";
                break;
            }
            case "http://purl.org/dc/terms/publisher": {
                string2 = "pbl";
                break;
            }
            case "http://www.idpf.org/epub/vocab/overlays/#narrator": {
                string2 = "nrt";
                break;
            }
            default: {
                String it4 = string = this.getRole();
                boolean bl3 = false;
                string2 = CollectionsKt.contains((Iterable)knownRoles, (Object)it4) ? string : null;
            }
        }
        String type = string2;
        string = this.getIdentifier();
        Double d = this.getGroupPosition();
        Contributor contributor = new Contributor(names, localizedSortAs, string, roles, d, null, 32, null);
        return new Pair((Object)type, (Object)contributor);
    }

    @NotNull
    public final Pair<String, Contributor> toCollection() {
        return this.toContributor();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object toMap() {
        Object object;
        if (this.children.isEmpty()) {
            object = this.value;
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = CollectionsKt.flatten((Iterable)this.children.values());
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                MetadataItem it = (MetadataItem)element$iv$iv;
                boolean bl = false;
                Pair pair = new Pair((Object)it.getProperty(), it.toMap());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map mappedChildren = destination$iv$iv;
            object = MapsKt.plus((Map)mappedChildren, (Pair)new Pair((Object)"@value", (Object)this.value));
        }
        return object;
    }

    private final Pair<String, String> getFileAs() {
        Pair pair;
        List<MetadataItem> list = this.children.get("http://idpf.org/epub/vocab/package/meta/#file-as");
        if (list == null) {
            pair = null;
        } else {
            MetadataItem metadataItem = (MetadataItem)CollectionsKt.firstOrNull(list);
            if (metadataItem == null) {
                pair = null;
            } else {
                String string;
                MetadataItem it = metadataItem;
                boolean bl = false;
                String it2 = string = it.getLang();
                boolean bl2 = false;
                String string2 = it.getValue();
                String string3 = !Intrinsics.areEqual((Object)it2, (Object)"") ? string : null;
                pair = new Pair((Object)string3, (Object)string2);
            }
        }
        return pair;
    }

    private final String getTitleType() {
        return this.firstValue("http://idpf.org/epub/vocab/package/meta/#title-type");
    }

    private final Integer getDisplaySeq() {
        String string = this.firstValue("http://idpf.org/epub/vocab/package/meta/#display-seq");
        return string == null ? null : StringsKt.toIntOrNull((String)string);
    }

    private final String getAuthority() {
        return this.firstValue("http://idpf.org/epub/vocab/package/meta/#authority");
    }

    private final String getTerm() {
        return this.firstValue("http://idpf.org/epub/vocab/package/meta/#term");
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getAlternateScript() {
        Map map;
        List<MetadataItem> list = this.children.get("http://idpf.org/epub/vocab/package/meta/#alternate-script");
        if (list == null) {
            map = null;
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = list;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                MetadataItem it = (MetadataItem)element$iv$iv;
                boolean bl = false;
                Pair pair = new Pair((Object)it.getLang(), (Object)it.getValue());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        }
        Map map3 = map;
        if (map == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    private final String getCollectionType() {
        return this.firstValue("http://idpf.org/epub/vocab/package/meta/#collection-type");
    }

    private final Double getGroupPosition() {
        String string = this.firstValue("http://idpf.org/epub/vocab/package/meta/#group-position");
        return string == null ? null : StringsKt.toDoubleOrNull((String)string);
    }

    private final String getIdentifier() {
        return this.firstValue("http://purl.org/dc/terms/identifier");
    }

    private final String getRole() {
        return this.firstValue("http://idpf.org/epub/vocab/package/meta/#role");
    }

    private final LocalizedString localizedString() {
        String string;
        String it = string = this.lang;
        boolean bl = false;
        Map values = MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)(!Intrinsics.areEqual((Object)it, (Object)"") ? string : null), (Object)this.value)), this.getAlternateScript());
        return LocalizedString.Companion.fromStrings(values);
    }

    private final String firstValue(String property) {
        String string;
        List<MetadataItem> list = this.children.get(property);
        if (list == null) {
            string = null;
        } else {
            MetadataItem metadataItem = (MetadataItem)CollectionsKt.firstOrNull(list);
            string = metadataItem == null ? null : metadataItem.value;
        }
        return string;
    }

    @NotNull
    public final String component1() {
        return this.property;
    }

    @NotNull
    public final String component2() {
        return this.value;
    }

    @NotNull
    public final String component3() {
        return this.lang;
    }

    @Nullable
    public final String component4() {
        return this.scheme;
    }

    @Nullable
    public final String component5() {
        return this.refines;
    }

    @Nullable
    public final String component6() {
        return this.id;
    }

    @NotNull
    public final Map<String, List<MetadataItem>> component7() {
        return this.children;
    }

    @NotNull
    public final MetadataItem copy(@NotNull String property, @NotNull String value, @NotNull String lang, @Nullable String scheme, @Nullable String refines, @Nullable String id, @NotNull Map<String, ? extends List<MetadataItem>> children) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new MetadataItem(property, value, lang, scheme, refines, id, children);
    }

    public static /* synthetic */ MetadataItem copy$default(MetadataItem metadataItem, String string, String string2, String string3, String string4, String string5, String string6, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = metadataItem.property;
        }
        if ((n & 2) != 0) {
            string2 = metadataItem.value;
        }
        if ((n & 4) != 0) {
            string3 = metadataItem.lang;
        }
        if ((n & 8) != 0) {
            string4 = metadataItem.scheme;
        }
        if ((n & 0x10) != 0) {
            string5 = metadataItem.refines;
        }
        if ((n & 0x20) != 0) {
            string6 = metadataItem.id;
        }
        if ((n & 0x40) != 0) {
            map = metadataItem.children;
        }
        return metadataItem.copy(string, string2, string3, string4, string5, string6, map);
    }

    @NotNull
    public String toString() {
        return "MetadataItem(property=" + this.property + ", value=" + this.value + ", lang=" + this.lang + ", scheme=" + this.scheme + ", refines=" + this.refines + ", id=" + this.id + ", children=" + this.children + ')';
    }

    public int hashCode() {
        int result = this.property.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + this.lang.hashCode();
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.refines == null ? 0 : this.refines.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + ((Object)this.children).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetadataItem)) {
            return false;
        }
        MetadataItem metadataItem = (MetadataItem)other;
        if (!Intrinsics.areEqual((Object)this.property, (Object)metadataItem.property)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)metadataItem.value)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lang, (Object)metadataItem.lang)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)metadataItem.scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.refines, (Object)metadataItem.refines)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)metadataItem.id)) {
            return false;
        }
        return Intrinsics.areEqual(this.children, metadataItem.children);
    }
}

