/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.pdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.fetcher.Resource;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Locator;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.shared.publication.services.PositionsService;
import org.readium.r2.shared.util.mediatype.MediaType;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010R'\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService;", "Lorg/readium/r2/shared/publication/services/PositionsService;", "link", "Lorg/readium/r2/shared/publication/Link;", "pageCount", "", "tableOfContents", "", "(Lorg/readium/r2/shared/publication/Link;ILjava/util/List;)V", "_positions", "Lorg/readium/r2/shared/publication/Locator;", "get_positions", "()Ljava/util/List;", "_positions$delegate", "Lkotlin/Lazy;", "positionsByReadingOrder", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "streamer_release"})
public final class PdfPositionsService
implements PositionsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Link link;
    private final int pageCount;
    @NotNull
    private final List<Link> tableOfContents;
    @NotNull
    private final Lazy _positions$delegate;

    public PdfPositionsService(@NotNull Link link, int pageCount, @NotNull List<Link> tableOfContents) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(tableOfContents, (String)"tableOfContents");
        this.link = link;
        this.pageCount = pageCount;
        this.tableOfContents = tableOfContents;
        this._positions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends List<? extends Locator>>>(this){
            final /* synthetic */ PdfPositionsService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<List<Locator>> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (PdfPositionsService.access$getPageCount$p(this.this$0) <= 0) {
                    Timber.e((String)Intrinsics.stringPlus((String)"Invalid page count for a PDF document: ", (Object)PdfPositionsService.access$getPageCount$p(this.this$0)), (Object[])new Object[0]);
                    return CollectionsKt.listOf((Object)CollectionsKt.emptyList());
                }
                Iterable iterable = (Iterable)new IntRange(1, PdfPositionsService.access$getPageCount$p(this.this$0));
                PdfPositionsService pdfPositionsService = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void position;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    double progression = (double)(position - true) / (double)PdfPositionsService.access$getPageCount$p(pdfPositionsService);
                    Object object = PdfPositionsService.access$getLink$p(pdfPositionsService).getType();
                    Object object2 = object == null ? MediaType.Companion.getPDF().toString() : object;
                    object = CollectionsKt.listOf((Object)Intrinsics.stringPlus((String)"page=", (Object)((int)position)));
                    Locator locator = new Locator(PdfPositionsService.access$getLink$p(pdfPositionsService).getHref(), (String)object2, null, new Locator.Locations((List)object, Double.valueOf(progression), Integer.valueOf((int)position), Double.valueOf(progression), null, 16, null), null, 20, null);
                    collection.add(locator);
                }
                return CollectionsKt.listOf((Object)((List)destination$iv$iv));
            }
        }));
    }

    @Nullable
    public Object positionsByReadingOrder(@NotNull Continuation<? super List<? extends List<Locator>>> $completion) {
        return this.get_positions();
    }

    private final List<List<Locator>> get_positions() {
        Lazy lazy = this._positions$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public void close() {
        PositionsService.DefaultImpls.close((PositionsService)this);
    }

    @Nullable
    public Resource get(@NotNull Link link) {
        return PositionsService.DefaultImpls.get((PositionsService)this, (Link)link);
    }

    @NotNull
    public List<Link> getLinks() {
        return PositionsService.DefaultImpls.getLinks((PositionsService)this);
    }

    @Nullable
    public Object positions(@NotNull Continuation<? super List<Locator>> $completion) {
        return PositionsService.DefaultImpls.positions((PositionsService)this, $completion);
    }

    public static final /* synthetic */ int access$getPageCount$p(PdfPositionsService $this) {
        return $this.pageCount;
    }

    public static final /* synthetic */ Link access$getLink$p(PdfPositionsService $this) {
        return $this.link;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService$Companion;", "", "()V", "create", "Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService;", "context", "Lorg/readium/r2/shared/publication/Publication$Service$Context;", "streamer_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PdfPositionsService create(@NotNull Publication.Service.Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = (Link)CollectionsKt.firstOrNull((List)context.getManifest().getReadingOrder());
            if (object == null) {
                return null;
            }
            Link link = object;
            object = context.getManifest().getMetadata().getNumberOfPages();
            return new PdfPositionsService(link, object == null ? 0 : (Integer)object, context.getManifest().getTableOfContents());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

