/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.InternalReadiumApi;
import org.readium.r2.shared.extensions.InputStreamKt;
import org.readium.r2.shared.extensions.LongRangeKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/readium/r2/shared/util/io/CountingInputStream;", "Ljava/io/FilterInputStream;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "<set-?>", "", "count", "getCount", "()J", "mark", "", "readlimit", "", "read", "b", "", "off", "len", "readRange", "range", "Lkotlin/ranges/LongRange;", "reset", "skip", "n", "readium-shared_release"})
@InternalReadiumApi
public final class CountingInputStream
extends FilterInputStream {
    private long count;
    private long mark;

    public CountingInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream);
        this.mark = -1L;
    }

    public final long getCount() {
        return this.count;
    }

    @Override
    public int read() {
        int n;
        int it = n = super.read();
        boolean bl = false;
        if (it != -1) {
            long l = this.count;
            this.count = l + 1L;
        }
        return n;
    }

    @Override
    public int read(@Nullable byte[] b, int off, int len) {
        int n;
        int readLen = n = super.read(b, off, len);
        boolean bl = false;
        if (readLen != -1) {
            this.count += (long)readLen;
        }
        return n;
    }

    @Override
    public long skip(long n) {
        long l;
        long it = l = super.skip(n);
        boolean bl = false;
        this.count += it;
        return l;
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.count;
    }

    @Override
    public void reset() {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        super.reset();
        this.count = RangesKt.coerceAtLeast((long)this.mark, (long)0L);
    }

    @NotNull
    public final byte[] readRange(@NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        LongRange range2 = LongRangeKt.requireLengthFitInt(LongRangeKt.coerceFirstNonNegative(range));
        if (range2.isEmpty()) {
            return new byte[0];
        }
        this.skip(range2.getFirst() - this.count);
        long length2 = range2.getLast() - range2.getFirst() + 1L;
        return InputStreamKt.read(this, length2);
    }
}

