/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.InternalReadiumApi;
import org.readium.r2.shared.util.http.HttpRange;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003H\u00c6\u0003J%\u0010\u0016\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00052\u0006\u0010\u001a\u001a\u00020\u0004J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/readium/r2/shared/util/http/HttpHeaders;", "", "headers", "", "", "", "(Ljava/util/Map;)V", "acceptsByteRanges", "", "getAcceptsByteRanges", "()Z", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getHeaders", "()Ljava/util/Map;", "range", "Lorg/readium/r2/shared/util/http/HttpRange;", "getRange", "()Lorg/readium/r2/shared/util/http/HttpRange;", "component1", "copy", "equals", "other", "get", "name", "getAll", "hashCode", "", "toString", "Companion", "readium-shared_release"})
@InternalReadiumApi
public final class HttpHeaders {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, List<String>> headers;

    public HttpHeaders(@NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.headers = headers;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Nullable
    public final String get(@NotNull String name) {
        String string2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string3 = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String n = string3;
            for (Map.Entry<String, List<String>> entry2 : this.headers.entrySet()) {
                boolean bl = false;
                String key = entry2.getKey();
                List<String> value = entry2.getValue();
                String string4 = key.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String object2 = Intrinsics.areEqual((Object)string4, (Object)n) ? (String)CollectionsKt.firstOrNull(value) : null;
                if (object2 == null) continue;
                string2 = object2;
                break block1;
            }
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAll(@NotNull String name) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String n = string2;
        Map<String, List<String>> $this$mapNotNull$iv = this.headers;
        boolean $i$f$mapNotNull = false;
        Map<String, List<String>> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            List it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry2 = element$iv$iv;
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            List value = (List)entry2.getValue();
            String string3 = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if ((Intrinsics.areEqual((Object)string3, (Object)n) ? value : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getAcceptsByteRanges() {
        String string2;
        String string3 = this.get("Accept-Ranges");
        if (string3 != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string2 = null;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"bytes")) return true;
        String string5 = this.get("Content-Range");
        String string6 = string5;
        if (string5 == null) return false;
        String string7 = string6.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        string6 = string7;
        if (string7 == null) return false;
        if (!StringsKt.startsWith$default((String)string6, (String)"bytes", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public final Long getContentLength() {
        Long l;
        Long l2;
        String string2 = this.get("Content-Length");
        if (string2 != null && (l2 = StringsKt.toLongOrNull((String)string2)) != null) {
            Long l3 = l2;
            long it = ((Number)l3).longValue();
            boolean bl = false;
            l = it >= 0L ? l3 : null;
        } else {
            l = null;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final HttpRange getRange() {
        Iterable iterable;
        block8: {
            block7: {
                List list;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String[] stringArray;
                String string2 = this.get("Range");
                if (string2 == null) {
                    return null;
                }
                String rangeRequest = string2;
                if (!StringsKt.startsWith$default((String)rangeRequest, (String)"bytes=", (boolean)false, (int)2, null)) {
                    return null;
                }
                Object object = new String[]{","};
                String string3 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)rangeRequest, (CharSequence)"bytes="), (String[])object, (boolean)false, (int)0, (int)6, null));
                if (string3 == null || (object = StringsKt.split$default((CharSequence)string3, (String[])(stringArray = new String[]{"-"}), (boolean)false, (int)2, (int)2, null)) == null) break block7;
                iterable = (Iterable)object;
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string4 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(StringsKt.toLongOrNull((String)it));
                }
                List it = list = (List)destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = iterable = !((Collection)it).isEmpty() ? list : null;
                if (iterable != null) break block8;
            }
            return null;
        }
        Iterable components = iterable;
        Long l = (Long)CollectionsKt.first((List)components);
        if (l == null) {
            return null;
        }
        return new HttpRange(l, (Long)CollectionsKt.getOrNull((List)components, (int)1));
    }

    @NotNull
    public final Map<String, List<String>> component1() {
        return this.headers;
    }

    @NotNull
    public final HttpHeaders copy(@NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return new HttpHeaders(headers);
    }

    public static /* synthetic */ HttpHeaders copy$default(HttpHeaders httpHeaders, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = httpHeaders.headers;
        }
        return httpHeaders.copy(map2);
    }

    @NotNull
    public String toString() {
        return "HttpHeaders(headers=" + this.headers + ')';
    }

    public int hashCode() {
        return ((Object)this.headers).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeaders)) {
            return false;
        }
        HttpHeaders httpHeaders = (HttpHeaders)other;
        return Intrinsics.areEqual(this.headers, httpHeaders.headers);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/readium/r2/shared/util/http/HttpHeaders$Companion;", "", "()V", "invoke", "Lorg/readium/r2/shared/util/http/HttpHeaders;", "headers", "", "", "readium-shared_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HttpHeaders invoke(@NotNull Map<String, String> headers) {
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Map<String, String> $this$mapValues$iv = headers;
            boolean $i$f$mapValues = false;
            Map<String, String> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                String value = (String)entry3.getValue();
                List list = CollectionsKt.listOf((Object)value);
                map4.put(k, list);
            }
            Map map5 = destination$iv$iv;
            return new HttpHeaders(map5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

