/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util;

import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u0017\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\n\u0010\fR\u001b\u0010\u0002\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/readium/r2/shared/util/Language;", "", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "code", "", "(Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "isRegional", "", "()Z", "isRegional$delegate", "Lkotlin/Lazy;", "getLocale", "()Ljava/util/Locale;", "locale$delegate", "equals", "other", "hashCode", "", "removeRegion", "toString", "Companion", "Serializer", "readium-shared_release"})
public final class Language {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String code;
    @NotNull
    private final Lazy locale$delegate;
    @NotNull
    private final Lazy isRegional$delegate;

    public Language(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = StringsKt.replace$default((String)code, (String)"_", (String)"-", (boolean)false, (int)4, null);
        this.locale$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Locale>(code){
            final /* synthetic */ String $code;
            {
                this.$code = $code;
                super(0);
            }

            public final Locale invoke() {
                return Locale.forLanguageTag(this.$code);
            }
        }));
        this.isRegional$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Language this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                String string2 = this.this$0.getLocale().getCountry();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locale.country");
                return ((CharSequence)string2).length() > 0;
            }
        }));
    }

    public Language(@NotNull Locale locale2) {
        Intrinsics.checkNotNullParameter((Object)locale2, (String)"locale");
        String string2 = locale2.toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locale.toLanguageTag()");
        this(string2);
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final Locale getLocale() {
        Lazy lazy = this.locale$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-locale>(...)");
        return (Locale)object;
    }

    public final boolean isRegional() {
        Lazy lazy = this.isRegional$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Language removeRegion() {
        String[] stringArray = new String[]{"-"};
        return new Language((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)this.code, (String[])stringArray, (boolean)false, (int)2, (int)2, null)));
    }

    @NotNull
    public String toString() {
        return "Language(" + this.code + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.readium.r2.shared.util.Language");
        return Intrinsics.areEqual((Object)this.code, (Object)((Language)other).code);
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/readium/r2/shared/util/Language$Serializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/readium/r2/shared/util/Language;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "readium-shared_release"})
    public static final class Serializer
    implements KSerializer<Language> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();
        @NotNull
        private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"Language", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

        private Serializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        public void serialize(@NotNull Encoder encoder, @NotNull Language value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            encoder.encodeString(value.getCode());
        }

        @NotNull
        public Language deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return new Language(decoder.decodeString());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/readium/r2/shared/util/Language$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/readium/r2/shared/util/Language;", "readium-shared_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Language> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

