/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util;

import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.webkit.URLUtil;
import java.net.IDN;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.extensions.StringKt;
import timber.log.Timber;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0010\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010\u0011\u001a\u00020\u0003*\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/readium/r2/shared/util/Href;", "", "href", "", "baseHref", "(Ljava/lang/String;Ljava/lang/String;)V", "percentEncodedString", "getPercentEncodedString", "()Ljava/lang/String;", "queryParameters", "", "Lorg/readium/r2/shared/util/Href$QueryParameter;", "getQueryParameters", "()Ljava/util/List;", "string", "getString", "percentEncodedPath", "removePercentEncoding", "QueryParameter", "readium-shared_release"})
public final class Href {
    @NotNull
    private final String href;
    @NotNull
    private final String baseHref;

    public Href(@NotNull String href, @NotNull String baseHref) {
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        Intrinsics.checkNotNullParameter((Object)baseHref, (String)"baseHref");
        this.href = href;
        this.baseHref = ((CharSequence)baseHref).length() == 0 ? "/" : baseHref;
    }

    public /* synthetic */ Href(String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string3 = "/";
        }
        this(string2, string3);
    }

    @NotNull
    public final String getString() {
        int n;
        String baseHref = this.removePercentEncoding(this.baseHref);
        String href = this.removePercentEncoding(this.href);
        if (StringsKt.isBlank((CharSequence)href) || StringsKt.startsWith$default((String)href, (String)"#", (boolean)false, (int)2, null)) {
            return baseHref + href;
        }
        if (Uri.parse((String)href).isAbsolute()) {
            return href;
        }
        Integer n2 = StringsKt.indexOf$default((CharSequence)href, (String)"?", (int)0, (boolean)false, (int)6, null);
        int it2 = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it2 != -1 ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            Integer it2 = StringsKt.indexOf$default((CharSequence)href, (String)"#", (int)0, (boolean)false, (int)6, null);
            int it3 = ((Number)it2).intValue();
            boolean bl2 = false;
            Integer n4 = it3 != -1 ? it2 : null;
            n = n4 != null ? n4 : StringsKt.getLastIndex((CharSequence)href) + 1;
        }
        int splitIndex = n;
        String string2 = href.substring(0, splitIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String path = string2;
        String string3 = href.substring(splitIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String suffix = string3;
        try {
            String string4;
            URI uri = URI.create(this.percentEncodedPath(baseHref)).resolve(this.percentEncodedPath(path));
            StringBuilder stringBuilder = new StringBuilder();
            if (URLUtil.isNetworkUrl((String)uri.toString())) {
                string4 = uri.toString();
            } else {
                String string5 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"uri.path");
                string4 = StringKt.addPrefix(string5, "/");
            }
            String url = stringBuilder.append(string4).append(suffix).toString();
            return this.removePercentEncoding(url);
        }
        catch (Exception e) {
            Timber.Forest.e((Throwable)e);
            return baseHref + '/' + href;
        }
    }

    @NotNull
    public final String getPercentEncodedString() {
        String string2;
        String string3 = this.getString();
        if (StringsKt.startsWith$default((String)string3, (String)"/", (boolean)false, (int)2, null)) {
            string3 = StringKt.addPrefix(string3, "file://");
        }
        try {
            URL url = new URL(string3);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), IDN.toASCII(url.getHost()), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            String string4 = uri.toASCIIString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"uri.toASCIIString()");
            string2 = StringsKt.removePrefix((String)string4, (CharSequence)"file://");
        }
        catch (Exception e) {
            Timber.Forest.e((Throwable)e);
            string2 = this.getString();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<QueryParameter> getQueryParameters() {
        void $this$mapTo$iv$iv;
        String url = StringsKt.substringBefore$default((String)this.getPercentEncodedString(), (String)"#", null, (int)2, null);
        List list = new UrlQuerySanitizer(url).getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"UrlQuerySanitizer(url).parameterList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2;
            void it;
            String string3;
            void p;
            UrlQuerySanitizer.ParameterValuePair parameterValuePair = (UrlQuerySanitizer.ParameterValuePair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)p.mParameter, (String)"p.mParameter");
            String string4 = string3 = p.mValue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            boolean bl3 = StringsKt.isBlank((CharSequence)((CharSequence)it));
            String string5 = !bl3 ? string3 : null;
            String string6 = string2;
            collection.add(new QueryParameter(string6, string5));
        }
        return (List)destination$iv$iv;
    }

    private final String percentEncodedPath(String $this$percentEncodedPath) {
        String string2 = Uri.encode((String)$this$percentEncodedPath, (String)"$&+,/:=@");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(this, \"$&+,/:=@\")");
        return string2;
    }

    private final String removePercentEncoding(String $this$removePercentEncoding) {
        String string2;
        String it = string2 = Uri.decode((String)$this$removePercentEncoding);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String string3 = !StringsKt.contains$default((CharSequence)it, (CharSequence)"\ufffd", (boolean)false, (int)2, null) ? string2 : null;
        if (string3 == null) {
            string3 = $this$removePercentEncoding;
        }
        return string3;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/shared/util/Href$QueryParameter;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "readium-shared_release"})
    public static final class QueryParameter {
        @NotNull
        private final String name;
        @Nullable
        private final String value;

        public QueryParameter(@NotNull String name, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final QueryParameter copy(@NotNull String name, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new QueryParameter(name, value);
        }

        public static /* synthetic */ QueryParameter copy$default(QueryParameter queryParameter, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = queryParameter.name;
            }
            if ((n & 2) != 0) {
                string3 = queryParameter.value;
            }
            return queryParameter.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "QueryParameter(name=" + this.name + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QueryParameter)) {
                return false;
            }
            QueryParameter queryParameter = (QueryParameter)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)queryParameter.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)queryParameter.value);
        }
    }
}

