/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.publication.services.content;

import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.ExperimentalReadiumApi;
import org.readium.r2.shared.fetcher.Resource;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Locator;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.shared.publication.services.content.Content;
import org.readium.r2.shared.publication.services.content.ContentService;
import org.readium.r2.shared.publication.services.content.iterators.PublicationContentIterator;
import org.readium.r2.shared.util.Ref;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016Bf\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012N\u0010\u0005\u001aJ\u0012F\u0012D\b\u0001\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00070\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RY\u0010\u0005\u001aJ\u0012F\u0012D\b\u0001\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00070\u0006X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lorg/readium/r2/shared/publication/services/content/DefaultContentService;", "Lorg/readium/r2/shared/publication/services/content/ContentService;", "publication", "Lorg/readium/r2/shared/util/Ref;", "Lorg/readium/r2/shared/publication/Publication;", "resourceContentIteratorFactories", "", "Lkotlin/Function3;", "Lorg/readium/r2/shared/fetcher/Resource;", "Lkotlin/ParameterName;", "name", "resource", "Lorg/readium/r2/shared/publication/Locator;", "locator", "Lkotlin/coroutines/Continuation;", "Lorg/readium/r2/shared/publication/services/content/Content$Iterator;", "", "(Lorg/readium/r2/shared/util/Ref;Ljava/util/List;)V", "content", "Lorg/readium/r2/shared/publication/services/content/Content;", "start", "Companion", "ContentImpl", "readium-shared_release"})
@ExperimentalReadiumApi
public final class DefaultContentService
implements ContentService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ref<Publication> publication;
    @NotNull
    private final List<Function3<Resource, Locator, Continuation<? super Content.Iterator>, Object>> resourceContentIteratorFactories;

    public DefaultContentService(@NotNull Ref<Publication> publication, @NotNull List<? extends Function3<? super Resource, ? super Locator, ? super Continuation<? super Content.Iterator>, ? extends Object>> resourceContentIteratorFactories) {
        Intrinsics.checkNotNullParameter(publication, (String)"publication");
        Intrinsics.checkNotNullParameter(resourceContentIteratorFactories, (String)"resourceContentIteratorFactories");
        this.publication = publication;
        this.resourceContentIteratorFactories = resourceContentIteratorFactories;
    }

    @Override
    @NotNull
    public Content content(@Nullable Locator start) {
        Publication publication = this.publication.invoke();
        if (publication == null) {
            throw new IllegalStateException("No Publication object");
        }
        Publication publication2 = publication;
        return new ContentImpl(publication2, start);
    }

    @Override
    @NotNull
    public List<Link> getLinks() {
        return ContentService.DefaultImpls.getLinks(this);
    }

    @Override
    @Nullable
    public Resource get(@NotNull Link link2) {
        return ContentService.DefaultImpls.get(this, link2);
    }

    @Override
    public void close() {
        ContentService.DefaultImpls.close(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042N\u0010\u0007\u001aJ\u0012F\u0012D\b\u0001\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\b\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/shared/publication/services/content/DefaultContentService$Companion;", "", "()V", "createFactory", "Lkotlin/Function1;", "Lorg/readium/r2/shared/publication/Publication$Service$Context;", "Lorg/readium/r2/shared/publication/services/content/DefaultContentService;", "resourceContentIteratorFactories", "", "Lkotlin/Function3;", "Lorg/readium/r2/shared/fetcher/Resource;", "Lkotlin/ParameterName;", "name", "resource", "Lorg/readium/r2/shared/publication/Locator;", "locator", "Lkotlin/coroutines/Continuation;", "Lorg/readium/r2/shared/publication/services/content/Content$Iterator;", "readium-shared_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Publication.Service.Context, DefaultContentService> createFactory(@NotNull List<? extends Function3<? super Resource, ? super Locator, ? super Continuation<? super Content.Iterator>, ? extends Object>> resourceContentIteratorFactories) {
            Intrinsics.checkNotNullParameter(resourceContentIteratorFactories, (String)"resourceContentIteratorFactories");
            return (Function1)new Function1<Publication.Service.Context, DefaultContentService>(resourceContentIteratorFactories){
                final /* synthetic */ List<Function3<Resource, Locator, Continuation<? super Content.Iterator>, Object>> $resourceContentIteratorFactories;
                {
                    this.$resourceContentIteratorFactories = $resourceContentIteratorFactories;
                    super(1);
                }

                @NotNull
                public final DefaultContentService invoke(@NotNull Publication.Service.Context context) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    return new DefaultContentService(context.getPublication(), this.$resourceContentIteratorFactories);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/readium/r2/shared/publication/services/content/DefaultContentService$ContentImpl;", "Lorg/readium/r2/shared/publication/services/content/Content;", "publication", "Lorg/readium/r2/shared/publication/Publication;", "start", "Lorg/readium/r2/shared/publication/Locator;", "(Lorg/readium/r2/shared/publication/services/content/DefaultContentService;Lorg/readium/r2/shared/publication/Publication;Lorg/readium/r2/shared/publication/Locator;)V", "getPublication", "()Lorg/readium/r2/shared/publication/Publication;", "getStart", "()Lorg/readium/r2/shared/publication/Locator;", "iterator", "Lorg/readium/r2/shared/publication/services/content/Content$Iterator;", "readium-shared_release"})
    private final class ContentImpl
    implements Content {
        @NotNull
        private final Publication publication;
        @Nullable
        private final Locator start;

        public ContentImpl(@Nullable Publication publication, Locator start) {
            Intrinsics.checkNotNullParameter((Object)publication, (String)"publication");
            this.publication = publication;
            this.start = start;
        }

        @NotNull
        public final Publication getPublication() {
            return this.publication;
        }

        @Nullable
        public final Locator getStart() {
            return this.start;
        }

        @Override
        @NotNull
        public Content.Iterator iterator() {
            return new PublicationContentIterator(this.publication, this.start, DefaultContentService.this.resourceContentIteratorFactories);
        }

        @Override
        @Nullable
        public Object text(@NotNull String separator, @NotNull Continuation<? super String> $completion) {
            return Content.DefaultImpls.text(this, separator, $completion);
        }

        @Override
        @Nullable
        public Object elements(@NotNull Continuation<? super List<? extends Content.Element>> $completion) {
            return Content.DefaultImpls.elements(this, $completion);
        }
    }
}

