/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.publication.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.readium.r2.shared.UserException;
import org.readium.r2.shared.extensions.JSONKt;
import org.readium.r2.shared.extensions.StringKt;
import org.readium.r2.shared.fetcher.FailureResource;
import org.readium.r2.shared.fetcher.Resource;
import org.readium.r2.shared.fetcher.StringResource;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.services.ContentProtectionService;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H&J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH&J\u0011\u0010\r\u001a\u0004\u0018\u00010\b*\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler;", "", "()V", "link", "Lorg/readium/r2/shared/publication/Link;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "acceptRequest", "", "handleRequest", "Lorg/readium/r2/shared/fetcher/Resource;", "service", "Lorg/readium/r2/shared/publication/services/ContentProtectionService;", "toBooleanOrNull", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "toJSON", "Lorg/json/JSONObject;", "Lorg/readium/r2/shared/publication/services/ContentProtectionService$UserRights;", "Companion", "ContentProtectionHandler", "RightsCopyHandler", "RightsPrintHandler", "Lorg/readium/r2/shared/publication/services/RouteHandler$ContentProtectionHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler$RightsCopyHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler$RightsPrintHandler;", "readium-shared_release"})
abstract class RouteHandler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final List<RouteHandler> handlers;
    @NotNull
    private static final List<Link> links;

    private RouteHandler() {
    }

    @NotNull
    public abstract Link getLink();

    public abstract boolean acceptRequest(@NotNull Link var1);

    @NotNull
    public abstract Resource handleRequest(@NotNull Link var1, @NotNull ContentProtectionService var2);

    @Nullable
    public final Boolean toBooleanOrNull(@NotNull String $this$toBooleanOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toBooleanOrNull, (String)"<this>");
        String string2 = $this$toBooleanOrNull;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String string4 = string3;
        return Intrinsics.areEqual((Object)string4, (Object)"true") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)string4, (Object)"false") ? Boolean.valueOf(false) : null);
    }

    @NotNull
    public final JSONObject toJSON(@NotNull ContentProtectionService.UserRights $this$toJSON) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)$this$toJSON, (String)"<this>");
        JSONObject $this$toJSON_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$toJSON_u24lambda_u240.put("canCopy", $this$toJSON.getCanCopy());
        $this$toJSON_u24lambda_u240.put("canPrint", $this$toJSON.getCanPrint());
        return jSONObject;
    }

    public /* synthetic */ RouteHandler(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new RouteHandler[]{ContentProtectionHandler.INSTANCE, RightsCopyHandler.INSTANCE, RightsPrintHandler.INSTANCE};
        handlers = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = handlers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RouteHandler routeHandler = (RouteHandler)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLink());
        }
        links = (List)var3_3;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler$Companion;", "", "()V", "handlers", "", "Lorg/readium/r2/shared/publication/services/RouteHandler;", "links", "Lorg/readium/r2/shared/publication/Link;", "getLinks", "()Ljava/util/List;", "route", "link", "readium-shared_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Link> getLinks() {
            return links;
        }

        @Nullable
        public final RouteHandler route(@NotNull Link link2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
                Iterable $this$firstOrNull$iv = handlers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RouteHandler it = (RouteHandler)element$iv;
                    boolean bl = false;
                    if (!it.acceptRequest(link2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler$ContentProtectionHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler;", "()V", "link", "Lorg/readium/r2/shared/publication/Link;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "acceptRequest", "", "handleRequest", "Lorg/readium/r2/shared/fetcher/Resource;", "service", "Lorg/readium/r2/shared/publication/services/ContentProtectionService;", "readium-shared_release"})
    public static final class ContentProtectionHandler
    extends RouteHandler {
        @NotNull
        public static final ContentProtectionHandler INSTANCE = new ContentProtectionHandler();
        @NotNull
        private static final Link link = new Link("/~readium/content-protection", "application/vnd.readium.content-protection+json", false, null, null, null, null, null, null, null, null, null, null, 8188, null);

        private ContentProtectionHandler() {
            super(null);
        }

        @Override
        @NotNull
        public Link getLink() {
            return link;
        }

        @Override
        public boolean acceptRequest(@NotNull Link link2) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            return Intrinsics.areEqual((Object)link2.getHref(), (Object)this.getLink().getHref());
        }

        @Override
        @NotNull
        public Resource handleRequest(@NotNull Link link2, @NotNull ContentProtectionService service) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            return new StringResource(link2, (Function1<? super Continuation<? super String>, ? extends Object>)((Function1)new Function1<Continuation<? super String>, Object>(service, null){
                int label;
                final /* synthetic */ ContentProtectionService $service;
                {
                    this.$service = $service;
                    super(1, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            JSONObject jSONObject = new JSONObject();
                            ContentProtectionService contentProtectionService = this.$service;
                            JSONObject $this$invokeSuspend_u24lambda_u240 = jSONObject;
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u240.put("isRestricted", contentProtectionService.isRestricted());
                            UserException userException = contentProtectionService.getError();
                            $this$invokeSuspend_u24lambda_u240.putOpt("error", (Object)(userException != null ? userException.getLocalizedMessage() : null));
                            JSONKt.putIfNotEmpty($this$invokeSuspend_u24lambda_u240, "name", contentProtectionService.getName());
                            $this$invokeSuspend_u24lambda_u240.put("rights", (Object)ContentProtectionHandler.INSTANCE.toJSON(contentProtectionService.getRights()));
                            String string2 = jSONObject.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JSONObject().apply {\n   \u2026             }.toString()");
                            return string2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super String> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler$RightsCopyHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler;", "()V", "link", "Lorg/readium/r2/shared/publication/Link;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "acceptRequest", "", "handleRequest", "Lorg/readium/r2/shared/fetcher/Resource;", "service", "Lorg/readium/r2/shared/publication/services/ContentProtectionService;", "readium-shared_release"})
    public static final class RightsCopyHandler
    extends RouteHandler {
        @NotNull
        public static final RightsCopyHandler INSTANCE = new RightsCopyHandler();
        @NotNull
        private static final Link link = new Link("/~readium/rights/copy{?text,peek}", "application/vnd.readium.rights.copy+json", true, null, null, null, null, null, null, null, null, null, null, 8184, null);

        private RightsCopyHandler() {
            super(null);
        }

        @Override
        @NotNull
        public Link getLink() {
            return link;
        }

        @Override
        public boolean acceptRequest(@NotNull Link link2) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            return StringsKt.startsWith$default((String)link2.getHref(), (String)"/~readium/rights/copy", (boolean)false, (int)2, null);
        }

        @Override
        @NotNull
        public Resource handleRequest(@NotNull Link link2, @NotNull ContentProtectionService service) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            Map<String, String> parameters2 = StringKt.queryParameters(link2.getHref());
            String string2 = parameters2.get("text");
            if (string2 == null) {
                return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("'text' parameter is required")));
            }
            String text2 = string2;
            String string3 = parameters2.get("peek");
            if (string3 == null) {
                string3 = "false";
            }
            Boolean bl = this.toBooleanOrNull(string3);
            if (bl == null) {
                return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("if present, 'peek' must be true or false")));
            }
            boolean peek = bl;
            ContentProtectionService.UserRights $this$handleRequest_u24lambda_u240 = service.getRights();
            boolean bl2 = false;
            boolean copyAllowed = peek ? $this$handleRequest_u24lambda_u240.canCopy(text2) : $this$handleRequest_u24lambda_u240.copy(text2);
            return !copyAllowed ? (Resource)new FailureResource(link2, new Resource.Exception.Forbidden(null, 1, null)) : (Resource)new StringResource(link2, "true");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler$RightsPrintHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler;", "()V", "link", "Lorg/readium/r2/shared/publication/Link;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "acceptRequest", "", "handleRequest", "Lorg/readium/r2/shared/fetcher/Resource;", "service", "Lorg/readium/r2/shared/publication/services/ContentProtectionService;", "readium-shared_release"})
    public static final class RightsPrintHandler
    extends RouteHandler {
        @NotNull
        public static final RightsPrintHandler INSTANCE = new RightsPrintHandler();
        @NotNull
        private static final Link link = new Link("/~readium/rights/print{?pageCount,peek}", "application/vnd.readium.rights.print+json", true, null, null, null, null, null, null, null, null, null, null, 8184, null);

        private RightsPrintHandler() {
            super(null);
        }

        @Override
        @NotNull
        public Link getLink() {
            return link;
        }

        @Override
        public boolean acceptRequest(@NotNull Link link2) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            return StringsKt.startsWith$default((String)link2.getHref(), (String)"/~readium/rights/print", (boolean)false, (int)2, null);
        }

        @Override
        @NotNull
        public Resource handleRequest(@NotNull Link link2, @NotNull ContentProtectionService service) {
            Integer n;
            Map<String, String> parameters2;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    parameters2 = StringKt.queryParameters(link2.getHref());
                    String string2 = parameters2.get("pageCount");
                    if (string2 == null) {
                        return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("'pageCount' parameter is required")));
                    }
                    String pageCountString = string2;
                    n = StringsKt.toIntOrNull((String)pageCountString);
                    if (n == null) break block6;
                    Integer n2 = n;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    n = it >= 0 ? n2 : null;
                    if (n != null) break block7;
                }
                return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("'pageCount' must be a positive integer")));
            }
            int pageCount = n;
            String string3 = parameters2.get("peek");
            if (string3 == null) {
                string3 = "false";
            }
            Boolean bl = this.toBooleanOrNull(string3);
            if (bl == null) {
                return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("if present, 'peek' must be true or false")));
            }
            boolean peek = bl;
            ContentProtectionService.UserRights $this$handleRequest_u24lambda_u241 = service.getRights();
            boolean bl2 = false;
            boolean printAllowed = peek ? $this$handleRequest_u24lambda_u241.canPrint(pageCount) : $this$handleRequest_u24lambda_u241.print(pageCount);
            return !printAllowed ? (Resource)new FailureResource(link2, new Resource.Exception.Forbidden(null, 1, null)) : (Resource)new StringResource(link2, "true");
        }
    }
}

