/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util.http;

import android.content.Context;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.readium.r2.shared.R;
import org.readium.r2.shared.UserException;
import org.readium.r2.shared.util.http.ProblemDetails;
import org.readium.r2.shared.util.mediatype.MediaType;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/readium/r2/shared/util/http/HttpException;", "Lorg/readium/r2/shared/UserException;", "kind", "Lorg/readium/r2/shared/util/http/HttpException$Kind;", "mediaType", "Lorg/readium/r2/shared/util/mediatype/MediaType;", "body", "", "cause", "", "(Lorg/readium/r2/shared/util/http/HttpException$Kind;Lorg/readium/r2/shared/util/mediatype/MediaType;[BLjava/lang/Throwable;)V", "getBody", "()[B", "getKind", "()Lorg/readium/r2/shared/util/http/HttpException$Kind;", "getMediaType", "()Lorg/readium/r2/shared/util/mediatype/MediaType;", "problemDetails", "Lorg/readium/r2/shared/util/http/ProblemDetails;", "getProblemDetails", "()Lorg/readium/r2/shared/util/http/ProblemDetails;", "problemDetails$delegate", "Lkotlin/Lazy;", "getLocalizedMessage", "", "getUserMessage", "context", "Landroid/content/Context;", "includesCauses", "", "Companion", "Kind", "shared_release"})
public final class HttpException
extends UserException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Kind kind;
    @Nullable
    private final MediaType mediaType;
    @Nullable
    private final byte[] body;
    @NotNull
    private final Lazy problemDetails$delegate;
    @NotNull
    private static final HttpException CANCELLED = new HttpException(Kind.Cancelled, null, null, null, 14, null);

    public HttpException(@NotNull Kind kind, @Nullable MediaType mediaType2, @Nullable byte[] body2, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        super(kind.getUserMessageId(), new Object[0], cause);
        this.kind = kind;
        this.mediaType = mediaType2;
        this.body = body2;
        this.problemDetails$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProblemDetails>(this){
            final /* synthetic */ HttpException this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ProblemDetails invoke() {
                ProblemDetails problemDetails2;
                block5: {
                    block4: {
                        if (this.this$0.getBody() == null) break block4;
                        MediaType mediaType2 = this.this$0.getMediaType();
                        if (mediaType2 == null ? false : mediaType2.matches(MediaType.Companion.getJSON_PROBLEM_DETAILS())) break block5;
                    }
                    return null;
                }
                HttpException httpException = this.this$0;
                boolean $i$f$tryOrLog = false;
                try {
                    boolean bl = false;
                    problemDetails2 = ProblemDetails.Companion.fromJSON$default(ProblemDetails.Companion, new JSONObject(new String(httpException.getBody(), Charsets.UTF_8)), null, 2, null);
                }
                catch (Exception e$iv) {
                    Timber.Forest.e((Throwable)e$iv);
                    problemDetails2 = null;
                }
                return problemDetails2;
            }
        }));
    }

    public /* synthetic */ HttpException(Kind kind, MediaType mediaType2, byte[] byArray, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mediaType2 = null;
        }
        if ((n & 4) != 0) {
            byArray = null;
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        this(kind, mediaType2, byArray, throwable);
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @Nullable
    public final MediaType getMediaType() {
        return this.mediaType;
    }

    @Nullable
    public final byte[] getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public String getUserMessage(@NotNull Context context, boolean includesCauses) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProblemDetails problemDetails2 = this.getProblemDetails();
        if (problemDetails2 != null) {
            ProblemDetails error = problemDetails2;
            boolean bl = false;
            String message = error.getTitle();
            if (error.getDetail() != null) {
                message = message + '\n' + error.getDetail();
            }
            return message;
        }
        return super.getUserMessage(context, includesCauses);
    }

    @Override
    @Nullable
    public String getLocalizedMessage() {
        String message = null;
        message = Intrinsics.stringPlus((String)"HTTP error: ", (Object)this.kind.name());
        ProblemDetails problemDetails2 = this.getProblemDetails();
        if (problemDetails2 != null) {
            ProblemDetails details = problemDetails2;
            boolean bl = false;
            message = message + ": " + details.getTitle() + ' ' + details.getDetail();
        }
        return message;
    }

    @Nullable
    public final ProblemDetails getProblemDetails() {
        Lazy lazy = this.problemDetails$delegate;
        return (ProblemDetails)lazy.getValue();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\b\u0086\u0001\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lorg/readium/r2/shared/util/http/HttpException$Kind;", "", "userMessageId", "", "(Ljava/lang/String;II)V", "getUserMessageId", "()I", "MalformedRequest", "MalformedResponse", "Timeout", "BadRequest", "Unauthorized", "Forbidden", "NotFound", "ClientError", "ServerError", "Offline", "Cancelled", "Other", "Companion", "shared_release"})
    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        public static final Companion Companion;
        private final int userMessageId;
        public static final /* enum */ Kind MalformedRequest;
        public static final /* enum */ Kind MalformedResponse;
        public static final /* enum */ Kind Timeout;
        public static final /* enum */ Kind BadRequest;
        public static final /* enum */ Kind Unauthorized;
        public static final /* enum */ Kind Forbidden;
        public static final /* enum */ Kind NotFound;
        public static final /* enum */ Kind ClientError;
        public static final /* enum */ Kind ServerError;
        public static final /* enum */ Kind Offline;
        public static final /* enum */ Kind Cancelled;
        public static final /* enum */ Kind Other;
        private static final /* synthetic */ Kind[] $VALUES;

        private Kind(int userMessageId) {
            this.userMessageId = userMessageId;
        }

        public final int getUserMessageId() {
            return this.userMessageId;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value) {
            return Enum.valueOf(Kind.class, value);
        }

        static {
            MalformedRequest = new Kind(R.string.r2_shared_http_exception_malformed_request);
            MalformedResponse = new Kind(R.string.r2_shared_http_exception_malformed_response);
            Timeout = new Kind(R.string.r2_shared_http_exception_timeout);
            BadRequest = new Kind(R.string.r2_shared_http_exception_bad_request);
            Unauthorized = new Kind(R.string.r2_shared_http_exception_unauthorized);
            Forbidden = new Kind(R.string.r2_shared_http_exception_forbidden);
            NotFound = new Kind(R.string.r2_shared_http_exception_not_found);
            ClientError = new Kind(R.string.r2_shared_http_exception_client_error);
            ServerError = new Kind(R.string.r2_shared_http_exception_server_error);
            Offline = new Kind(R.string.r2_shared_http_exception_offline);
            Cancelled = new Kind(R.string.r2_shared_http_exception_cancelled);
            Other = new Kind(R.string.r2_shared_http_exception_other);
            $VALUES = kindArray = new Kind[]{Kind.MalformedRequest, Kind.MalformedResponse, Kind.Timeout, Kind.BadRequest, Kind.Unauthorized, Kind.Forbidden, Kind.NotFound, Kind.ClientError, Kind.ServerError, Kind.Offline, Kind.Cancelled, Kind.Other};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/readium/r2/shared/util/http/HttpException$Kind$Companion;", "", "()V", "ofStatusCode", "Lorg/readium/r2/shared/util/http/HttpException$Kind;", "statusCode", "", "shared_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Kind ofStatusCode(int statusCode) {
                Kind kind;
                block1: {
                    int n;
                    block5: {
                        block4: {
                            block3: {
                                block2: {
                                    block0: {
                                        n = statusCode;
                                        boolean bl = 200 <= n ? n < 400 : false;
                                        if (!bl) break block0;
                                        kind = null;
                                        break block1;
                                    }
                                    if (n != 400) break block2;
                                    kind = BadRequest;
                                    break block1;
                                }
                                if (n != 401) break block3;
                                kind = Unauthorized;
                                break block1;
                            }
                            if (n != 403) break block4;
                            kind = Forbidden;
                            break block1;
                        }
                        if (n != 404) break block5;
                        kind = NotFound;
                        break block1;
                    }
                    kind = (405 <= n ? n < 499 : false) ? ClientError : (n == 499 ? Cancelled : ((500 <= n ? n < 600 : false) ? ServerError : MalformedResponse));
                }
                return kind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/readium/r2/shared/util/http/HttpException$Companion;", "", "()V", "CANCELLED", "Lorg/readium/r2/shared/util/http/HttpException;", "getCANCELLED", "()Lorg/readium/r2/shared/util/http/HttpException;", "invoke", "statusCode", "", "mediaType", "Lorg/readium/r2/shared/util/mediatype/MediaType;", "body", "", "wrap", "cause", "", "shared_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpException getCANCELLED() {
            return CANCELLED;
        }

        @Nullable
        public final HttpException invoke(int statusCode, @Nullable MediaType mediaType2, @Nullable byte[] body2) {
            HttpException httpException;
            Kind kind = Kind.Companion.ofStatusCode(statusCode);
            if (kind == null) {
                httpException = null;
            } else {
                Kind kind2 = kind;
                boolean bl = false;
                httpException = new HttpException(kind2, mediaType2, body2, null, 8, null);
            }
            return httpException;
        }

        public static /* synthetic */ HttpException invoke$default(Companion companion, int n, MediaType mediaType2, byte[] byArray, int n2, Object object) {
            if ((n2 & 2) != 0) {
                mediaType2 = null;
            }
            if ((n2 & 4) != 0) {
                byArray = null;
            }
            return companion.invoke(n, mediaType2, byArray);
        }

        @NotNull
        public final HttpException wrap(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            Throwable throwable = cause;
            if (throwable instanceof HttpException) {
                return (HttpException)cause;
            }
            Kind kind = throwable instanceof MalformedURLException ? Kind.MalformedRequest : (throwable instanceof CancellationException ? Kind.Cancelled : (throwable instanceof SocketTimeoutException ? Kind.Timeout : Kind.Other));
            return new HttpException(kind, null, null, cause, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

