/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.solver;

import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.optimizer.Pattern;
import org.apache.jena.sparql.engine.optimizer.StatsMatcher;
import org.apache.jena.sparql.engine.optimizer.reorder.PatternElements;
import org.apache.jena.sparql.engine.optimizer.reorder.PatternTriple;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformationSubstitution;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.Item;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdtjena.HDTGraph;

public class ReorderTransformationHDT
extends ReorderTransformationSubstitution {
    public static final int MultiTermMax = 100;
    public static final int MultiTermSampleSize = 10000;
    final long TERM_S;
    final long TERM_P;
    final long TERM_O;
    final long numTriples;
    private final GraphStatisticsHandler stats;
    public final StatsMatcher matcher = new StatsMatcher();

    public ReorderTransformationHDT(HDTGraph graph) {
        this.stats = graph.getStatisticsHandler();
        this.numTriples = graph.size();
        this.initializeMatcher();
        Dictionary dict = graph.getHDT().getDictionary();
        this.TERM_S = dict.getNsubjects() / Math.max(this.numTriples, 1L);
        this.TERM_P = dict.getNpredicates() / Math.max(this.numTriples, 1L);
        this.TERM_O = dict.getNobjects() / Math.max(this.numTriples, 1L);
    }

    private void initializeMatcher() {
        Item type = Item.createNode((Node)NodeConst.nodeRDFType);
        this.matcher.addPattern(new Pattern(5.0, PatternElements.TERM, PatternElements.TERM, PatternElements.VAR));
        this.matcher.addPattern(new Pattern(1000.0, PatternElements.VAR, type, PatternElements.TERM));
        this.matcher.addPattern(new Pattern(90.0, PatternElements.VAR, PatternElements.TERM, PatternElements.TERM));
        this.matcher.addPattern(new Pattern(5.0, PatternElements.TERM, PatternElements.VAR, PatternElements.TERM));
        this.matcher.addPattern(new Pattern(40.0, PatternElements.TERM, PatternElements.VAR, PatternElements.VAR));
        this.matcher.addPattern(new Pattern(200.0, PatternElements.VAR, PatternElements.VAR, PatternElements.TERM));
        this.matcher.addPattern(new Pattern(2000.0, PatternElements.VAR, PatternElements.TERM, PatternElements.VAR));
        this.matcher.addPattern(new Pattern(10000.0, PatternElements.VAR, PatternElements.VAR, PatternElements.VAR));
    }

    protected double weight(PatternTriple pt) {
        if (pt.subject.isNode() && pt.predicate.isNode() && pt.object.isNode()) {
            return this.stats.getStatistic(pt.subject.getNode(), pt.predicate.getNode(), pt.object.getNode());
        }
        double x = this.matcher.match(pt);
        if (x < 100.0) {
            return x;
        }
        long S = -1L;
        long P = -1L;
        long O = -1L;
        if (pt.subject.isNode() && !pt.subject.isVar()) {
            S = this.stats.getStatistic(pt.subject.getNode(), Node.ANY, Node.ANY);
        } else if (PatternElements.TERM.equals((Object)pt.subject)) {
            S = this.TERM_S;
        }
        if (pt.predicate.isNode() && !pt.predicate.isVar()) {
            P = this.stats.getStatistic(Node.ANY, pt.predicate.getNode(), Node.ANY);
        } else if (PatternElements.TERM.equals((Object)pt.predicate)) {
            P = this.TERM_P;
        }
        if (pt.object.isNode() && !pt.object.isVar()) {
            O = this.stats.getStatistic(Node.ANY, Node.ANY, pt.object.getNode());
        } else if (PatternElements.TERM.equals((Object)pt.object)) {
            O = this.TERM_O;
        }
        if (S == 0L || P == 0L || O == 0L) {
            return 0.0;
        }
        x = -1.0;
        if (S > 0L) {
            x = S;
        }
        if (P > 0L && (double)P < x) {
            x = P;
        }
        if (O > 0L && (double)O < x) {
            x = O;
        }
        return x;
    }
}

