/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.solver;

import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.util.Context;
import org.rdfhdt.hdtjena.solver.OptimizedCount;

public class HDTQueryEngine
extends QueryEngineMain {
    protected Query hdtQuery;
    protected DatasetGraph hdtDataset;
    protected Binding hdtBinding;
    protected Context hdtContext;
    static final QueryEngineFactory factory = new HDTQueryEngineFactory();

    public HDTQueryEngine(Query query, DatasetGraph dataset, Binding input, Context context) {
        super(query, dataset, input, context);
        this.hdtQuery = query;
        this.hdtDataset = dataset;
        this.hdtBinding = input;
        this.hdtContext = context;
    }

    public HDTQueryEngine(Op op, DatasetGraph dataset, Binding input, Context context) {
        super(op, dataset, input, context);
    }

    protected Plan createPlan() {
        Plan plan = OptimizedCount.getPlan(this, this.hdtQuery, this.hdtDataset, this.hdtBinding, this.hdtContext);
        if (plan != null) {
            return plan;
        }
        return super.createPlan();
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    static class HDTQueryEngineFactory
    implements QueryEngineFactory {
        HDTQueryEngineFactory() {
        }

        public boolean accept(Query query, DatasetGraph dataset, Context context) {
            return true;
        }

        public Plan create(Query query, DatasetGraph dataset, Binding initial, Context context) {
            HDTQueryEngine engine = new HDTQueryEngine(query, dataset, initial, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return false;
        }

        public Plan create(Op op, DatasetGraph dataset, Binding inputBinding, Context context) {
            throw new ARQInternalErrorException("HDTQueryEngine: factory called directly with an algebra expression");
        }
    }
}

