/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena.cache;

import org.apache.jena.graph.Node;
import org.rdfhdt.hdtjena.cache.DictionaryCache;

public class DictionaryCacheArray
implements DictionaryCache {
    private Node[] array = null;
    final int capacity;
    long numentries = 0L;

    public DictionaryCacheArray(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public Node get(long id) {
        if (this.array == null) {
            return null;
        }
        if (id > (long)this.array.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[(int)(id - 1L)];
    }

    @Override
    public void put(long id, Node node) {
        if (this.array == null) {
            this.array = new Node[this.capacity];
        }
        if (this.array[(int)(id - 1L)] == null) {
            ++this.numentries;
        }
        this.array[(int)(id - 1L)] = node;
    }

    @Override
    public long size() {
        return this.numentries;
    }

    @Override
    public void clear() {
        this.array = null;
    }
}

