/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdtjena;

import java.io.IOException;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdtjena.HDTGraph;
import org.rdfhdt.hdtjena.HDTJenaConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDTGraphAssembler
extends AssemblerBase
implements Assembler {
    private static final Logger log = LoggerFactory.getLogger(HDTGraphAssembler.class);
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        Assembler.general.implementWith(HDTJenaConstants.tGraphHDT, (Assembler)new HDTGraphAssembler());
    }

    public Model open(Assembler a, Resource root, Mode mode) {
        String file = GraphUtils.getStringValue((Resource)root, (Property)HDTJenaConstants.pFileName);
        boolean loadInMemory = Boolean.parseBoolean(GraphUtils.getStringValue((Resource)root, (Property)HDTJenaConstants.pKeepInMemory));
        try {
            HDT hdt = loadInMemory ? HDTManager.loadIndexedHDT((String)file, null) : HDTManager.mapIndexedHDT((String)file, null);
            HDTGraph graph = new HDTGraph(hdt);
            return ModelFactory.createModelForGraph((Graph)graph);
        }
        catch (IOException e) {
            log.error("Error reading HDT file: {}", (Object)file, (Object)e);
            throw new AssemblerException(root, "Error reading HDT file: " + file + " / " + e.toString());
        }
    }

    static {
        HDTGraphAssembler.init();
    }
}

