/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples;

import java.io.IOException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.util.UnicodeEscape;

public class TripleString {
    private CharSequence subject;
    private CharSequence predicate;
    private CharSequence object;

    public TripleString() {
        this.object = null;
        this.predicate = null;
        this.subject = null;
    }

    public TripleString(CharSequence subject, CharSequence predicate, CharSequence object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public TripleString(TripleString other) {
        this.subject = other.subject;
        this.predicate = other.predicate;
        this.object = other.object;
    }

    public CharSequence getSubject() {
        return this.subject;
    }

    public void setSubject(CharSequence subject) {
        this.subject = subject;
    }

    public CharSequence getPredicate() {
        return this.predicate;
    }

    public void setPredicate(CharSequence predicate) {
        this.predicate = predicate;
    }

    public CharSequence getObject() {
        return this.object;
    }

    public void setObject(CharSequence object) {
        this.object = object;
    }

    public void setAll(CharSequence subject, CharSequence predicate, CharSequence object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    private boolean equalsCharSequence(CharSequence cs1, CharSequence cs2) {
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        for (int i = 0; i < cs1.length(); ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof TripleString) {
            TripleString ts = (TripleString)other;
            return this.equalsCharSequence(this.subject, ts.subject) && this.equalsCharSequence(this.predicate, ts.predicate) && this.equalsCharSequence(this.object, ts.object);
        }
        return false;
    }

    public int hashCode() {
        int s = this.subject == null ? 0 : this.subject.hashCode();
        int p = this.predicate == null ? 0 : this.predicate.hashCode();
        int o = this.object == null ? 0 : this.object.hashCode();
        return 31 * (31 * (31 * s) + p) + o;
    }

    public boolean match(TripleString pattern) {
        return !(pattern.getSubject().length() != 0 && !this.equalsCharSequence(pattern.getSubject(), this.subject) || pattern.getPredicate().length() != 0 && !this.equalsCharSequence(pattern.getPredicate(), this.predicate) || pattern.getObject().length() != 0 && !this.equalsCharSequence(pattern.getObject(), this.object));
    }

    public void clear() {
        this.object = "";
        this.predicate = "";
        this.subject = "";
    }

    public boolean isEmpty() {
        return this.subject.length() == 0 && this.predicate.length() == 0 && this.object.length() == 0;
    }

    public boolean hasEmpty() {
        return this.subject.length() == 0 || this.predicate.length() == 0 || this.object.length() == 0;
    }

    public void read(String line) throws ParserException {
        this.read(line, 0, line.length());
    }

    private int searchNextTabOrSpace(String line, int start, int end) {
        int sindex = line.indexOf(32, start);
        if (sindex != -1 && sindex < end) {
            return sindex;
        }
        int tindex = line.indexOf(9, start);
        if (tindex != -1 && tindex < end) {
            return tindex;
        }
        return -1;
    }

    public void read(String line, int start, int end) throws ParserException {
        char prev;
        int split;
        this.clear();
        int posa = start;
        int posb = split = this.searchNextTabOrSpace(line, posa, end);
        if (posb == -1) {
            return;
        }
        if (line.charAt(posa) == '<') {
            ++posa;
            if (line.charAt(posb - 1) == '>') {
                --posb;
            }
        }
        this.setSubject(UnicodeEscape.unescapeString(line, posa, posb));
        posa = split + 1;
        posb = split = this.searchNextTabOrSpace(line, posa, end);
        if (posb == -1) {
            return;
        }
        if (line.charAt(posa) == '<' && posb > ++posa && line.charAt(posb - 1) == '>') {
            --posb;
        }
        this.setPredicate(UnicodeEscape.unescapeString(line, posa, posb));
        posa = split + 1;
        posb = end;
        if (line.charAt(posb - 1) == '.') {
            --posb;
        }
        if ((prev = line.charAt(posb - 1)) == ' ' || prev == '\t') {
            --posb;
        }
        if (line.charAt(posa) == '<' && posb > ++posa && line.charAt(posb - 1) == '>') {
            --posb;
        }
        this.setObject(UnicodeEscape.unescapeString(line, posa, posb));
    }

    public String toString() {
        return this.subject + " " + this.predicate + " " + this.object;
    }

    public CharSequence asNtriple() throws IOException {
        StringBuilder str = new StringBuilder();
        this.dumpNtriple(str);
        return str;
    }

    public final void dumpNtriple(Appendable out) throws IOException {
        char s0 = this.subject.charAt(0);
        if (s0 == '_' || s0 == '<') {
            out.append(this.subject);
        } else {
            out.append('<').append(this.subject).append('>');
        }
        char p0 = this.predicate.charAt(0);
        if (p0 == '<') {
            out.append(' ').append(this.predicate).append(' ');
        } else {
            out.append(" <").append(this.predicate).append("> ");
        }
        char o0 = this.object.charAt(0);
        if (o0 == '\"') {
            UnicodeEscape.escapeString(this.object.toString(), out);
            out.append(" .\n");
        } else if (o0 == '_' || o0 == '<') {
            out.append(this.object).append(" .\n");
        } else {
            out.append('<').append(this.object).append("> .\n");
        }
    }
}

