/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli.libloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.meteogroup.jbrotli.libloader.ARCH;
import org.meteogroup.jbrotli.libloader.LoaderResult;
import org.meteogroup.jbrotli.libloader.OS;

class LibraryLoader {
    private final String libName;
    private final LoaderResult loaderResult = new LoaderResult();

    LibraryLoader(String libName) {
        this.libName = libName;
    }

    boolean trySystemLibraryLoading() {
        try {
            Runtime.getRuntime().loadLibrary(this.libName);
            this.loaderResult.setLoadedFromSystemLibraryPath(true);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            this.loaderResult.setLoadedFromSystemLibraryPath(false);
            return false;
        }
    }

    boolean tryLoadingFromTemporaryFolder() throws SecurityException, IllegalStateException {
        File tempFolder;
        String nativeLibName = System.mapLibraryName(this.libName);
        this.loaderResult.setNativeLibName(nativeLibName);
        try {
            tempFolder = Files.createTempDirectory(this.libName, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create temporary folder. Make sure you have a temp. folder with write access available.", e);
        }
        File libFile = new File(tempFolder, nativeLibName);
        this.loaderResult.setTemporaryLibFile(libFile.getAbsolutePath());
        String libNameWithinClasspath = "/lib/" + this.determineOsArchName() + "/" + nativeLibName;
        this.loaderResult.setLibNameWithinClasspath(libNameWithinClasspath);
        try {
            this.loaderResult.setUsedThisClassloader(this.copyStreamToFile(this.getClass().getResourceAsStream(libNameWithinClasspath), libFile.toPath()));
            if (!this.loaderResult.isUsedThisClassloader()) {
                this.loaderResult.setUsedSystemClassloader(this.copyStreamToFile(ClassLoader.getSystemClassLoader().getResourceAsStream(libNameWithinClasspath), libFile.toPath()));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't write to " + libFile, e);
        }
        libFile.deleteOnExit();
        if (this.loaderResult.isUsedThisClassloader() || this.loaderResult.isUsedSystemClassloader()) {
            this.loaderResult.setMadeReadable(libFile.setReadable(true));
            this.loaderResult.setMadeExecutable(libFile.setExecutable(true));
            Runtime.getRuntime().load(libFile.getAbsolutePath());
            return true;
        }
        return false;
    }

    private boolean copyStreamToFile(InputStream inputStream, Path targetPath) throws IOException {
        if (inputStream == null) {
            return false;
        }
        Files.copy(inputStream, targetPath, new CopyOption[0]);
        inputStream.close();
        return true;
    }

    LoaderResult getResult() {
        return this.loaderResult;
    }

    private String determineOsArchName() {
        return this.determineOS() + "-" + this.determineArch();
    }

    private String determineOS() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS.LINUX.matches(osName)) {
            return OS.LINUX.name;
        }
        if (OS.WIN32.matches(osName)) {
            return OS.WIN32.name;
        }
        if (OS.OSX.matches(osName)) {
            return OS.OSX.name;
        }
        return osName;
    }

    private String determineArch() {
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.US);
        if (ARCH.X86_AMD64.matches(osArch)) {
            return ARCH.X86_AMD64.name;
        }
        if (ARCH.X86.matches(osArch)) {
            return ARCH.X86.name;
        }
        if (ARCH.ARM32_VFP_HFLT.matches(osArch)) {
            return ARCH.ARM32_VFP_HFLT.name;
        }
        return osArch;
    }
}

