/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.meteogroup.jbrotli.BrotliStreamDeCompressor;
import org.meteogroup.jbrotli.DeCompressorResult;

public class BrotliInputStream
extends InputStream {
    static final int INTERNAL_UNCOMPRESSED_BUFFER_SIZE = 65536;
    private final BrotliStreamDeCompressor brotliStreamDeCompressor;
    private final InputStream inputStream;
    private InputStream uncompressedInputStreamDelegate = new ByteArrayInputStream(new byte[0]);
    private boolean isEndOfInputStream = false;

    public BrotliInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.brotliStreamDeCompressor = new BrotliStreamDeCompressor();
    }

    @Override
    public int read() throws IOException {
        if (this.uncompressedInputStreamDelegate.available() == 0) {
            this.readChunkFromInput();
        }
        return this.uncompressedInputStreamDelegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return this.isEndOfInputStream && this.uncompressedInputStreamDelegate.available() == 0 ? 0 : 1 + this.uncompressedInputStreamDelegate.available();
    }

    @Override
    public void close() throws IOException {
        this.brotliStreamDeCompressor.close();
        this.inputStream.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Sorry, but skip() isn't supported by this BrotliInputStream implementation.");
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("Sorry, but mark() isn't supported by this BrotliInputStream implementation.");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("Sorry, but reset() isn't supported by this BrotliInputStream implementation.");
    }

    private void readChunkFromInput() throws IOException {
        byte[] uncompressedBuffer = new byte[65536];
        if (this.brotliStreamDeCompressor.needsMoreOutput()) {
            DeCompressorResult result = this.brotliStreamDeCompressor.deCompress(new byte[0], uncompressedBuffer);
            assert (result.bytesConsumed == 0);
            this.uncompressedInputStreamDelegate = new ByteArrayInputStream(uncompressedBuffer, 0, result.bytesProduced);
            return;
        }
        byte[] in = new byte[16384];
        int uncompressedBufferPosition = 0;
        while (!this.isEndOfInputStream && (uncompressedBufferPosition == 0 || this.brotliStreamDeCompressor.needsMoreInput())) {
            int inLength = this.inputStream.read(in);
            if (inLength > 0) {
                DeCompressorResult result = this.brotliStreamDeCompressor.deCompress(in, 0, inLength, uncompressedBuffer, uncompressedBufferPosition, uncompressedBuffer.length - uncompressedBufferPosition);
                if (result.bytesConsumed < inLength) {
                    throw new IOException("Compressor did not consume all input");
                }
                uncompressedBufferPosition += result.bytesProduced;
                continue;
            }
            this.isEndOfInputStream = true;
        }
        this.uncompressedInputStreamDelegate = new ByteArrayInputStream(uncompressedBuffer, 0, uncompressedBufferPosition);
    }
}

