/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.meteogroup.jbrotli.Brotli;
import org.meteogroup.jbrotli.BrotliErrorChecker;
import org.meteogroup.jbrotli.BrotliException;

public final class BrotliStreamCompressor
implements Closeable {
    private final long brotliCompressorInstanceRef = 0L;

    public BrotliStreamCompressor() {
        this(Brotli.DEFAULT_PARAMETER);
    }

    public BrotliStreamCompressor(Brotli.Parameter parameter) throws BrotliException {
        BrotliErrorChecker.assertBrotliOk(this.initBrotliCompressor(parameter.getMode().mode, parameter.getQuality(), parameter.getLgwin(), parameter.getLgblock()));
    }

    public final byte[] compressArray(byte[] in, boolean doFlush) {
        return this.compressArray(in, 0, in.length, doFlush);
    }

    public final byte[] compressArray(byte[] in, int inPosition, int inLength, boolean doFlush) {
        if (inPosition + inLength > in.length) {
            throw new IllegalArgumentException("The source position + length must me smaller then the source byte array's length.");
        }
        return this.compressBytes(in, inPosition, inLength, doFlush);
    }

    public final ByteBuffer compressNext(ByteBuffer in, boolean doFlush) {
        ByteBuffer out;
        int inPosition = in.position();
        int inLimit = Math.min(in.limit(), inPosition + this.getMaxInputBufferSize());
        int inRemain = inLimit - inPosition;
        if (inRemain < 0) {
            throw new IllegalArgumentException("The source (in) position must me smaller then the source ByteBuffer's limit.");
        }
        if (in.isDirect()) {
            out = this.compressByteBuffer(in, inPosition, inRemain, doFlush);
        } else if (in.hasArray()) {
            out = ByteBuffer.wrap(this.compressBytes(in.array(), inPosition + in.arrayOffset(), inRemain, doFlush));
        } else {
            throw new UnsupportedOperationException("Not supported ByteBuffer implementation. Use either direct BB or wrapped byte arrays. You may raise an issue on GitHub too ;-)");
        }
        in.position(inLimit);
        return out;
    }

    public final int getMaxInputBufferSize() throws BrotliException {
        return BrotliErrorChecker.assertBrotliOk(this.getInputBlockSize());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void close() throws BrotliException {
        BrotliErrorChecker.assertBrotliOk(this.freeNativeResources());
    }

    private static native int initJavaFieldIdCache();

    private native int getInputBlockSize();

    private native int initBrotliCompressor(int var1, int var2, int var3, int var4);

    private native int freeNativeResources();

    private native byte[] compressBytes(byte[] var1, int var2, int var3, boolean var4);

    private native ByteBuffer compressByteBuffer(ByteBuffer var1, int var2, int var3, boolean var4);

    static {
        BrotliErrorChecker.assertBrotliOk(BrotliStreamCompressor.initJavaFieldIdCache());
    }
}

