/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli;

import org.meteogroup.jbrotli.BrotliException;

class BrotliErrorChecker {
    BrotliErrorChecker() {
    }

    static boolean isBrotliOk(int errorCode) {
        return errorCode >= 0;
    }

    static int assertBrotliOk(int errorCodeOrSizeInformation) throws BrotliException {
        if (!BrotliErrorChecker.isBrotliOk(errorCodeOrSizeInformation)) {
            throw new BrotliException(BrotliErrorChecker.resolveErrorCode2Message(errorCodeOrSizeInformation));
        }
        return errorCodeOrSizeInformation;
    }

    private static String resolveErrorCode2Message(int errorCode) {
        if (BrotliErrorChecker.isBrotliOk(errorCode)) {
            return null;
        }
        String msg = " (Error code: " + errorCode + ")";
        switch (errorCode) {
            case -1: {
                return "An error happened inside JNI function call. Maybe OOME or other issues." + msg;
            }
            case -42: 
            case -32: {
                return "Decoding error, e.g. corrupt input or no memory left." + msg;
            }
            case -43: 
            case -33: {
                return "Decompression partially done, but must be invoked again with more input." + msg;
            }
            case -44: 
            case -34: {
                return "Decompression partially done, but must be invoked again with more output." + msg;
            }
            case -22: {
                return "Error in native Brotli library 'COMPRESS_ByteBuffer_BrotliCompressBuffer'." + msg;
            }
            case -14: {
                return "Error in native Brotli library 'COMPRESS_BrotliCompressBuffer'. Most likely, your compress buffer (output) is too small, please make it larger. " + msg;
            }
            case -10: {
                return "Error in native Brotli library 'COMPRESS_GetPrimitiveArrayCritical_INBUF'." + msg;
            }
            case -11: {
                return "Error in native Brotli library 'COMPRESS_GetPrimitiveArrayCritical_OUTBUF'." + msg;
            }
            case -12: {
                return "Error in native Brotli library 'COMPRESS_ReleasePrimitiveArrayCritical_OUTBUF'." + msg;
            }
            case -13: {
                return "Error in native Brotli library 'COMPRESS_ReleasePrimitiveArrayCritical_INBUF'." + msg;
            }
            case -20: {
                return "Error in native Brotli library 'COMPRESS_ByteBuffer_GetDirectBufferAddress_INBUF'." + msg;
            }
            case -21: {
                return "Error in native Brotli library 'COMPRESS_ByteBuffer_GetDirectBufferAddress_OUTBUF'." + msg;
            }
            case -30: {
                return "Error in native Brotli library 'DECOMPRESS_GetPrimitiveArrayCritical_INBUF'." + msg;
            }
            case -31: {
                return "Error in native Brotli library 'DECOMPRESS_GetPrimitiveArrayCritical_OUTBUF'." + msg;
            }
            case -35: {
                return "Error in native Brotli library 'DECOMPRESS_ReleasePrimitiveArrayCritical_OUTBUF'." + msg;
            }
            case -36: {
                return "Error in native Brotli library 'DECOMPRESS_ReleasePrimitiveArrayCritical_INBUF'." + msg;
            }
            case -40: {
                return "Error in native Brotli library 'DECOMPRESS_ByteBuffer_GetDirectBufferAddress_INBUF'." + msg;
            }
            case -41: {
                return "Error in native Brotli library 'DECOMPRESS_ByteBuffer_GetDirectBufferAddress_OUTBUF'." + msg;
            }
            case -2: {
                return "Error in native Brotli library 'NATIVE_GET_FIELD_ID_ERROR'." + msg;
            }
        }
        return "Error in native Brotli library." + msg;
    }
}

