/*
 * Decompiled with CFR 0.152.
 */
package org.meteogroup.jbrotli;

import java.nio.ByteBuffer;
import org.meteogroup.jbrotli.Brotli;
import org.meteogroup.jbrotli.BrotliErrorChecker;
import org.meteogroup.jbrotli.BrotliException;

public final class BrotliCompressor {
    public final int compress(Brotli.Parameter parameter, byte[] in, byte[] out) throws BrotliException {
        return this.compress(parameter, in, 0, in.length, out, 0, out.length);
    }

    public final int compress(Brotli.Parameter parameter, byte[] in, int inPosition, int inLength, byte[] out, int outPosition, int outLength) throws BrotliException {
        if (inPosition + inLength > in.length) {
            throw new IllegalArgumentException("The input array position and length must me smaller then the source byte array's length.");
        }
        if (outPosition + outLength > out.length) {
            throw new IllegalArgumentException("The output position and length must me smaller then the source byte array's length.");
        }
        return BrotliErrorChecker.assertBrotliOk(BrotliCompressor.compressBytes(parameter.getMode().mode, parameter.getQuality(), parameter.getLgwin(), parameter.getLgblock(), in, inPosition, inLength, out, outPosition, outLength));
    }

    public final int compress(Brotli.Parameter parameter, ByteBuffer in, ByteBuffer out) throws BrotliException {
        int computedOutLength;
        int inPosition = in.position();
        int inLimit = in.limit();
        int inRemain = inLimit - inPosition;
        if (inRemain <= 0) {
            throw new IllegalArgumentException("The source (in) position must me smaller then the source ByteBuffer's limit.");
        }
        int outPosition = out.position();
        int outLimit = out.limit();
        int outRemain = outLimit - outPosition;
        if (outRemain <= 0) {
            throw new IllegalArgumentException("The destination (out) position must me smaller then the source ByteBuffer's limit.");
        }
        if (in.isDirect() && out.isDirect()) {
            computedOutLength = BrotliErrorChecker.assertBrotliOk(BrotliCompressor.compressByteBuffer(parameter.getMode().mode, parameter.getQuality(), parameter.getLgwin(), parameter.getLgblock(), in, inPosition, inRemain, out, outPosition, outRemain));
        } else if (in.hasArray() && out.hasArray()) {
            computedOutLength = BrotliErrorChecker.assertBrotliOk(BrotliCompressor.compressBytes(parameter.getMode().mode, parameter.getQuality(), parameter.getLgwin(), parameter.getLgblock(), in.array(), inPosition + in.arrayOffset(), inRemain, out.array(), outPosition + out.arrayOffset(), outRemain));
        } else {
            throw new UnsupportedOperationException("Not supported ByteBuffer implementation. Both (input and output) buffer has to be of the same type. Use either direct BB or wrapped byte arrays. You may raise an issue on GitHub too ;-)");
        }
        in.position(inLimit);
        out.position(outPosition);
        out.limit(outPosition + computedOutLength);
        return computedOutLength;
    }

    private static native int compressBytes(int var0, int var1, int var2, int var3, byte[] var4, int var5, int var6, byte[] var7, int var8, int var9);

    private static native int compressByteBuffer(int var0, int var1, int var2, int var3, ByteBuffer var4, int var5, int var6, ByteBuffer var7, int var8, int var9);
}

