/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.brotli;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;
import org.meteogroup.jbrotli.Brotli;
import org.meteogroup.jbrotli.BrotliStreamCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrotliCompressor
implements Compressor {
    private static final Logger LOG = LoggerFactory.getLogger(BrotliCompressor.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0);
    private final StackTraceElement[] stack;
    private Brotli.Parameter parameter = new Brotli.Parameter().setMode(Brotli.Mode.GENERIC).setQuality(1);
    private BrotliStreamCompressor compressor = null;
    private int maxBufferSize = 0;
    private ByteBuffer inBuffer = ByteBuffer.allocateDirect(8192);
    private ByteBuffer outBuffer = EMPTY_BUFFER;
    private boolean compressing = false;
    private boolean shouldFinish = false;
    private boolean flushed = false;
    private int totalBytesIn = 0;
    private int totalBytesOut = 0;

    public BrotliCompressor(Configuration conf) {
        this.reinit(conf);
        this.stack = Thread.currentThread().getStackTrace();
    }

    private boolean isOutputBufferEmpty() {
        return this.outBuffer.remaining() == 0;
    }

    private boolean hasMoreOutput() {
        return this.outBuffer.hasRemaining();
    }

    public void setInput(byte[] inBytes, int off, int len) {
        Preconditions.checkState((boolean)this.isOutputBufferEmpty(), (Object)"[BUG] setInput called with non-empty output buffer");
        Preconditions.checkState((!this.compressing ? 1 : 0) != 0, (Object)"[BUG] setInput called while compressing the input buffer");
        Preconditions.checkState((this.inBuffer.remaining() > this.inBuffer.capacity() >> 1 ? 1 : 0) != 0, (Object)"[BUG] setInput called with a full input buffer");
        this.ensureCapacity(len);
        int bytesToCopy = Math.min(len, this.inBuffer.remaining());
        Preconditions.checkState((bytesToCopy == len ? 1 : 0) != 0, (Object)"[BUG] Cannot copy the entire input");
        this.inBuffer.put(inBytes, off, bytesToCopy);
        if (this.shouldFinish || this.inBuffer.remaining() <= this.inBuffer.capacity() >> 1) {
            this.compress(this.shouldFinish);
        }
        this.totalBytesIn += len;
    }

    private void ensureCapacity(int size) {
        int targetCapacity = this.inBuffer.capacity() / 2;
        if (targetCapacity > size) {
            return;
        }
        while (targetCapacity < size) {
            targetCapacity *= 2;
        }
        ByteBuffer oldBuffer = this.inBuffer;
        this.inBuffer = ByteBuffer.allocateDirect(targetCapacity * 2);
        oldBuffer.flip();
        this.inBuffer.put(oldBuffer);
    }

    private void compress(boolean flush) {
        if (!this.compressing) {
            this.compressing = true;
            this.inBuffer.flip();
        }
        ByteBuffer toCompress = this.inBuffer.duplicate();
        boolean last = true;
        if (toCompress.remaining() > this.maxBufferSize) {
            toCompress.limit(toCompress.position() + this.maxBufferSize);
            last = false;
        }
        this.outBuffer = this.compressor.compressNext(toCompress, last && flush);
        this.inBuffer.position(toCompress.position());
        if (!this.inBuffer.hasRemaining()) {
            this.flushed = flush;
            this.inBuffer.clear();
            this.compressing = false;
        }
    }

    public boolean needsInput() {
        return !this.compressing && this.isOutputBufferEmpty();
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("Brotli does not support dictionaries");
    }

    public long getBytesRead() {
        return this.totalBytesOut;
    }

    public long getBytesWritten() {
        return this.totalBytesIn;
    }

    public void finish() {
        this.shouldFinish = true;
    }

    public boolean finished() {
        return this.shouldFinish && this.flushed && this.isOutputBufferEmpty() && !this.compressing;
    }

    public int compress(byte[] out, int off, int len) throws IOException {
        int bytesCopied = 0;
        if (this.isOutputBufferEmpty()) {
            if (this.compressing) {
                this.compress(this.shouldFinish);
            } else if (this.shouldFinish && !this.flushed) {
                this.compress(true);
            }
        }
        if (this.hasMoreOutput()) {
            int bytesToCopy = Math.min(len, this.outBuffer.remaining());
            this.outBuffer.get(out, off, bytesToCopy);
            bytesCopied += bytesToCopy;
        }
        this.totalBytesOut += bytesCopied;
        return bytesCopied;
    }

    public void reset() {
        this.end();
        Preconditions.checkState((this.totalBytesIn == 0 || this.flushed && !this.compressing && this.inBuffer.position() == 0 ? 1 : 0) != 0, (Object)"Reused without consuming all input");
        Preconditions.checkState((boolean)this.isOutputBufferEmpty(), (Object)"Reused without consuming all output");
        this.compressor = new BrotliStreamCompressor(this.parameter);
        this.maxBufferSize = this.compressor.getMaxInputBufferSize();
        this.inBuffer.clear();
        this.outBuffer = EMPTY_BUFFER;
        this.compressing = false;
        this.shouldFinish = false;
        this.flushed = false;
        this.totalBytesIn = 0;
        this.totalBytesOut = 0;
    }

    public void end() {
        if (this.compressing || this.inBuffer.position() > 0) {
            LOG.warn("Closed without consuming all input");
        } else if (!this.isOutputBufferEmpty()) {
            LOG.warn("Closed without consuming all output");
        }
        if (this.compressor != null) {
            this.compressor.close();
            this.compressor = null;
        }
    }

    public void reinit(Configuration conf) {
        if (conf != null) {
            this.parameter = this.parameter.setMode(conf.getBoolean("compression.brotli.is-text", false) ? Brotli.Mode.TEXT : Brotli.Mode.GENERIC).setQuality(conf.getInt("compression.brotli.quality", 1));
        }
        this.compressor = new BrotliStreamCompressor(this.parameter);
        this.maxBufferSize = this.compressor.getMaxInputBufferSize();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.compressor != null) {
            this.end();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.stack, 1, this.stack.length));
            LOG.warn("Unclosed Brotli compression stream created by:\n\t" + trace);
        }
    }
}

