/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.brotli.BrotliCompressor;
import org.apache.hadoop.io.compress.brotli.BrotliDecompressor;
import org.meteogroup.jbrotli.libloader.BrotliLibraryLoader;

public class BrotliCodec
extends Configured
implements CompressionCodec {
    public static final String IS_TEXT_PROP = "compression.brotli.is-text";
    public static final String QUALITY_LEVEL_PROP = "compression.brotli.quality";
    private static boolean LOADED_NATIVE_LIB = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BrotliCodec() {
        if (LOADED_NATIVE_LIB) return;
        Class<BrotliCodec> clazz = BrotliCodec.class;
        synchronized (BrotliCodec.class) {
            if (LOADED_NATIVE_LIB) return;
            BrotliLibraryLoader.loadBrotli();
            LOADED_NATIVE_LIB = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return new BrotliCompressorStream(out, compressor);
    }

    public Class<? extends Compressor> getCompressorType() {
        return BrotliCompressor.class;
    }

    public Compressor createCompressor() {
        return new BrotliCompressor(this.getConf());
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new BrotliDecompressorStream(in, decompressor);
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return BrotliDecompressor.class;
    }

    public Decompressor createDecompressor() {
        return new BrotliDecompressor();
    }

    public String getDefaultExtension() {
        return ".br";
    }

    private static class BrotliDecompressorStream
    extends DecompressorStream {
        public BrotliDecompressorStream(InputStream in, Decompressor decompressor, int bufferSize) throws IOException {
            super(in, decompressor, bufferSize);
        }

        public BrotliDecompressorStream(InputStream in, Decompressor decompressor) throws IOException {
            super(in, decompressor);
        }

        public void close() throws IOException {
            super.close();
            this.decompressor.end();
        }
    }

    private static class BrotliCompressorStream
    extends CompressorStream {
        public BrotliCompressorStream(OutputStream out, Compressor compressor, int bufferSize) {
            super(out, compressor, bufferSize);
        }

        public BrotliCompressorStream(OutputStream out, Compressor compressor) {
            super(out, compressor);
        }

        public void close() throws IOException {
            super.close();
            this.compressor.end();
        }
    }
}

