/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.app.Dialog;
import android.view.View;
import androidx.fragment.app.DialogFragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupComponent;
import razerdp.basepopup.BasePopupWindow;

public class BasePopupComponentX
implements BasePopupComponent {
    public View findDecorView(BasePopupWindow basePopupWindow, Activity activity) {
        DialogFragment d;
        if (basePopupWindow.mAttached == null) {
            return null;
        }
        Object object = basePopupWindow.mAttached.get();
        if (object instanceof DialogFragment && (d = (DialogFragment)object).getDialog() != null && d.getDialog().isShowing() && !d.isRemoving()) {
            return d.getView();
        }
        if (object instanceof Dialog && (d = (Dialog)object).isShowing() && d.getWindow() != null) {
            return d.getWindow().getDecorView();
        }
        return null;
    }

    public BasePopupWindow attachLifeCycle(BasePopupWindow basePopupWindow, Object owner) {
        if (!(owner instanceof LifecycleOwner) || basePopupWindow.lifeCycleObserver != null) {
            return basePopupWindow;
        }
        ((LifecycleOwner)owner).getLifecycle().addObserver((LifecycleObserver)new BasePopupLifeCycleHolder(basePopupWindow));
        return basePopupWindow;
    }

    public BasePopupWindow removeLifeCycle(BasePopupWindow basePopupWindow, Object owner) {
        if (!(owner instanceof LifecycleOwner) || basePopupWindow.lifeCycleObserver == null) {
            return basePopupWindow;
        }
        ((LifecycleOwner)owner).getLifecycle().removeObserver((LifecycleObserver)basePopupWindow.lifeCycleObserver);
        basePopupWindow.lifeCycleObserver = null;
        return basePopupWindow;
    }

    private class BasePopupLifeCycleHolder
    implements LifecycleObserver {
        WeakReference<BasePopupWindow> mBasePopupWindow;

        BasePopupLifeCycleHolder(BasePopupWindow target) {
            this.mBasePopupWindow = new WeakReference<BasePopupWindow>(target);
            target.lifeCycleObserver = this;
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        protected void onActivityDestroy() {
            BasePopupWindow popupWindow = this.getPopup();
            if (popupWindow == null) {
                return;
            }
            if (popupWindow.isShowing()) {
                popupWindow.forceDismiss();
            }
            if (popupWindow.getContext() instanceof LifecycleOwner) {
                BasePopupComponentX.this.removeLifeCycle(popupWindow, popupWindow.getContext());
            }
        }

        BasePopupWindow getPopup() {
            if (this.mBasePopupWindow == null) {
                return null;
            }
            return (BasePopupWindow)this.mBasePopupWindow.get();
        }
    }
}

